<?php
require __DIR__.'/includes/auth.php';
require __DIR__.'/includes/config.php';
require __DIR__.'/includes/db_connect.php';
require_once __DIR__.'/includes/jdf.php'; // اضافه شد

$user = $_SESSION['username'];
$role = $_SESSION['role'] ?? '';
$is_admin = ($role === 'admin');

// فرمت عدد
function nf($n){return number_format((int)$n,0,'.',',');}

// تبدیل تاریخ میلادی به شمسی با اعداد انگلیسی
if(!function_exists('toJalaliEn')){
  function toJalaliEn($date){
    if(!$date || !preg_match('/^\d{4}-\d{2}-\d{2}/',$date)) return '-';
    list($gy,$gm,$gd) = explode('-', substr($date,0,10));
    if(!function_exists('gregorian_to_jalali')) return $date;
    return gregorian_to_jalali((int)$gy,(int)$gm,(int)$gd,'/');
  }
}
?>
<!doctype html>
<html lang="fa" dir="rtl">
<meta charset="utf-8">
<title>📊 داشبورد مالی | سلام‌بابا</title>
<link rel="stylesheet" href="assets/style.css">
<style>
/* ====== طراحی عمومی ====== */
body {
  font-family: 'IRANYekan', sans-serif;
  background: #f5f7fa;
  color: #1f2937;
  margin: 0;
  padding: 0;
}
.container {
  max-width: 1200px;
  margin: 0 auto;
  padding: 20px;
}

/* ====== کارت‌ها ====== */
.card {
  background: #fff;
  border-radius: 16px;
  box-shadow: 0 2px 8px rgba(0,0,0,0.05);
  padding: 25px;
  margin-bottom: 20px;
}

/* ====== بخش آمار خلاصه ====== */
.stats {
  display: flex;
  flex-wrap: wrap;
  gap: 15px;
  justify-content: center;
  text-align: center;
  margin-top: 10px;
}
.stat {
  flex: 1 1 180px;
  background: #ffffff;
  border-radius: 14px;
  padding: 20px;
  box-shadow: 0 2px 6px rgba(0,0,0,0.08);
  border: 1px solid #e5e7eb;
  transition: all 0.2s ease;
}
.stat:hover {
  transform: translateY(-3px);
  box-shadow: 0 4px 12px rgba(0,0,0,0.1);
}
.stat b {
  font-size: 20px;
  color: #111827;
}
.stat:nth-child(1) b { color: #0ea5e9; } /* بیعانه‌ها */
.stat:nth-child(2) b { color: #f97316; } /* برداشت‌ها */
.stat:nth-child(3) b { color: #22c55e; } /* مانده */

/* ====== فرم فیلتر ماه ====== */
form {
  text-align: center;
  margin: 25px 0 15px;
}
form label {
  font-weight: bold;
  color: #374151;
}
form input[type="month"] {
  padding: 6px 10px;
  border-radius: 8px;
  border: 1px solid #ccc;
  font-family: inherit;
  font-size: 14px;
  background: #fff;
  transition: all .2s;
}
form input[type="month"]:focus {
  outline: none;
  border-color: #2563eb;
  box-shadow: 0 0 0 2px rgba(37,99,235,0.1);
}
form button {
  background: #2563eb;
  color: #fff;
  border: none;
  padding: 6px 14px;
  border-radius: 8px;
  cursor: pointer;
  margin-right: 5px;
  font-family: inherit;
  transition: background .2s;
}
form button:hover { background: #1d4ed8; }

/* ====== جدول‌ها ====== */
.table-wrapper {
  overflow-x: auto;
  background: #fff;
  border-radius: 12px;
  box-shadow: 0 2px 6px rgba(0,0,0,0.05);
  padding: 10px;
}
.finance-table, #sellerTable {
  width: 100%;
  border-collapse: collapse;
  font-size: 14px;
  min-width: 800px;
}
.finance-table th, .finance-table td,
#sellerTable th, #sellerTable td {
  padding: 10px;
  border-bottom: 1px solid #f1f5f9;
  text-align: center;
  white-space: nowrap;
}
.finance-table th, #sellerTable th {
  background: #f8fafc;
  font-weight: 600;
  color: #111827;
}
.finance-table tr:nth-child(even),
#sellerTable tr:nth-child(even) {
  background: #fafafa;
}
.finance-table tr:hover,
#sellerTable tr:hover {
  background: #eef2ff;
}
.finance-table td {
  color: #374151;
}

/* ====== دکمه‌ها ====== */
.btn {
  background: #2563eb;
  color: #fff;
  padding: 5px 10px;
  border-radius: 8px;
  font-size: 13px;
  text-decoration: none;
  transition: all .2s;
}
.btn:hover {
  background: #1d4ed8;
}
.btn.ghost {
  background: #f3f4f6;
  color: #1f2937;
}
.btn.ghost:hover {
  background: #e5e7eb;
}

/* ====== بخش صفحه‌بندی ====== */
.pagination {
  display: flex;
  justify-content: center;
  gap: 6px;
  margin: 15px 0;
}
.pagination button {
  border: none;
  padding: 6px 10px;
  border-radius: 6px;
  background: #e5e7eb;
  color: #374151;
  cursor: pointer;
  transition: background .2s;
}
.pagination button.active {
  background: #2563eb;
  color: #fff;
  font-weight: bold;
}
.pagination button:hover {
  background: #dbeafe;
}

/* ====== حالت موبایل ====== */
@media (max-width: 768px) {
  body { font-size: 13px; }
  .stat { padding: 15px; flex: 1 1 140px; }
  .finance-table, #sellerTable { font-size: 12.5px; }
  th, td { padding: 6px; }
}

</style>

<body>
<div class="container">
<?php require __DIR__.'/includes/header.php'; ?>

<section class="card">
  <h3>💰 داشبورد مالی</h3>

<?php if($is_admin): ?>
  <input type="text" id="searchBox" placeholder="🔍 جستجو در فروشنده‌ها...">
  <div class="table-wrapper">
  <table id="sellerTable">
    <thead>
      <tr>
        <th data-type="text">👤 فروشنده</th>
        <th data-type="text">نام کامل</th>
        <th data-type="num">بیعانه‌ها</th>
        <th data-type="num">برداشت‌ها</th>
        <th data-type="num">مانده حساب</th>
      </tr>
    </thead>
    <tbody>
    <?php
    $res = $mysqli->query("
      SELECT username, full_name, balance,
        (SELECT COALESCE(SUM(total_deposit),0) FROM orders WHERE username=u.username) AS total_deposit,
        (SELECT COALESCE(SUM(w.amount),0)
          FROM withdrawals w
          JOIN orders o ON o.id=w.order_id
          WHERE o.username=u.username) AS total_withdraw
      FROM users u
      WHERE role='seller'
      ORDER BY username
    ");
    while($r = $res->fetch_assoc()):
      $remain = (int)$r['balance'];
      $color = $remain >= 0 ? 'green' : 'red';
    ?>
      <tr>
        <td><a href="seller_finance.php?username=<?=urlencode($r['username'])?>"><?=htmlspecialchars($r['username'])?></a></td>
        <td><?=htmlspecialchars($r['full_name'])?></td>
        <td><?=nf($r['total_deposit'])?></td>
        <td><?=nf($r['total_withdraw'])?></td>
        <td style="color:<?=$color?>;font-weight:bold;"><?=nf($remain)?></td>
      </tr>
    <?php endwhile; ?>
    </tbody>
  </table>
  </div>
  <div class="pagination" id="pagination"></div>

<?php else: ?>
  <?php
  $stmt = $mysqli->prepare("
    SELECT
      COALESCE(SUM(total_deposit),0) AS total_deposit,
      (
        SELECT COALESCE(SUM(w.amount),0)
        FROM withdrawals w
        JOIN orders o2 ON o2.id=w.order_id
        WHERE o2.username=?
      ) AS total_withdraw,
      (SELECT balance FROM users WHERE username=?) AS balance
    FROM orders o
    WHERE username=?
  ");
  $stmt->bind_param('sss',$user,$user,$user);
  $stmt->execute();
  $data = $stmt->get_result()->fetch_assoc();
  $remain = (int)$data['balance'];
  $total_deposit = (int)$data['total_deposit'];
  $total_withdraw = (int)$data['total_withdraw'];
  ?>
  <div class="stats">
    <div class="stat">💵 جمع بیعانه‌ها<br><b><?=nf($total_deposit)?></b> تومان</div>
    <div class="stat">💸 جمع برداشت‌ها<br><b><?=nf($total_withdraw)?></b> تومان</div>
    <div class="stat">🏦 مانده حساب<br><b style="color:<?=($remain>=0?'green':'red')?>"><?=nf($remain)?></b> تومان</div>
  </div>
<?php endif; ?>
</section>

<hr>

<?php
// ===== فیلتر ماهیانه =====
$month = $_GET['month'] ?? date('Y-m');
list($y,$m)=explode('-',$month);
$monthStart="$y-$m-01 00:00:00";
$monthEnd=date('Y-m-t 23:59:59',strtotime($monthStart));

// ===== خواندن تراکنش‌ها =====
$stmt = $mysqli->prepare("
  SELECT 
    o.id AS order_id,
    o.customer_name,
    o.created_at,
    o.total_deposit,
    COALESCE(SUM(w.amount),0) AS total_withdraw
  FROM orders o
  LEFT JOIN withdrawals w ON w.order_id=o.id
  WHERE o.username=? AND o.created_at BETWEEN ? AND ?
  GROUP BY o.id
  ORDER BY o.created_at DESC
");
$stmt->bind_param('sss',$user,$monthStart,$monthEnd);
$stmt->execute();
$res = $stmt->get_result();
?>

<form method="get" style="text-align:center;margin:15px 0;">
  <label>ماه:</label>
  <input type="month" name="month" value="<?=$month?>">
  <button type="submit">نمایش</button>
</form>

<div class="table-wrapper">
  <table class="finance-table">
    <thead>
      <tr>
        <th>#</th>
        <th>نام مشتری</th>
        <th>تاریخ فاکتور</th>
        <th>بیعانه</th>
        <th>برداشت</th>
        <th>مانده پس از تراکنش</th>
        <th>عملیات</th>
      </tr>
    </thead>
    <tbody>
      <?php
      $i=1;
      $runningBalance = 0;
      while($r=$res->fetch_assoc()):
        $deposit = (int)$r['total_deposit'];
        $withdraw = (int)$r['total_withdraw'];
        $runningBalance += $deposit - $withdraw;
      ?>
      <tr>
        <td><?=$i++?></td>
        <td><?=htmlspecialchars($r['customer_name'])?></td>
        <td><?=toJalaliEn(substr($r['created_at'],0,10))?></td>
        <td><?=nf($deposit)?></td>
        <td><?=nf($withdraw)?></td>
        <td style="color:<?=($runningBalance>=0?'green':'red')?>"><?=nf($runningBalance)?></td>
        <td>
          <a href="view_order.php?id=<?=$r['order_id']?>" class="btn">👁 مشاهده</a>
          <a href="edit_order.php?id=<?=$r['order_id']?>" class="btn ghost">✏️ ویرایش</a>
        </td>
      </tr>
      <?php endwhile; ?>
      <?php if($i===1): ?>
      <tr><td colspan="7">📭 در این ماه هیچ تراکنشی ثبت نشده است.</td></tr>
      <?php endif; ?>
    </tbody>
  </table>
</div>

<style>
.finance-table {
  width:100%;border-collapse:collapse;font-family:'IRANYekan',sans-serif;
  background:#fff;border-radius:10px;overflow:hidden;
}
.finance-table th, .finance-table td {
  padding:8px 10px;text-align:center;border-bottom:1px solid #eee;
}
.finance-table th {background:#f8fafc;font-weight:600;}
.finance-table tr:nth-child(even){background:#fafafa;}
.finance-table .btn {
  background:#007bff;color:#fff;padding:3px 8px;
  border-radius:6px;text-decoration:none;font-size:13px;
}
.finance-table .btn.ghost {background:#f1f1f1;color:#333;}
@media(max-width:768px){
  .finance-table{font-size:13px;}
  .finance-table th,.finance-table td{padding:6px;}
}
</style>

<script>
// ====================== مرتب‌سازی، جستجو و صفحه‌بندی ======================
const rowsPerPage = 15;
let currentPage = 1;
let sortDir = 'asc';
let sortIndex = -1;

const table = document.getElementById('sellerTable');
if (table) {
  const tbody = table.querySelector('tbody');
  let rows = Array.from(tbody.querySelectorAll('tr'));

  function renderTable() {
    const searchVal = document.getElementById('searchBox').value.trim().toLowerCase();
    let filtered = rows.filter(r =>
      r.innerText.toLowerCase().includes(searchVal)
    );

    if (sortIndex >= 0) {
      const th = table.querySelectorAll('th')[sortIndex];
      const type = th.dataset.type;
      filtered.sort((a,b)=>{
        let A=a.cells[sortIndex].innerText.replace(/,/g,'').trim();
        let B=b.cells[sortIndex].innerText.replace(/,/g,'').trim();
        if(type==='num'){A=parseFloat(A)||0;B=parseFloat(B)||0;}
        else {A=A.toLowerCase();B=B.toLowerCase();}
        return sortDir==='asc' ? (A>B?1:-1) : (A<B?1:-1);
      });
    }

    const totalPages = Math.ceil(filtered.length / rowsPerPage);
    currentPage = Math.min(currentPage, totalPages) || 1;
    const start = (currentPage - 1) * rowsPerPage;
    const pageRows = filtered.slice(start, start + rowsPerPage);

    tbody.innerHTML = '';
    pageRows.forEach(r => tbody.appendChild(r));
    renderPagination(totalPages);
  }

  function renderPagination(totalPages) {
    const p = document.getElementById('pagination');
    p.innerHTML = '';
    for(let i=1;i<=totalPages;i++){
      const b=document.createElement('button');
      b.textContent=i;
      if(i===currentPage) b.classList.add('active');
      b.onclick=()=>{currentPage=i;renderTable();};
      p.appendChild(b);
    }
  }

  table.querySelectorAll('th').forEach((th,i)=>{
    th.addEventListener('click',()=>{
      if(sortIndex===i) sortDir = sortDir==='asc'?'desc':'asc';
      else { sortIndex=i; sortDir='asc'; }
      table.querySelectorAll('th').forEach(t=>t.classList.remove('sort-asc','sort-desc'));
      th.classList.add(sortDir==='asc'?'sort-asc':'sort-desc');
      renderTable();
    });
  });

  document.getElementById('searchBox').addEventListener('input',()=>{currentPage=1;renderTable();});
  renderTable();
}
</script>
</div>
</body>
</html>
