<?php
require __DIR__ . '/../includes/auth.php';
require __DIR__ . '/../includes/config.php';
require __DIR__ . '/../includes/db_connect.php';
require __DIR__ . '/../includes/header.php'; // ← هدر پروژه

$role = $_SESSION['role'] ?? '';
$login_user = $_SESSION['username'] ?? '';
?>

<!doctype html>
<html lang="fa" dir="rtl">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1">

<title>برداشت از حساب — سلام‌بابا</title>

<link rel="stylesheet" href="../assets/style.css">

<style>
  /* استایل تخصصی فرم مالی */
  body {
    background:#f3f4f6;
    font-family: IRANSansWeb, sans-serif;
  }
  .card {
    background:#ffffff;
    padding:30px;
    max-width:600px;
    margin:30px auto;
    border-radius:16px;
    border:1px solid #e2e8f0;
    box-shadow:0 2px 7px rgba(0,0,0,0.04);
  }
  h2 {
    margin:0 0 20px 0;
    font-size:22px;
    font-weight:700;
    color:#0f172a;
  }
  label {
    display:block;
    margin-top:15px;
    font-size:15px;
    font-weight:600;
    color:#334155;
  }
  input, select, textarea {
    width:100%;
    margin-top:6px;
    padding:10px 12px;
    font-size:15px;
    border-radius:10px;
    border:1px solid #d1d5db;
    background:#f9fafb;
  }
  button {
    width:100%;
    margin-top:25px;
    padding:14px;
    font-size:17px;
    border:none;
    border-radius:12px;
    background:#0ea5e9;
    color:white;
    cursor:pointer;
    font-weight:600;
    transition:0.2s;
  }
  button:hover { background:#0284c7; }

  #result {
    margin-top:20px;
    font-size:16px;
    font-weight:bold;
    text-align:center;
  }
</style>

</head>
<body>

<div class="card">

  <h2>ثبت برداشت از حساب</h2>

  <form id="withdrawForm">

    <?php if($role === 'admin'): ?>
      <!-- مدیر می‌تواند فروشنده انتخاب کند -->
      <label>انتخاب فروشنده</label>
      <select name="username" required>
        <option value="">انتخاب کنید…</option>

        <?php
        $q = $mysqli->query("SELECT username FROM users WHERE role='seller' ORDER BY username ASC");
        while($u = $q->fetch_assoc()):
        ?>
        <option value="<?=htmlspecialchars($u['username'])?>">
          <?=htmlspecialchars($u['username'])?>
        </option>
        <?php endwhile; ?>
      </select>

    <?php else: ?>
      <!-- فروشنده فقط برای خودش برداشت می‌زند -->
      <input type="hidden" name="username" value="<?=$login_user?>">
      <div style="background:#eef6ff;padding:12px;border-radius:10px;margin-bottom:15px;border:1px solid #bfdbfe;">
        برداشت برای حساب: <strong><?=$login_user?></strong>
      </div>
    <?php endif; ?>

    <label>مبلغ برداشت (تومان)</label>
    <input type="number" name="amount" min="1000" placeholder="مثال: 5000000" required>

    <label>روش برداشت</label>
    <select name="method">
      <option value="bank">واریز بانکی</option>
      <option value="cash">نقدی</option>
      <option value="wallet">انتقال از کیف پول</option>
    </select>

    <label>توضیحات (اختیاری)</label>
    <textarea name="note" rows="3" placeholder="مثال: تسویه کمیسیون هفته دوم"></textarea>

    <button type="submit">ثبت برداشت</button>
  </form>

  <div id="result"></div>

</div>


<script>
document.getElementById('withdrawForm').addEventListener('submit', function(e){
    e.preventDefault();

    const formData = new FormData(this);

    fetch("withdraw.php", {
        method: "POST",
        body: formData
    })
    .then(res => res.text())
    .then(txt => {

        if(txt === "OK"){
            document.getElementById('result').style.color = "green";
            document.getElementById('result').innerText = "✔ برداشت با موفقیت ثبت شد";
            document.getElementById('withdrawForm').reset();
        }
        else if(txt === "balance_not_enough"){
            document.getElementById('result').style.color = "red";
            document.getElementById('result').innerText = "❌ موجودی کافی نیست!";
        }
        else if(txt === "seller_not_found"){
            document.getElementById('result').style.color = "red";
            document.getElementById('result').innerText = "❌ فروشنده پیدا نشد!";
        }
        else{
            document.getElementById('result').style.color = "red";
            document.getElementById('result').innerText = "❌ خطا: " + txt;
        }
    });
});
</script>

</body>
</html>
