<?php
require __DIR__.'/includes/db_connect.php';
require __DIR__.'/includes/config.php';
require_once __DIR__.'/includes/jdf.php';

$code = $_GET['code'] ?? '';
$code = $mysqli->real_escape_string($code);
$o = $mysqli->query("SELECT * FROM orders WHERE tracking_code='{$code}'")->fetch_assoc();

function nf($n){return number_format((int)$n,0,'.',',');}

function toJalaliEn($datetime){
  if(!$datetime || !preg_match('/^\d{4}-\d{2}-\d{2}/',$datetime)) return '-';
  list($date,$time) = array_pad(explode(' ', trim($datetime)), 2, '');
  list($gy,$gm,$gd)=explode('-',$date);
  $j = gregorian_to_jalali((int)$gy,(int)$gm,(int)$gd,'/');
  $j = strtr($j, ['۰'=>'0','۱'=>'1','۲'=>'2','۳'=>'3','۴'=>'4','۵'=>'5','۶'=>'6','۷'=>'7','۸'=>'8','۹'=>'9']);
  $time = substr($time,0,5);
  return trim($j.($time ? ' - '.$time : ''));
}
?>
<!doctype html>
<html lang="fa" dir="rtl">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width,initial-scale=1">
<title>پیگیری سفارش — سلام‌بابا</title>
<link rel="stylesheet" href="assets/track.css?v=5.0">
</head>
<body>
<div class="container">

  <div class="brand">
    <div class="logo">سلام‌بابا</div>
  </div>

  <div class="invoice-header">
    <div class="brand-strip"></div>
    <div class="invoice-top">
      <div class="invoice-title">
        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"><path d="M19 3H5a2 2 0 0 0-2 2v16l4-2 4 2 4-2 4 2V5a2 2 0 0 0-2-2z"/></svg>
        پیگیری سفارش
      </div><hr></hr>
      <?php if($o): ?>
      <div class="track-chip">
        <span class="label">کد پیگیری:</span>
        <span class="code"><?=htmlspecialchars($o['tracking_code'])?></span>
        <button class="copy-btn" onclick="navigator.clipboard.writeText('<?=htmlspecialchars($o['tracking_code'])?>')" title="کپی">
          <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"><path d="M16 1H4a2 2 0 0 0-2 2v14h2V3h12V1zm3 4H8a2 2 0 0 0-2 2v16h14a2 2 0 0 0 2-2V5z"/></svg>
        </button>
      </div>
      <?php endif; ?>
    </div>

    <?php if(!$o): ?>
      <div class="note error">سفارشی با این کد یافت نشد.</div>
    <?php else: ?>
      <div class="info-grid">
        <div class="info"><b>شماره فاکتور:</b> <?=htmlspecialchars($o['invoice_no'])?></div>
        <div class="info"><b>نام مشتری:</b> <?=htmlspecialchars($o['customer_name'])?></div>
        <div class="info"><b>تاریخ ثبت:</b> <?=htmlspecialchars(toJalaliEn($o['purchase_date']))?></div>
        <div class="info"><b>وضعیت:</b>
          <?php
         $status = strtolower(trim($o['status']));
switch($status){
  case 'pending':     $color = '#facc15'; break;
  case 'processing':  $color = '#3b82f6'; break;
  case 'delivered':   $color = '#10b981'; break;
  case 'canceled':
  case 'cancelled':   $color = '#ef4444'; break;
  default:            $color = '#6b7280'; break;
}

          ?>
          <span style="color:<?=$color?>;font-weight:700;"><?=htmlspecialchars($o['status'])?></span>
        </div>
      </div>

      <?php if($o['status_note']): ?>
        <div class="info" style="margin-top:10px;background:#f9fafb;border:1px solid #e5e7eb;">
          <b>یادداشت:</b> <?=nl2br(htmlspecialchars($o['status_note']))?>
        </div>
      <?php endif; ?>
    <?php endif; ?>
  </div>

  <?php
  if($o):
    $items = $mysqli->query("SELECT * FROM order_items WHERE order_id={$o['id']}");
    if($items && $items->num_rows > 0):
  ?>
  <div class="card">
    <div class="brand-strip"></div>
    <h3 class="invoice-title" style="margin-bottom:10px;">اقلام خریداری‌شده</h3>
    <div style="overflow-x:auto;">
      <table class="table">
        <thead>
          <tr>
            <th>مدل</th>
            <th>قیمت</th>
            <th>بیعانه</th>
            <th>مانده</th>
          </tr>
        </thead>
        <tbody>
          <?php 
            $total_price = $total_deposit = $total_remaining = 0;
            $models = [];
            while($it = $items->fetch_assoc()):
              $total_price += (int)$it['price'];
              $total_deposit += (int)$it['deposit'];
              $total_remaining += (int)$it['remaining'];
              if(trim($it['model'])) $models[] = trim($it['model']);
          ?>
          <tr>
            <td><?=htmlspecialchars($it['model'])?></td>
            <td><?=nf($it['price'])?> تومان</td>
            <td><?=nf($it['deposit'])?> تومان</td>
            <td><?=nf($it['remaining'])?> تومان</td>
          </tr>
          <?php endwhile; ?>
        </tbody>
      </table>
    </div>

    <div class="invoice-totals">
      <h3>خلاصه مالی</h3>
      <div class="totals-grid">
          
      <div class="total-models">
        <b>مدل کالاهای خریداری‌شده:</b>
        <span><?=count($models) ? implode('، ', $models) : '-'?></span>
      </div>
        <div class="total-box amount">
          <span>مجموع قیمت</span>
          <strong><?=nf($total_price)?> تومان</strong>
        </div>
        <div class="total-box deposit">
          <span>مجموع بیعانه</span>
          <strong><?=nf($total_deposit)?> تومان</strong>
        </div>
        <div class="total-box remaining">
          <span>مانده کل</span>
          <strong><?=nf($total_remaining)?> تومان</strong>
        </div>
      </div>

    </div>
  </div>
  <?php endif; endif; ?>

  <!-- ===========================
       راهنمای تحویل، پرداخت و نصب
       =========================== -->
  <div class="delivery-guide">
    <h2>راهنمای تحویل، پرداخت و نصب</h2>
    <p class="intro">
      برای تجربه خریدی مطمئن و بدون دغدغه، لطفاً پیش از تحویل سفارش نکات زیر را با دقت مطالعه کنید.  
      هدف <b>سلام‌بابا</b> این است که محصول شما را سالم، سریع و دقیق به دستتان برساند.
    </p>

    <div class="guide-grid">

      <div class="guide-card general">
        <div class="icon">⚠️</div>
        <h3>نکات عمومی</h3>
        <ul>
          <li>تحویل کالا فقط به خریدار یا فرد معرفی‌شده در فاکتور انجام می‌شود.</li>
          <li>هیچ‌کدام از رانندگان کارت‌خوان ندارند؛ اپلیکیشن بانکتان را آماده کنید.</li>
          <li>پیش از تسویه، کالا را تست کنید (صدا، تصویر و بدنه).</li>
          <li>پس از خروج باربر، مسئولیت خرابی یا آسیب با مشتری است.</li>
          <li>تحویل در ساعات غیرمعمول (بعد از نیمه‌شب) اجباری نیست.</li>
          <li>پرداخت انعام کاملاً اختیاری است؛ هیچ راننده‌ای حق اجبار ندارد.</li>
        </ul>
      </div>

      <div class="guide-card payment">
        <div class="icon">💳</div>
        <h3>شرایط پرداخت</h3>
        <ul>
          <li>پرداخت فقط از طریق انتقال حساب‌به‌حساب انجام می‌شود.</li>
          <li>پرداخت نقدی یا رمزارز پذیرفته نیست.</li>
          <li>در زمان تحویل، مبلغ فاکتور طبق شماره حساب اعلام‌شده پرداخت گردد.</li>
          <li>کسر مبلغ فقط با تأیید فروشگاه مجاز است.</li>
        </ul>
      </div>

      <div class="guide-card delivery">
        <div class="icon">🚚</div>
        <h3>تحویل کالا</h3>
        <ul>
          <li>تحویل بسته به مقصد و نوع کالا بین ۱ تا ۷ روز کاری است.</li>
          <li>راننده موظف است کالا را باز کرده و سلامت آن را بررسی کند.</li>
          <li>در ساختمان‌های بدون آسانسور، تحویل فقط تا محل تست انجام می‌شود.</li>
          <li>در صورت عدم حضور خریدار، هزینه ارسال مجدد دریافت می‌شود.</li>
          <li>در کالاهای سنگین یا مناطق دور، زمان تحویل ممکن است تا ۱۵ روز طول بکشد.</li>
        </ul>
      </div>

      <div class="guide-card install">
        <div class="icon">🧰</div>
        <h3>نکات نصب</h3>
        <ul>
          <li>نصب فقط باید توسط نصاب رسمی یا شرکت گارانتی انجام شود.</li>
          <li>نصب شخصی باعث ابطال گارانتی است.</li>
          <li>تلویزیون در تحویل فقط تست می‌شود؛ نصب پایه یا دیواری با نصاب رسمی است.</li>
          <li>یخچال را حداقل ۲۴ ساعت بعد از جابه‌جایی به برق وصل کنید.</li>
          <li>لباسشویی و ظرفشویی فقط از نظر ظاهری در تحویل بررسی می‌شوند.</li>
        </ul>
      </div>

      <div class="guide-card warranty">
        <div class="icon">🛡️</div>
        <h3>شرایط گارانتی</h3>
        <ul>
          <li>نصب و فعال‌سازی گارانتی باید توسط شرکت <b>سانا صنعت</b> یا نمایندگی رسمی برند انجام شود.</li>
          <li>در صورت خرابی فنی تا ۳۰ روز، تعویض یا عودت وجه تا ۹۰٪ انجام می‌شود.</li>
          <li>نقص ناشی از شکستگی یا نصب غیرمجاز شامل گارانتی نیست.</li>
          <li>کارت گارانتی باید دارای کد رهگیری معتبر باشد.</li>
        </ul>
      </div>

      <div class="guide-card driver">
        <div class="icon">📞</div>
        <h3>هماهنگی با راننده</h3>
        <ul>
          <li>راننده معمولاً ۱ تا ۲ ساعت قبل از تحویل تماس می‌گیرد.</li>
          <li>اگر محدودیتی دارید، قبل از ارسال اطلاع دهید.</li>
          <li>در صورت تأخیر، با فروشنده تماس بگیرید.</li>
          <li>همکاری مشتری باعث تحویل سریع‌تر و بدون دردسر می‌شود.</li>
        </ul>
      </div>

    </div>

    <a href="https://salambaba.co/help/terms-delivery" class="full-link" target="_blank" rel="noopener">
      مشاهده شرایط کامل در سایت سلام‌بابا
    </a>
  </div>

</div>
</body>
</html>
