<?php
require __DIR__.'/../includes/auth.php';
require __DIR__.'/../includes/config.php';
require __DIR__.'/../includes/db_connect.php';
require __DIR__.'/../includes/jdf.php';

$role     = $_SESSION['role'] ?? '';
$username = $_SESSION['username'] ?? '';

if ($role !== 'buyer_manager' && $role !== 'admin') {
    http_response_code(403);
    exit('دسترسی غیرمجاز');
}

$uid = trim($_GET['id'] ?? '');
if ($uid === '') {
    exit('شناسه سفارش نامعتبر است.');
}

$stmt = $mysqli->prepare("SELECT * FROM orders WHERE order_uid=? LIMIT 1");
$stmt->bind_param('s', $uid);
$stmt->execute();
$order = $stmt->get_result()->fetch_assoc();
$stmt->close();

if (!$order) {
    exit('سفارش یافت نشد.');
}

if ($role !== 'admin') {
    if (($order['buyer_username'] ?? '') !== $username) {
        http_response_code(403);
        exit('دسترسی به این سفارش برای شما مجاز نیست.');
    }
}

$heads = [];
$resHeads = $mysqli->query("
    SELECT username, full_name 
    FROM users 
    WHERE role IN ('logistic','head_carrier') AND is_approved=1
    ORDER BY full_name
");
if ($resHeads) {
    while($row = $resHeads->fetch_assoc()){
        $heads[] = $row;
    }
}

$status_map = [
    'new'               => '🕓 ثبت شده (در انتظار بررسی)',
    'assigned_to_buyer' => '📌 ارجاع به مسئول خرید',
    'purchased'         => '🛒 خریداری شده',
    'handover_to_head'  => '📦 تحویل به سر باربر',
    'out_for_delivery'  => '🚚 در حال ارسال',
    'delivered'         => '✅ تحویل داده شد',
    'failed'            => '❌ تحویل ناموفق / نیاز به هماهنگی'
];

$shipping_status = $order['shipping_status'] ?? 'new';
$status_label    = $status_map[$shipping_status] ?? $shipping_status;

function toJalaliEn($d){
    if(!$d) return '';
    $d = substr($d,0,10);
    if(!preg_match('/^\d{4}-\d{2}-\d{2}$/',$d)) return '';
    list($gy,$gm,$gd) = explode('-',$d);
    $j = gregorian_to_jalali((int)$gy,(int)$gm,(int)$gd,'/');
    return strtr($j,[
        '۰'=>'0','۱'=>'1','۲'=>'2','۳'=>'3','۴'=>'4',
        '۵'=>'5','۶'=>'6','۷'=>'7','۸'=>'8','۹'=>'9'
    ]);
}

function nf($n){ return number_format((int)$n,0,'.',','); }

$view_link = '/orders/view.php?id='.urlencode($uid);
?>
<!doctype html>
<html lang="fa" dir="rtl">
<head>
<meta charset="utf-8">
<title>جزئیات سفارش مسئول خرید</title>
<meta name="viewport" content="width=device-width,initial-scale=1">
<style>
body{background:#f3f6fa;font-family:'IRANSansWeb',sans-serif;margin:0;}
.page{max-width:900px;margin:0 auto;padding:12px;}
.card{background:#fff;border-radius:10px;padding:12px 14px;box-shadow:0 2px 8px rgba(15,23,42,0.06);margin-top:12px;}
.card h2{margin:0 0 10px;font-size:18px;font-weight:700;}
.row{display:flex;justify-content:space-between;margin-bottom:6px;font-size:14px;}
.label{color:#6b7280;}
.value{font-weight:600;}
.badge-status{display:inline-block;padding:3px 10px;border-radius:999px;background:#e0f2fe;color:#0369a1;font-size:13px;}
.actions{margin-top:10px;display:flex;gap:8px;flex-wrap:wrap;}
.btn{display:inline-block;padding:7px 12px;border-radius:8px;font-size:14px;text-decoration:none;border:none;cursor:pointer;}
.btn-back{background:#e5e7eb;color:#111827;}
.btn-primary{background:#0ea5e9;color:#fff;}
.section-title{font-size:15px;font-weight:700;margin-bottom:8px;}
.field label{display:block;font-size:13px;margin-bottom:4px;}
.field input,.field select,.field textarea{width:100%;padding:7px 9px;border-radius:8px;border:1px solid #d1d5db;font-size:14px;}
.form-grid{display:flex;flex-direction:column;gap:8px;}
.note-box{background:#f9fafb;border-radius:8px;padding:8px;font-size:13px;color:#4b5563;margin-top:8px;}
</style>
</head>
<body>

<?php require __DIR__.'/../includes/header.php'; ?>

<div class="page">

    <div class="card">
        <h2>🧾 سفارش <?=htmlspecialchars($uid)?></h2>

        <div class="row">
            <div class="label">مشتری:</div>
            <div class="value"><?=htmlspecialchars($order['customer_name'] ?? '')?></div>
        </div>
        <div class="row">
            <div class="label">فروشنده:</div>
            <div class="value"><?=htmlspecialchars($order['seller_name'] ?? '')?></div>
        </div>
        <div class="row">
            <div class="label">مبلغ کل:</div>
            <div class="value"><?=nf($order['total_amount'] ?? 0)?> تومان</div>
        </div>
        <div class="row">
            <div class="label">استان:</div>
            <div class="value"><?=htmlspecialchars($order['province'] ?? '')?></div>
        </div>
        <div class="row">
            <div class="label">تاریخ ثبت:</div>
            <div class="value"><?=toJalaliEn($order['created_at'] ?? '')?></div>
        </div>
        <div class="row">
            <div class="label">وضعیت ارسال:</div>
            <div class="value"><span class="badge-status"><?=$status_label?></span></div>
        </div>

        <div class="actions">
            <a class="btn btn-back" href="buyers.php">بازگشت به لیست</a>
            <a class="btn btn-primary" href="<?=$view_link?>" target="_blank">مشاهده فاکتور</a>
        </div>

        <?php if(!empty($order['status_note'])): ?>
            <div class="note-box">
                <b>یادداشت وضعیت:</b><br>
                <?=nl2br(htmlspecialchars($order['status_note']))?>
            </div>
        <?php endif; ?>
    </div>

    <?php if($shipping_status === 'assigned_to_buyer'): ?>
    <div class="card">
        <div class="section-title">ثبت خرید</div>
        <form method="post" action="buyer_view_save_buy.php" class="form-grid">
            <input type="hidden" name="order_uid" value="<?=htmlspecialchars($uid)?>">
            <div class="field">
                <label>تاریخ خرید (شمسی، مثلا 1403/09/02)</label>
                <input type="text" name="buy_date" placeholder="مثال: 1403/09/02">
            </div>
            <div class="field">
                <label>توضیحات خرید</label>
                <textarea name="buy_note" rows="3" placeholder="توضیحات تکمیلی خرید"></textarea>
            </div>
            <div class="actions">
                <button class="btn btn-primary" type="submit">ثبت خرید</button>
            </div>
        </form>
    </div>
    <?php endif; ?>

    <?php if($shipping_status === 'purchased'): ?>
    <div class="card">
        <div class="section-title">تحویل به سر باربر</div>
        <form method="post" action="buyer_view_save_handover.php" class="form-grid">
            <input type="hidden" name="order_uid" value="<?=htmlspecialchars($uid)?>">
            <div class="field">
                <label>انتخاب سر باربر</label>
                <select name="head_username" required>
                    <option value="">انتخاب کنید...</option>
                    <?php foreach($heads as $h): ?>
                        <option value="<?=htmlspecialchars($h['username'])?>">
                            <?=htmlspecialchars($h['full_name'] ?: $h['username'])?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div class="field">
                <label>تاریخ تحویل (شمسی، مثلا 1403/09/03)</label>
                <input type="text" name="handover_date" placeholder="مثال: 1403/09/03">
            </div>
            <div class="field">
                <label>توضیحات تحویل</label>
                <textarea name="handover_note" rows="3" placeholder="توضیحات تکمیلی تحویل"></textarea>
            </div>
            <div class="actions">
                <button class="btn btn-primary" type="submit">ثبت تحویل به سر باربر</button>
            </div>
        </form>
    </div>
    <?php endif; ?>

</div>
</body>
</html>
