<?php
require __DIR__.'/../includes/auth.php';
require __DIR__.'/../includes/config.php';
require __DIR__.'/../includes/db_connect.php';
require __DIR__.'/../includes/jdf.php';

$role     = $_SESSION['role'] ?? '';
$username = $_SESSION['username'] ?? '';

if ($role !== 'buyer_manager' && $role !== 'admin') {
    http_response_code(403);
    exit('دسترسی غیرمجاز');
}

$order_uid    = trim($_POST['order_uid'] ?? '');
$head_username= trim($_POST['head_username'] ?? '');
$handover_date= trim($_POST['handover_date'] ?? '');
$handover_note= trim($_POST['handover_note'] ?? '');

if ($order_uid === '' || $head_username === '') {
    exit('اطلاعات ناقص است');
}

$stmt = $mysqli->prepare("SELECT id, buyer_username, status_note FROM orders WHERE order_uid=? LIMIT 1");
$stmt->bind_param('s', $order_uid);
$stmt->execute();
$order = $stmt->get_result()->fetch_assoc();
$stmt->close();

if (!$order) {
    exit('سفارش یافت نشد');
}

if ($role !== 'admin' && ($order['buyer_username'] ?? '') !== $username) {
    http_response_code(403);
    exit('دسترسی به این سفارش برای شما مجاز نیست');
}

$handover_date_g = null;
if ($handover_date !== '' && preg_match('/^(\d{4})[\/\-](\d{1,2})[\/\-](\d{1,2})$/',$handover_date,$m)) {
    $jy = (int)$m[1];
    $jm = (int)$m[2];
    $jd = (int)$m[3];
    if (function_exists('jalali_to_gregorian')) {
        $g = jalali_to_gregorian($jy,$jm,$jd,'-');
        $handover_date_g = $g;
    }
}

$parts = [];
if ($handover_date !== '') $parts[] = "تاریخ تحویل به سرباربر: ".$handover_date;
if ($handover_note !== '') $parts[] = $handover_note;
$extra_note = '';
if ($parts) {
    $extra_note = "\n".implode(" | ", $parts);
}

if ($handover_date_g !== null) {
    $stmt = $mysqli->prepare("
        UPDATE orders
        SET shipping_status='handover_to_head',
            head_carrier_username=?,
            status_note = CONCAT(COALESCE(status_note,''), ?)
        WHERE order_uid=?
        LIMIT 1
    ");
    $stmt->bind_param('sss', $head_username, $extra_note, $order_uid);
} else {
    $stmt = $mysqli->prepare("
        UPDATE orders
        SET shipping_status='handover_to_head',
            head_carrier_username=?,
            status_note = CONCAT(COALESCE(status_note,''), ?)
        WHERE order_uid=?
        LIMIT 1
    ");
    $stmt->bind_param('sss', $head_username, $extra_note, $order_uid);
}
$stmt->execute();
$stmt->close();

header("Location: buyer_view.php?id=".urlencode($order_uid));
exit;
