<?php
require __DIR__ . '/../includes/auth.php';
require __DIR__ . '/../includes/config.php';
require __DIR__ . '/../includes/db_connect.php';
require __DIR__ . '/../includes/jdf.php';

$role = $_SESSION['role'] ?? '';
if ($role !== 'buyer_manager' && $role !== 'admin') {
    http_response_code(403);
    exit("دسترسی غیرمجاز");
}

$username = $_SESSION['username'] ?? '';
$username_esc = $mysqli->real_escape_string($username);

$status   = $_GET['status'] ?? '';
$q        = trim($_GET['q'] ?? '');

$conditions = [];

if ($role === 'admin') {
    $conditions[] = "buyer_username IS NOT NULL AND buyer_username <> ''";
} else {
    $conditions[] = "buyer_username = '{$username_esc}'";
}

$valid_statuses = [
    'new','assigned_to_buyer','purchased',
    'handover_to_head','out_for_delivery','delivered','failed'
];
if ($status !== '' && in_array($status, $valid_statuses, true)) {
    $status_esc = $mysqli->real_escape_string($status);
    $conditions[] = "shipping_status = '{$status_esc}'";
}

if ($q !== '') {
    $q_esc = $mysqli->real_escape_string($q);
    $conditions[] = "(customer_name LIKE '%{$q_esc}%' 
                      OR order_uid LIKE '%{$q_esc}%'
                      OR invoice_no LIKE '%{$q_esc}%'
                      OR mobile1 LIKE '%{$q_esc}%')";
}

$where = $conditions ? implode(' AND ', $conditions) : '1=0';

$sql = "SELECT * FROM orders WHERE {$where} ORDER BY id DESC";
$qres = $mysqli->query($sql);
if (!$qres) {
    http_response_code(500);
    exit("DB ERROR: ".$mysqli->error);
}

function toJalaliEn($d){
    if(!$d) return '';
    $d = substr($d,0,10);
    if(!preg_match('/^\d{4}-\d{2}-\d{2}$/',$d)) return '';
    list($gy,$gm,$gd) = explode('-',$d);
    $j = gregorian_to_jalali((int)$gy,(int)$gm,(int)$gd,'/');
    return strtr($j,[
        '۰'=>'0','۱'=>'1','۲'=>'2','۳'=>'3','۴'=>'4',
        '۵'=>'5','۶'=>'6','۷'=>'7','۸'=>'8','۹'=>'9'
    ]);
}

function statusLabel($st){
    switch($st){
        case 'new':               return "🕓 ثبت شده";
        case 'assigned_to_buyer': return "📌 ارجاع به مسئول خرید";
        case 'purchased':         return "🛒 خریداری شده";
        case 'handover_to_head':  return "📦 تحویل به سر باربر";
        case 'out_for_delivery':  return "🚚 در حال ارسال";
        case 'delivered':         return "✅ تحویل داده شد";
        case 'failed':            return "❌ تحویل ناموفق";
        default:                  return $st;
    }
}

function nf($n){ return number_format((int)$n,0,'.',','); }
?>
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width,initial-scale=1">
<title>سفارش‌های ارجاع شده — مسئول خرید</title>
<style>
body{background:#f3f5f9;font-family:'IRANSansWeb',sans-serif;margin:0;}
.page{padding:12px;max-width:1000px;margin:0 auto;}
.card{background:#fff;padding:12px 14px;border-radius:10px;box-shadow:0 2px 6px rgba(0,0,0,0.05);margin-top:12px;}
h1{font-size:18px;margin:0 0 10px;font-weight:700;}
.filter-row{display:flex;flex-wrap:wrap;gap:8px;margin-bottom:10px;}
.filter-row input,.filter-row select{
    padding:7px 9px;border-radius:6px;border:1px solid #d1d5db;font-size:14px;
}
.filter-row button{
    padding:7px 12px;border-radius:6px;border:none;background:#0ea5e9;color:#fff;font-size:14px;cursor:pointer;
}
.table{width:100%;border-collapse:collapse;font-size:13px;}
.table th{background:#e5f3ff;padding:8px;text-align:right;border-bottom:1px solid #cbd5e1;}
.table td{padding:8px;border-bottom:1px solid #e5e7eb;white-space:nowrap;}
.badge{display:inline-block;padding:2px 6px;border-radius:999px;font-size:12px;background:#f3f4f6;color:#111827;}
.btn{padding:4px 10px;border-radius:6px;font-size:12px;text-decoration:none;display:inline-block;border:none;cursor:pointer;}
.btn-view{background:#0ea5e9;color:#fff;}
@media(max-width:720px){
    .table{display:block;overflow-x:auto;}
}
</style>
</head>
<body>

<?php require __DIR__.'/../includes/header.php'; ?>

<div class="page">
    <div class="card">
        <h1>سفارش‌های ارجاع شده به شما</h1>

        <form method="get" class="filter-row">
            <input type="text" name="q" value="<?=htmlspecialchars($q)?>" placeholder="جستجو: نام، موبایل، UID، فاکتور">
            <select name="status">
                <option value="">همه وضعیت‌ها</option>
                <?php foreach($valid_statuses as $st): ?>
                    <option value="<?=$st?>" <?=$status===$st?'selected':''?>>
                        <?=statusLabel($st)?>
                    </option>
                <?php endforeach; ?>
            </select>
            <button type="submit">فیلتر</button>
        </form>

        <table class="table">
            <thead>
            <tr>
                <th>#</th>
                <th>UID</th>
                <th>مشتری</th>
                <th>مبلغ کل</th>
                <th>تاریخ ثبت</th>
                <th>وضعیت</th>
                <th>عملیات</th>
            </tr>
            </thead>
            <tbody>
            <?php
            $i=1;
            while($row = $qres->fetch_assoc()):
                $uid = $row['order_uid'] ?? '';
            ?>
            <tr>
                <td><?=$i++?></td>
                <td><?=htmlspecialchars($uid)?></td>
                <td><?=htmlspecialchars($row['customer_name'] ?? '')?></td>
                <td><?=nf($row['total_amount'] ?? 0)?> تومان</td>
                <td><?=toJalaliEn($row['created_at'] ?? '')?></td>
                <td><span class="badge"><?=statusLabel($row['shipping_status'] ?? '')?></span></td>
                <td>
                    <?php if($uid): ?>
                        <a class="btn btn-view" href="buyer_view.php?id=<?=urlencode($uid)?>">مشاهده</a>
                    <?php endif; ?>
                </td>
            </tr>
            <?php endwhile; ?>
            <?php if($i===1): ?>
            <tr>
                <td colspan="7" style="text-align:center;color:#6b7280;">هیچ سفارشی یافت نشد.</td>
            </tr>
            <?php endif; ?>
            </tbody>
        </table>

    </div>
</div>

</body>
</html>
