<?php
require __DIR__.'/../includes/auth.php';
require __DIR__.'/../includes/config.php';
require __DIR__.'/../includes/db_connect.php';

$role = $_SESSION['role'] ?? '';
$username = $_SESSION['username'] ?? '';

if ($role !== 'buyer_manager' && $role !== 'admin') {
    http_response_code(403);
    exit('دسترسی غیرمجاز');
}

if ($role === 'admin') {
    $where_base = "buyer_username IS NOT NULL AND buyer_username <> ''";
} else {
    $u_esc = $mysqli->real_escape_string($username);
    $where_base = "buyer_username = '{$u_esc}'";
}

function countOrders($mysqli, $where_base, $extra){
    $sql = "SELECT COUNT(*) AS c FROM orders WHERE {$where_base} {$extra}";
    $res = $mysqli->query($sql);
    if(!$res) return 0;
    $row = $res->fetch_assoc();
    return (int)($row['c'] ?? 0);
}

$assigned  = countOrders($mysqli, $where_base, " AND shipping_status='assigned_to_buyer'");
$purchased = countOrders($mysqli, $where_base, " AND shipping_status='purchased'");
$handover  = countOrders($mysqli, $where_base, " AND shipping_status='handover_to_head'");
$active    = countOrders($mysqli, $where_base, " AND shipping_status NOT IN ('delivered','failed')");
?>
<!doctype html>
<html lang="fa" dir="rtl">
<head>
<meta charset="utf-8">
<title>داشبورد مسئول خرید</title>
<meta name="viewport" content="width=device-width,initial-scale=1">
<style>
body{background:#f5f7fa;font-family:'IRANSansWeb',sans-serif;margin:0;padding:16px;}
.wrap{max-width:800px;margin:0 auto;}
h1{font-size:20px;margin:0 0 14px;font-weight:700;}
.card{background:#fff;border-radius:12px;padding:12px 14px;box-shadow:0 2px 8px rgba(15,23,42,0.06);margin-bottom:10px;display:flex;justify-content:space-between;align-items:center;}
.card a{text-decoration:none;color:#0f172a;font-weight:600;font-size:15px;}
.badge{background:#0ea5e9;color:#fff;padding:4px 10px;border-radius:999px;font-size:13px;}
</style>
</head>
<body>

<?php require __DIR__.'/../includes/header.php'; ?>

<div class="wrap">
    <h1>🛒 داشبورد مسئول خرید</h1>

    <div class="card">
        <a href="buyers.php?status=assigned_to_buyer">سفارش‌های ارجاع شده (در انتظار خرید)</a>
        <span class="badge"><?=$assigned?></span>
    </div>

    <div class="card">
        <a href="buyers.php?status=purchased">خریدهای انجام شده</a>
        <span class="badge"><?=$purchased?></span>
    </div>

    <div class="card">
        <a href="buyers.php?status=handover_to_head">تحویل شده به سر باربر</a>
        <span class="badge"><?=$handover?></span>
    </div>

    <div class="card">
        <a href="buyers.php">سفارشات فعال (غیر تحویل/ناموفق)</a>
        <span class="badge"><?=$active?></span>
    </div>
</div>

</body>
</html>
