<?php
require __DIR__.'/../includes/auth.php';
require __DIR__.'/../includes/config.php';
require __DIR__.'/../includes/db_connect.php';

$role     = $_SESSION['role'] ?? '';
$username = $_SESSION['username'] ?? '';

if ($role !== 'buyer_manager' && $role !== 'admin') {
    http_response_code(403);
    exit('دسترسی غیرمجاز');
}

$action    = $_POST['action'] ?? '';
$order_uid = trim($_POST['order_uid'] ?? '');

if ($order_uid === '') {
    exit('شناسه سفارش نامعتبر است');
}

$stmt = $mysqli->prepare("SELECT id, buyer_username FROM orders WHERE order_uid=? LIMIT 1");
$stmt->bind_param('s', $order_uid);
$stmt->execute();
$order = $stmt->get_result()->fetch_assoc();
$stmt->close();

if (!$order) exit('سفارش یافت نشد');

if ($role !== 'admin' && ($order['buyer_username'] ?? '') !== $username) {
    http_response_code(403);
    exit('دسترسی به این سفارش برای شما مجاز نیست');
}

if ($action === 'purchased') {
    $mysqli->query("
        UPDATE orders 
        SET shipping_status='purchased' 
        WHERE order_uid='".$mysqli->real_escape_string($order_uid)."' 
        LIMIT 1
    ");
    header("Location: buyer_view.php?id=".urlencode($order_uid));
    exit;
}

if ($action === 'handover') {
    $head_username = trim($_POST['head_username'] ?? '');
    if ($head_username === '') exit('سر باربر مشخص نشده است');
    $head_username_esc = $mysqli->real_escape_string($head_username);

    $mysqli->query("
        UPDATE orders 
        SET shipping_status='handover_to_head',
            head_carrier_username='{$head_username_esc}'
        WHERE order_uid='".$mysqli->real_escape_string($order_uid)."' 
        LIMIT 1
    ");
    header("Location: buyer_view.php?id=".urlencode($order_uid));
    exit;
}

exit('عملیات نامعتبر');
