<?php
require __DIR__ . '/../includes/auth.php';
require __DIR__ . '/../includes/config.php';
require __DIR__ . '/../includes/db_connect.php';
require __DIR__ . '/../includes/header.php';

// ==============================
// Helpers
// ==============================
function nf($n){
    return number_format((int)($n ?? 0), 0, '.', ',');
}

function e($v){
    return htmlspecialchars((string)($v ?? ''), ENT_QUOTES, 'UTF-8');
}

// -------------------------
// فیلترها
// -------------------------
$search         = trim($_GET['search'] ?? '');
$brandFilter    = trim($_GET['brand'] ?? '');
$categoryFilter = trim($_GET['category'] ?? '');
$sort           = $_GET['sort'] ?? 'id';
$dir            = strtolower($_GET['dir'] ?? 'desc');

// -------------------------
// مرتب‌سازی امن روی همه ستون‌ها
// -------------------------
$allowedSort = ['id','title','brand','model','price','category'];
if (!in_array($sort, $allowedSort, true)) {
    $sort = 'id';
}
if (!in_array($dir, ['asc','desc'], true)) {
    $dir = 'desc';
}
$order_sql = "ORDER BY $sort $dir";

// -------------------------
// صفحه‌بندی
// -------------------------
$per_page = isset($_GET['per_page']) ? (int)$_GET['per_page'] : 50;
if ($per_page < 10)  $per_page = 10;
if ($per_page > 200) $per_page = 200;

$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
if ($page < 1) $page = 1;

$offset = ($page - 1) * $per_page;

// -------------------------
// WHERE
// -------------------------
$where = "WHERE 1";

if ($search !== '') {
    $s = $mysqli->real_escape_string($search);
    $where .= " AND (title LIKE '%$s%' OR model LIKE '%$s%' OR brand LIKE '%$s%' OR category LIKE '%$s%')";
}

if ($brandFilter !== '') {
    $b = $mysqli->real_escape_string($brandFilter);
    $where .= " AND brand='$b'";
}

if ($categoryFilter !== '') {
    $c = $mysqli->real_escape_string($categoryFilter);
    $where .= " AND category='$c'";
}

// -------------------------
// تعداد کل
// -------------------------
$row   = $mysqli->query("SELECT COUNT(*) AS c FROM product $where")->fetch_assoc();
$total = (int)($row['c'] ?? 0);
$total_pages = max(1, (int)ceil($total / $per_page));

// -------------------------
// لیست برندها و دسته‌ها
// -------------------------
$brands = [];
$cats   = [];

$brands_res = $mysqli->query("SELECT DISTINCT brand FROM product WHERE brand<>'' ORDER BY brand");
while ($row = $brands_res->fetch_assoc()) {
    $brands[] = $row['brand'];
}

$cats_res = $mysqli->query("SELECT DISTINCT category FROM product WHERE category<>'' ORDER BY category");
while ($row = $cats_res->fetch_assoc()) {
    $cats[] = $row['category'];
}

// -------------------------
// دیتای اصلی
// -------------------------
$sql = "
SELECT *
FROM product
$where
$order_sql
LIMIT $per_page OFFSET $offset
";
$list = $mysqli->query($sql);

// helper برای لینک مرتب‌سازی
function sort_link($col, $label){
    global $sort, $dir, $search, $brandFilter, $categoryFilter, $per_page;

    $newDir = 'asc';
    if ($sort === $col && $dir === 'asc') {
        $newDir = 'desc';
    }

    $url = sprintf(
        '?sort=%s&dir=%s&search=%s&brand=%s&category=%s&per_page=%d&page=1',
        urlencode($col),
        $newDir,
        urlencode($search),
        urlencode($brandFilter),
        urlencode($categoryFilter),
        $per_page
    );

    $icon = '';
    if ($sort === $col) {
        $icon = $dir === 'asc' ? ' ▲' : ' ▼';
    }
    return '<a href="'.$url.'">'.e($label).$icon.'</a>';
}
?>
<!doctype html>
<html lang="fa" dir="rtl">
<head>
<meta charset="utf-8">
<title>مدیریت محصولات</title>
<link rel="stylesheet" href="product.css">
</head>
<body>

<div class="product-page">

  <div class="product-header">
    <h1>مدیریت محصولات</h1>
    <a href="add.php" class="btn-primary">+ افزودن</a>
  </div>

  <div class="total-count">
    تعداد کل محصولات: <b><?= nf($total) ?></b>
  </div>

  <!-- فیلترها -->
  <form class="product-filters" method="get">
    <div class="field">
      <label>جستجو (عنوان / مدل / برند)</label>
      <input type="text" name="search" value="<?= e($search) ?>">
    </div>

    <div class="field">
      <label>برند</label>
      <select name="brand">
        <option value="">همه برندها</option>
        <?php foreach($brands as $b): ?>
          <option value="<?= e($b) ?>" <?= $brandFilter === $b ? 'selected' : '' ?>><?= e($b) ?></option>
        <?php endforeach; ?>
      </select>
    </div>

    <div class="field">
      <label>دسته‌بندی</label>
      <select name="category">
        <option value="">همه دسته‌ها</option>
        <?php foreach($cats as $c): ?>
          <option value="<?= e($c) ?>" <?= $categoryFilter === $c ? 'selected' : '' ?>><?= e($c) ?></option>
        <?php endforeach; ?>
      </select>
    </div>

    <div class="field">
      <label>تعداد در صفحه</label>
      <select name="per_page">
        <?php foreach([10,20,50,100,150,200] as $pp): ?>
          <option value="<?= $pp ?>" <?= $per_page == $pp ? 'selected' : '' ?>><?= $pp ?></option>
        <?php endforeach; ?>
      </select>
    </div>

    <div class="field actions">
      <button type="submit" class="btn-primary">اعمال</button>
      <a href="index.php" class="btn-secondary">ریست</a>
    </div>
  </form>

  <!-- جدول + حذف Ajax + ویرایش درجا -->
  <div class="table-wrapper">
    <table class="product-table" id="productTable">
      <thead>
        <tr>
          <th><input type="checkbox" id="checkAll"></th>
          <th><?= sort_link('id','ID') ?></th>
          <th><?= sort_link('title','عنوان') ?></th>
          <th><?= sort_link('brand','برند') ?></th>
          <th><?= sort_link('model','مدل') ?></th>
          <th><?= sort_link('category','دسته‌بندی') ?></th>
          <th><?= sort_link('price','قیمت') ?></th>
          <th>عملیات</th>
        </tr>
      </thead>
      <tbody>
      <?php while($p = $list->fetch_assoc()): ?>
        <tr data-id="<?= (int)$p['id'] ?>">
          <td><input type="checkbox" class="row-check" value="<?= (int)$p['id'] ?>"></td>
          <td><?= (int)$p['id'] ?></td>

          <td class="cell-editable" data-field="title"><?= e($p['title'] ?? '') ?></td>
          <td class="cell-editable" data-field="brand"><?= e($p['brand'] ?? '') ?></td>
          <td class="cell-editable" data-field="model"><?= e($p['model'] ?? '') ?></td>
          <td class="cell-editable" data-field="category"><?= e($p['category'] ?? '') ?></td>
          <td class="cell-editable" data-field="price">
            <?= !empty($p['price']) ? nf($p['price']) : '' ?>
          </td>

          <td>
            <a class="link-edit" href="edit.php?id=<?= (int)$p['id'] ?>">ویرایش کامل</a>
            <a class="link-delete" href="delete.php?id=<?= (int)$p['id'] ?>" onclick="return confirm('حذف شود؟')">حذف</a>
          </td>
        </tr>
      <?php endwhile; ?>
      </tbody>
    </table>
  </div>

  <div style="margin-top:10px; display:flex; justify-content:space-between; align-items:center; gap:10px;">
    <button type="button" id="btnBulkDelete" class="btn-danger">حذف دسته‌جمعی (Ajax)</button>
    <div class="pagination">
      <?php for ($i=1; $i <= $total_pages; $i++): ?>
        <a class="page-item <?= $i == $page ? 'active' : '' ?>"
           href="?page=<?= $i ?>
           &search=<?= urlencode($search) ?>
           &brand=<?= urlencode($brandFilter) ?>
           &category=<?= urlencode($categoryFilter) ?>
           &sort=<?= urlencode($sort) ?>
           &dir=<?= urlencode($dir) ?>
           &per_page=<?= (int)$per_page ?>">
          <?= $i ?>
        </a>
      <?php endfor; ?>
    </div>
  </div>

</div>

<script>
// ========================
// انتخاب همه / هیچ
// ========================
document.getElementById('checkAll').addEventListener('change', function(){
  const checked = this.checked;
  document.querySelectorAll('.row-check').forEach(ch => ch.checked = checked);
});

// ========================
// حذف دسته‌جمعی AJAX
// ========================
document.getElementById('btnBulkDelete').addEventListener('click', function(){
  const ids = Array.from(document.querySelectorAll('.row-check:checked')).map(ch => ch.value);
  if (!ids.length) {
    alert('هیچ محصولی انتخاب نشده است.');
    return;
  }
  if (!confirm('محصولات انتخاب‌شده حذف شوند؟')) return;

  const formData = new URLSearchParams();
  ids.forEach(id => formData.append('ids[]', id));

  fetch('ajax_delete.php', {
    method: 'POST',
    headers: { 'Content-Type': 'application/x-www-form-urlencoded;charset=UTF-8' },
    body: formData.toString()
  })
  .then(r => r.json())
  .then(res => {
    if (res.status === 'success') {
      ids.forEach(id => {
        const row = document.querySelector('tr[data-id="'+id+'"]');
        if (row) row.remove();
      });
    } else {
      alert(res.msg || 'خطا در حذف');
    }
  })
  .catch(() => alert('خطا در ارتباط با سرور'));
});

// ========================
// ویرایش درجا (Inline Edit)
// ========================
let editingCell = null;

document.querySelectorAll('.cell-editable').forEach(td => {
  td.addEventListener('click', function(){
    if (editingCell === this) return;
    if (editingCell) finishEdit(editingCell, false);

    editingCell = this;
    const originalText = this.innerText.trim();
    const field = this.dataset.field;
    this.classList.add('editing');

    const input = document.createElement('input');
    input.type = (field === 'price') ? 'number' : 'text';
    input.value = originalText.replace(/,/g,'');
    input.style.width = '100%';
    input.style.boxSizing = 'border-box';

    this.innerHTML = '';
    this.appendChild(input);
    input.focus();

    input.addEventListener('keydown', function(e){
      if (e.key === 'Enter') {
        finishEdit(editingCell, true);
      }
      if (e.key === 'Escape') {
        finishEdit(editingCell, false);
      }
    });

    input.addEventListener('blur', function(){
      finishEdit(editingCell, true);
    });
  });
});

function finishEdit(td, save){
  if (!td) return;
  const input    = td.querySelector('input');
  const original = input ? input.defaultValue : td.innerText;
  const value    = input ? input.value.trim() : original;
  const field    = td.dataset.field;
  const tr       = td.closest('tr');
  const id       = tr ? tr.getAttribute('data-id') : null;

  td.classList.remove('editing');

  if (!save || !id) {
    td.innerText = original;
    editingCell = null;
    return;
  }

  // نمایش موقت
  td.innerText = (field === 'price' && value)
    ? new Intl.NumberFormat('fa-IR').format(value)
    : value;

  const formData = new URLSearchParams();
  formData.append('id', id);
  formData.append('field', field);
  formData.append('value', value);

  fetch('ajax_update.php', {
    method: 'POST',
    headers: { 'Content-Type': 'application/x-www-form-urlencoded;charset=UTF-8' },
    body: formData.toString()
  })
  .then(r => r.json())
  .then(res => {
    if (res.status !== 'success') {
      alert(res.msg || 'خطا در ذخیره');
      td.innerText = original;
    }
  })
  .catch(() => {
    alert('خطا در ارتباط با سرور');
    td.innerText = original;
  })
  .finally(() => {
    editingCell = null;
  });
}
</script>

</body>
</html>
