<?php
require __DIR__.'/includes/auth.php';
require __DIR__.'/includes/config.php';
require __DIR__.'/includes/db_connect.php';
header('Content-Type: application/json; charset=utf-8');

$uid   = trim($_POST['order_uid'] ?? '');
$oid   = isset($_POST['order_id']) ? (int)$_POST['order_id'] : 0;
$status= trim($_POST['status'] ?? '');
$note  = trim($_POST['note'] ?? '');

if ($uid !== '') {
  $stmt = $mysqli->prepare('SELECT id FROM orders WHERE order_uid=? LIMIT 1');
  $stmt->bind_param('s', $uid);
  $stmt->execute();
  $row = $stmt->get_result()->fetch_assoc();
  $stmt->close();
  if ($row) { $oid = (int)$row['id']; }
}

$allowed = ['pending','processing','shipped','delivered','cancelled'];
if ($oid <= 0 || !in_array($status, $allowed, true)) {
  echo json_encode(['ok'=>false,'error'=>'اطلاعات ناقص یا نامعتبر']); exit;
}

$stmt = $mysqli->prepare('UPDATE orders SET status=?, status_note=? WHERE id=?');
$stmt->bind_param('ssi', $status, $note, $oid);
$ok = $stmt->execute();
$stmt->close();

echo json_encode(['ok'=>$ok]);
