<?php
require __DIR__.'/../includes/auth.php';
require __DIR__.'/../includes/config.php';
require __DIR__.'/../includes/db_connect.php';
require __DIR__.'/../includes/jdf.php';

$role     = $_SESSION['role']     ?? '';
$username = $_SESSION['username'] ?? '';

if ($role !== 'buyer_manager' && $role !== 'admin') {
    http_response_code(403);
    exit('دسترسی غیرمجاز');
}

// ===============================
// دریافت UID
// ===============================
$uid = trim($_GET['id'] ?? '');
if ($uid === '') {
    exit('شناسه سفارش نامعتبر است.');
}

// ===============================
// واکشی سفارش بر اساس order_uid
// ===============================
$stmt = $mysqli->prepare("SELECT * FROM orders WHERE order_uid=? LIMIT 1");
$stmt->bind_param('s', $uid);
$stmt->execute();
$o = $stmt->get_result()->fetch_assoc();
$stmt->close();

if (!$o) {
    exit('سفارش یافت نشد.');
}

// فقط سفارش‌های خود مسئول خرید (به‌جز ادمین)
if ($role !== 'admin') {
    if (($o['buyer_username'] ?? '') !== $username) {
        http_response_code(403);
        exit('دسترسی به این سفارش برای شما مجاز نیست.');
    }
}

// ===============================
// لیست سر باربر / لجستیک
// ===============================
$heads = [];
$resHeads = $mysqli->query("
    SELECT username, full_name 
    FROM users 
    WHERE role IN ('logistic','head_carrier') AND is_approved=1
    ORDER BY full_name
");
if ($resHeads) {
    while($r = $resHeads->fetch_assoc()){
        $heads[] = $r;
    }
}

// ===============================
// توابع کمکی
// ===============================
function nf($n){ return number_format((float)$n, 0, '.', ','); }

function safe($x){ return htmlspecialchars($x ?? '', ENT_QUOTES, 'UTF-8'); }

function toJalaliEn($d){
    if(!$d || !preg_match('/^\d{4}-\d{2}-\d{2}$/',$d)) return '-';
    list($gy,$gm,$gd)=explode('-',$d);
    $j = gregorian_to_jalali((int)$gy,(int)$gm,(int)$gd,'/');
    return strtr($j,[
        '۰'=>'0','۱'=>'1','۲'=>'2','۳'=>'3','۴'=>'4',
        '۵'=>'5','۶'=>'6','۷'=>'7','۸'=>'8','۹'=>'9'
    ]);
}

// وضعیت فارسی
$status_map = [
  'new'               => '🕓 ثبت شده (در انتظار بررسی)',
  'assigned_to_buyer' => '📌 ارجاع به مسئول خرید',
  'purchased'         => '🛒 کالا خریداری شده (در حال آماده سازی)',
  'handover_to_head'  => '📦 تحویل به سر باربر',
  'out_for_delivery'  => '🚚 در حال ارسال',
  'delivered'         => '✅ تحویل داده شد',
  'failed'            => '❌ تحویل ناموفق / نیاز به هماهنگی'
];

$status_raw   = trim($o['shipping_status'] ?? 'new');
$status_label = $status_map[$status_raw] ?? 'در حال بررسی';

$track_link = rtrim(BASE_URL,'/').'/track.php?code='.rawurlencode($o['tracking_code'] ?? '');
$view_link  = '/orders/view.php?id='.urlencode($uid);

// اقلام سفارش
$order_id = (int)($o['id'] ?? 0);
$items = [];
if ($order_id > 0) {
    $stmt = $mysqli->prepare('SELECT * FROM order_items WHERE order_id=? ORDER BY id ASC');
    $stmt->bind_param('i', $order_id);
    $stmt->execute();
    $res = $stmt->get_result();
    while($row = $res->fetch_assoc()){ $items[] = $row; }
    $stmt->close();
}

// گارانتی
$wmap = [
  'none'   => 'بدون گارانتی',
  'gold'   => 'طلایی',
  'silver' => 'نقره‌ای',
  'bronze' => 'برنزی',
  ''       => 'بدون گارانتی'
];
$w_raw          = strtolower(trim($o['warranty'] ?? ''));
$warranty_label = $wmap[$w_raw] ?? safe($o['warranty'] ?? '');
?>
<!doctype html>
<html lang="fa" dir="rtl">
<head>
<meta charset="utf-8">
<title>سفارش <?= safe($uid) ?> — مسئول خرید</title>
<meta name="viewport" content="width=device-width,initial-scale=1">
<style>
body{background:#f3f6fa;font-family:'IRANSansWeb',sans-serif;margin:0;}
.page{max-width:1100px;margin:0 auto;padding:10px;}
.card{background:#fff;border-radius:10px;padding:12px 14px;box-shadow:0 2px 8px rgba(15,23,42,0.06);margin-top:10px;}
.card h2{margin:0 0 10px;font-size:18px;font-weight:700;}
h3{margin:0 0 8px;font-size:16px;font-weight:700;}
.row{display:flex;justify-content:space-between;margin-bottom:6px;font-size:14px;}
.label{color:#6b7280;}
.value{font-weight:600;}
.badge-status{display:inline-block;padding:3px 10px;border-radius:999px;background:#e0f2fe;color:#0369a1;font-size:13px;}
.actions{margin-top:10px;display:flex;flex-wrap:wrap;gap:8px;}
.btn{display:inline-block;padding:7px 12px;border-radius:8px;font-size:14px;text-decoration:none;border:none;cursor:pointer;}
.btn-back{background:#e5e7eb;color:#111827;}
.btn-primary{background:#0ea5e9;color:#fff;}
.btn-ghost{background:#f3f4f6;color:#111827;}
.info-grid{display:grid;grid-template-columns:repeat(auto-fit,minmax(220px,1fr));gap:8px 14px;font-size:14px;}
.info-item .label{display:block;color:#6b7280;font-size:13px;margin-bottom:2px;}
.info-item .value{font-weight:600;}
.table{width:100%;border-collapse:collapse;font-size:13px;margin-top:6px;}
.table th{background:#e5f3ff;padding:7px;border-bottom:1px solid #cbd5e1;text-align:right;white-space:nowrap;}
.table td{padding:7px;border-bottom:1px solid #e5e7eb;white-space:nowrap;}
.totals{margin-top:8px;font-size:14px;display:flex;flex-wrap:wrap;gap:10px;}
.totals div{background:#f9fafb;border-radius:8px;padding:6px 10px;}
.section-title{font-size:15px;font-weight:700;margin-bottom:8px;}
.field label{display:block;font-size:13px;margin-bottom:4px;}
.field input,.field select,.field textarea{
  width:100%;padding:7px 9px;border-radius:8px;border:1px solid #d1d5db;font-size:14px;
}
.form-grid{display:flex;flex-direction:column;gap:8px;}
.note-box{background:#f9fafb;border-radius:8px;padding:8px;font-size:13px;color:#4b5563;margin-top:8px;}
.badge-small{display:inline-block;padding:2px 6px;border-radius:999px;background:#f3f4f6;font-size:12px;color:#374151;}
@media(max-width:720px){
  .table{display:block;overflow-x:auto;}
}
</style>
</head>
<body>

<?php require __DIR__.'/../includes/header.php'; ?>

<div class="page">

  <!-- اطلاعات کامل فاکتور -->
  <div class="card">
    <h2>🧾 سفارش <?= safe($uid) ?></h2>

    <div class="info-grid">
      <div class="info-item">
        <span class="label">مشتری</span>
        <span class="value"><?= safe($o['customer_name']) ?></span>
      </div>
      <div class="info-item">
        <span class="label">موبایل</span>
        <span class="value"><?= safe($o['mobile1']) ?></span>
      </div>
      <div class="info-item">
        <span class="label">فروشنده</span>
        <span class="value"><?= safe($o['seller_name']) ?></span>
      </div>
      <div class="info-item">
        <span class="label">نام کاربری فروشنده</span>
        <span class="value"><?= safe($o['username']) ?></span>
      </div>
      <div class="info-item">
        <span class="label">استان</span>
        <span class="value"><?= safe($o['province']) ?></span>
      </div>
      <div class="info-item">
        <span class="label">شهر</span>
<span class="value"><?= safe($o['city'] ?? '') ?></span>
      </div>
      <div class="info-item">
        <span class="label">تاریخ ثبت</span>
        <span class="value"><?= toJalaliEn(substr($o['created_at'] ?? '',0,10)) ?></span>
      </div>
      <div class="info-item">
        <span class="label">تاریخ خرید</span>
        <span class="value"><?= toJalaliEn($o['purchase_date'] ?? '') ?></span>
      </div>
      <div class="info-item">
        <span class="label">گارانتی</span>
        <span class="value"><?= $warranty_label ?></span>
      </div>
      <div class="info-item">
        <span class="label">کد پیگیری</span>
        <span class="value"><?= safe($o['tracking_code']) ?></span>
      </div>
      <div class="info-item">
        <span class="label">وضعیت ارسال</span>
        <span class="value"><span class="badge-status"><?= $status_label ?></span></span>
      </div>
    </div>

    <div class="info-item" style="margin-top:8px;">
      <span class="label">آدرس کامل</span>
      <span class="value"><?= safe($o['address']) ?></span>
    </div>

    <?php if(!empty($o['notes'])): ?>
      <div class="note-box">
        <b>توضیحات فروش:</b><br>
        <?= nl2br(safe($o['notes'])) ?>
      </div>
    <?php endif; ?>

    <div class="actions">
      <a class="btn btn-back" href="buyers.php">بازگشت به لیست</a>
      <a class="btn btn-primary" href="<?= $view_link ?>" target="_blank">مشاهده فاکتور کامل</a>
      <?php if($track_link): ?>
        <a class="btn btn-ghost" href="<?= $track_link ?>" target="_blank">صفحه پیگیری مشتری</a>
      <?php endif; ?>
    </div>
  </div>

  <!-- اقلام سفارش -->
  <div class="card">
    <h3>اقلام سفارش</h3>
    <?php if(empty($items)): ?>
      <p style="margin:0;color:#6b7280;font-size:13px;">هیچ قلمی ثبت نشده است.</p>
    <?php else: ?>
      <table class="table">
        <thead>
          <tr>
            <th>#</th>
            <th>مدل</th>
            <th>قیمت</th>
            <th>بیعانه</th>
            <th>COD</th>
            <th>مانده</th>
          </tr>
        </thead>
        <tbody>
        <?php $i=1; foreach($items as $it): ?>
          <tr>
            <td><?= $i++ ?></td>
            <td><?= safe($it['model']) ?></td>
            <td><?= nf($it['price']) ?></td>
            <td><?= nf($it['deposit']) ?></td>
            <td><?= nf($it['cod']) ?></td>
            <td><?= nf($it['remaining']) ?></td>
          </tr>
        <?php endforeach; ?>
        </tbody>
      </table>
    <?php endif; ?>

    <div class="totals">
      <div>جمع فروش: <b><?= nf($o['total_amount']) ?></b></div>
      <div>بیعانه: <b><?= nf($o['total_deposit']) ?></b></div>
      <div>COD: <b><?= nf($o['total_cod']) ?></b></div>
      <div>مانده: <b><?= nf($o['total_remaining']) ?></b></div>
    </div>
  </div>

  <!-- تغییر وضعیت سفارش (همیشه قابل تغییر) -->
  <div class="card">
    <h3>وضعیت سفارش</h3>
    <p style="margin:0 0 1rem;font-weight:600;">
      وضعیت فعلی: <span style="color:#0369a1;"><?= $status_label ?></span>
    </p>

    <form id="statusForm" class="form-grid">
      <div class="field">
        <label>وضعیت</label>
        <select id="statusSelect" name="status">
          <option value="new">ثبت شده (در انتظار بررسی)</option>
          <option value="assigned_to_buyer">ارجاع به مسئول خرید</option>
          <option value="purchased">کالا خریداری شده (در حال آماده سازی)</option>
          <option value="handover_to_head">تحویل به سر باربر</option>
          <option value="out_for_delivery">در حال ارسال</option>
          <option value="delivered">تحویل داده شد</option>
          <option value="failed">تحویل ناموفق / نیاز به هماهنگی</option>
        </select>
      </div>
      <div class="field">
        <label>یادداشت وضعیت</label>
        <input id="statusNote" name="note" value="<?= safe($o['status_note']) ?>">
      </div>
      <div class="actions">
        <button class="btn btn-primary" type="submit">ثبت وضعیت</button>
        <?php if($track_link): ?>
          <a class="btn btn-ghost" href="<?= $track_link ?>" target="_blank">صفحه پیگیری</a>
        <?php endif; ?>
      </div>
    </form>
  </div>

  <!-- ثبت خرید کالا -->
  <?php if($status_raw === 'assigned_to_buyer'): ?>
  <div class="card">
    <h3>🛒 ثبت خرید کالا</h3>
    <form method="post" action="action.php" class="form-grid">
      <input type="hidden" name="action" value="buy">
      <input type="hidden" name="order_uid" value="<?= safe($uid) ?>">

      <div class="field">
        <label>تاریخ خرید (شمسی)</label>
        <input 
          type="text" 
          name="buy_date" 
          placeholder="مثال: 1403/09/02"
          style="direction:ltr;text-align:center;">
        <small style="color:#6b7280;font-size:12px;">
          تاریخ را به‌صورت شمسی با عدد انگلیسی وارد کنید.
        </small>
      </div>

      <div class="field">
        <label>توضیحات خرید</label>
        <textarea name="buy_note" rows="3" placeholder="مثلاً: پرداخت انجام شد / فروشنده تحویل داد / ..."></textarea>
      </div>

      <button class="btn btn-primary" type="submit" style="margin-top:6px;">
        ✔ ثبت خرید
      </button>
    </form>
  </div>
  <?php endif; ?>

  <!-- تحویل به سر باربر -->
  <?php if($status_raw === 'purchased'): ?>
  <div class="card">
    <h3>🚚 تحویل به سر باربر</h3>
    <form method="post" action="action.php" class="form-grid">
      <input type="hidden" name="action" value="handover">
      <input type="hidden" name="order_uid" value="<?= safe($uid) ?>">

      <div class="field">
        <label>انتخاب سر باربر</label>
        <select name="head_username" required>
          <option value="">انتخاب کنید...</option>
          <?php foreach($heads as $h): ?>
            <option value="<?= safe($h['username']) ?>">
              <?= safe($h['full_name'] ?: $h['username']) ?>
            </option>
          <?php endforeach; ?>
        </select>
      </div>

      <div class="field">
        <label>تاریخ تحویل (شمسی)</label>
        <input 
          type="text" 
          name="handover_date" 
          placeholder="مثال: 1403/09/03"
          style="direction:ltr;text-align:center;">
      </div>

      <div class="field">
        <label>توضیحات تحویل</label>
        <textarea name="handover_note" rows="3" placeholder="توضیحات تکمیلی تحویل"></textarea>
      </div>

      <button class="btn btn-primary" type="submit" style="margin-top:6px;">
        ✔ ثبت تحویل به سر باربر
      </button>
    </form>
  </div>
  <?php endif; ?>

</div>

<script>
// مقدار اولیه وضعیت
document.getElementById('statusSelect').value = <?= json_encode($status_raw, JSON_UNESCAPED_UNICODE) ?>;

// ثبت وضعیت (بدون رفتن به صفحه پیگیری)
const statusForm = document.getElementById('statusForm');
statusForm.addEventListener('submit', async (e)=>{
  e.preventDefault();
  const fd = new FormData();
  fd.append('order_uid', <?= json_encode($o['order_uid']) ?>);
  fd.append('status', document.getElementById('statusSelect').value);
  fd.append('note',   document.getElementById('statusNote').value);

  try {
    const res = await fetch('../xhr_update_status.php', {
      method:'POST',
      body:fd
    });
    const j = await res.json();
    if(j.ok){
      alert('وضعیت با موفقیت ثبت شد.');
      location.reload();
    }else{
      alert('خطا: ' + (j.error || 'ثبت وضعیت ناموفق بود'));
    }
  } catch(err){
    alert('خطا در ارتباط با سرور');
  }
});
</script>

</body>
</html>
