<?php
require __DIR__ . '/../includes/auth.php';
require __DIR__ . '/../includes/config.php';
require __DIR__ . '/../includes/db_connect.php';
require __DIR__ . '/../includes/jdf.php';

$role     = $_SESSION['role']     ?? '';
$username = $_SESSION['username'] ?? '';

if ($role !== 'buyer_manager' && $role !== 'admin') {
    http_response_code(403);
    exit('دسترسی غیرمجاز');
}

// =========================
//  فیلترها
// =========================
$status = trim($_GET['status'] ?? '');
$q      = trim($_GET['q'] ?? '');

// نقش‌ها
if ($role === 'admin') {
    $where_base = "buyer_username IS NOT NULL AND buyer_username <> ''";
} else {
    $u_esc = $mysqli->real_escape_string($username);
    $where_base = "buyer_username = '{$u_esc}'";
}

// وضعیت معتبر
$valid_statuses = [
    'new',
    'assigned_to_buyer',
    'purchased',
    'handover_to_head',
    'out_for_delivery',
    'delivered',
    'failed'
];

$conditions = [$where_base];

if ($status !== '' && in_array($status, $valid_statuses, true)) {
    $st_esc = $mysqli->real_escape_string($status);
    $conditions[] = "shipping_status = '{$st_esc}'";
}

if ($q !== '') {
    $q_esc = $mysqli->real_escape_string($q);
    $conditions[] = "(customer_name LIKE '%{$q_esc}%' 
                      OR order_uid LIKE '%{$q_esc}%'
                      OR invoice_no LIKE '%{$q_esc}%'
                      OR mobile1 LIKE '%{$q_esc}%')";
}

$where = $conditions ? implode(' AND ', $conditions) : '1=0';

$sql = "SELECT * FROM orders WHERE {$where} ORDER BY id DESC";
$res = $mysqli->query($sql);
if (!$res) {
    http_response_code(500);
    exit('DB ERROR: '.$mysqli->error);
}

// =========================
//  توابع کمکی
// =========================
function nf($n){ return number_format((int)$n,0,'.',','); }

function toJalaliEn($d){
    if(!$d) return '';
    $d = substr($d,0,10);
    if(!preg_match('/^\d{4}-\d{2}-\d{2}$/',$d)) return '';
    list($gy,$gm,$gd) = explode('-',$d);
    $j = gregorian_to_jalali((int)$gy,(int)$gm,(int)$gd,'/');
    return strtr($j,[
        '۰'=>'0','۱'=>'1','۲'=>'2','۳'=>'3','۴'=>'4',
        '۵'=>'5','۶'=>'6','۷'=>'7','۸'=>'8','۹'=>'9'
    ]);
}

function statusLabel($st){
    switch($st){
        case 'new':               return "🕓 ثبت شده";
        case 'assigned_to_buyer': return "📌 ارجاع به مسئول خرید";
        case 'purchased':         return "🛒 خریداری شده";
        case 'handover_to_head':  return "📦 تحویل به سر باربر";
        case 'out_for_delivery':  return "🚚 در حال ارسال";
        case 'delivered':         return "✅ تحویل داده شد";
        case 'failed':            return "❌ تحویل ناموفق";
        default:                  return $st;
    }
}

// =========================
//  آمار داشبورد
// =========================
function countOrders($mysqli, $where_base, $extra){
    $sql = "SELECT COUNT(*) AS c FROM orders WHERE {$where_base} {$extra}";
    $r = $mysqli->query($sql);
    if(!$r) return 0;
    $row = $r->fetch_assoc();
    return (int)($row['c'] ?? 0);
}

$assigned  = countOrders($mysqli, $where_base, " AND shipping_status='assigned_to_buyer'");
$purchased = countOrders($mysqli, $where_base, " AND shipping_status='purchased'");
$handover  = countOrders($mysqli, $where_base, " AND shipping_status='handover_to_head'");
$active    = countOrders($mysqli, $where_base, " AND shipping_status NOT IN ('delivered','failed')");
?>
<!doctype html>
<html lang="fa" dir="rtl">
<head>
<meta charset="utf-8">
<title>سفارش‌های مسئول خرید</title>
<meta name="viewport" content="width=device-width,initial-scale=1">
<style>
body{background:#f3f5f9;font-family:'IRANSansWeb',sans-serif;margin:0;}
.page{max-width:1100px;margin:0 auto;padding:10px;}
.card{background:#fff;border-radius:10px;padding:12px 14px;box-shadow:0 2px 6px rgba(0,0,0,0.05);margin-top:10px;}
h1{margin:0 0 10px;font-size:18px;font-weight:700;}
.stats{display:flex;flex-wrap:wrap;gap:8px;margin-bottom:6px;}
.stat-box{flex:1;min-width:140px;background:#eff6ff;border-radius:10px;padding:8px 10px;font-size:13px;display:flex;justify-content:space-between;align-items:center;}
.stat-box .num{font-size:18px;font-weight:700;}
.filter-row{display:flex;flex-wrap:wrap;gap:8px;margin:8px 0;}
.filter-row input,.filter-row select{
  padding:7px 9px;border-radius:6px;border:1px solid #d1d5db;font-size:13px;
}
.filter-row button{
  padding:7px 12px;border-radius:6px;border:none;background:#0ea5e9;color:#fff;font-size:13px;cursor:pointer;
}
.table{width:100%;border-collapse:collapse;font-size:13px;}
.table th{background:#e5f3ff;padding:8px;border-bottom:1px solid #cbd5e1;text-align:right;white-space:nowrap;}
.table td{padding:8px;border-bottom:1px solid #e5e7eb;white-space:nowrap;}
.badge{display:inline-block;padding:2px 7px;border-radius:999px;font-size:12px;background:#f3f4f6;color:#111827;}
.btn{padding:4px 10px;border-radius:6px;font-size:12px;text-decoration:none;border:none;cursor:pointer;}
.btn-view{background:#0ea5e9;color:#fff;}
@media(max-width:720px){
  .table{display:block;overflow-x:auto;}
}
</style>
</head>
<body>

<?php require __DIR__.'/../includes/header.php'; ?>

<div class="page">

  <div class="card">
    <h1>🛒 سفارش‌های ارجاع‌شده به مسئول خرید</h1>

    <div class="stats">
      <div class="stat-box">
        <div>ارجاع شده (در انتظار خرید)</div>
        <div class="num"><?=$assigned?></div>
      </div>
      <div class="stat-box">
        <div>خریداری شده</div>
        <div class="num"><?=$purchased?></div>
      </div>
      <div class="stat-box">
        <div>تحویل به سر باربر</div>
        <div class="num"><?=$handover?></div>
      </div>
      <div class="stat-box">
        <div>سفارشات فعال</div>
        <div class="num"><?=$active?></div>
      </div>
    </div>

    <form method="get" class="filter-row">
      <input type="text" name="q" value="<?=htmlspecialchars($q)?>" placeholder="جستجو: نام مشتری، موبایل، UID، فاکتور">
      <select name="status">
        <option value="">همه وضعیت‌ها</option>
        <?php foreach($valid_statuses as $st): ?>
          <option value="<?=$st?>" <?=$status===$st?'selected':''?>><?=statusLabel($st)?></option>
        <?php endforeach; ?>
      </select>
      <button type="submit">فیلتر</button>
    </form>

    <table class="table">
      <thead>
        <tr>
          <th>#</th>
          <th>UID</th>
          <th>مشتری</th>
          <th>مبلغ کل</th>
          <th>استان</th>
          <th>تاریخ ثبت</th>
          <th>وضعیت</th>
          <th>عملیات</th>
        </tr>
      </thead>
      <tbody>
      <?php
      $i=1;
      while($row = $res->fetch_assoc()):
        $uid = $row['order_uid'] ?? '';
      ?>
        <tr>
          <td><?=$i++?></td>
          <td><?=htmlspecialchars($uid)?></td>
          <td><?=htmlspecialchars($row['customer_name'] ?? '')?></td>
          <td><?=nf($row['total_amount'] ?? 0)?> تومان</td>
          <td><?=htmlspecialchars($row['province'] ?? '')?></td>
          <td><?=toJalaliEn($row['created_at'] ?? '')?></td>
          <td><span class="badge"><?=statusLabel($row['shipping_status'] ?? '')?></span></td>
          <td>
            <?php if($uid): ?>
              <a class="btn btn-view" href="buyer_view.php?id=<?=urlencode($uid)?>">مشاهده</a>
            <?php endif; ?>
          </td>
        </tr>
      <?php endwhile; ?>
      <?php if($i===1): ?>
        <tr>
          <td colspan="8" style="text-align:center;color:#6b7280;">هیچ سفارشی یافت نشد.</td>
        </tr>
      <?php endif; ?>
      </tbody>
    </table>

  </div>
</div>

</body>
</html>
