<?php
// =====================
//  Start Safe Session
// =====================
if (session_status() === PHP_SESSION_NONE) {
    // امنیت بیشتر برای کوکی‌ها
    session_set_cookie_params([
        'lifetime' => 0,
        'path'     => '/',
        'secure'   => false,
        'httponly' => true,
        'samesite' => 'Lax'
    ]);
    session_start();
}

// =====================
//  Check Login Status
// =====================
if (empty($_SESSION['username']) || empty($_SESSION['role'])) {

    // آدرس فعلی کاربر برای بازگشت بعد از لاگین
    $current = urlencode($_SERVER['REQUEST_URI']);

    header("Location: /orders/login.php?redirect=$current");
    exit;
}

// =====================
// Allowed Roles (GLOBAL)
// =====================
// توجه: admin همیشه دسترسی دارد (حتی اگر این لیست تغییر کند)
$role = $_SESSION['role'] ?? '';

$allowed_roles = [
    'seller',
    'buyer_manager', // مسئول خرید
    'logistic',      // سر باربر / راننده
    'head_carrier',  // سرکاره
    'support',       // پشتیبانی
    'buyer'          // اگر جایی استفاده شود
];

// اگر ادمین نیست و نقش در لیست مجازها نیست → 403
if ($role !== 'admin' && !in_array($role, $allowed_roles, true)) {

    http_response_code(403);
    echo "<h3 style='color:#b91c1c;font-family:IRANSansWeb;text-align:center;margin-top:50px'>
            ❌ دسترسی غیرمجاز
          </h3>";
    exit;
}

// ===== AUTH COMPLETED =====
?>
