<?php
require __DIR__ . '/../includes/auth.php';
require __DIR__ . '/../includes/config.php';
require __DIR__ . '/../includes/db_connect.php';
require_once __DIR__ . '/../includes/jdf.php';

$role     = $_SESSION['role']     ?? '';
$username = $_SESSION['username'] ?? '';

// فقط لجستیک و ادمین
if ($role !== 'logistic' && $role !== 'admin') {
    header("Location: /orders/index.php");
    exit;
}

$status_map = [
    'handover_to_head'  => 'تحویل از مسئول خرید',
    'out_for_delivery'  => 'در حال ارسال',
    'delivered'         => 'تحویل شده',
    'failed'            => 'عدم تحویل'
];

$filter = trim($_GET['status'] ?? '');
$where_status = '';
if ($filter !== '') {
    $fs = $mysqli->real_escape_string($filter);
    $where_status = " AND shipping_status='$fs' ";
}

if ($role === 'admin') {
    $where_user = " head_carrier_username IS NOT NULL ";
} else {
    $u = $mysqli->real_escape_string($username);
    $where_user = " head_carrier_username='$u' ";
}

$sql = "
    SELECT id, order_uid, customer_name, province, total_amount,
           shipping_status, created_at
    FROM orders
    WHERE $where_user
      AND shipping_status IN ('handover_to_head','out_for_delivery')
      $where_status
    ORDER BY id DESC
";
$q = $mysqli->query($sql);

function toJalali($dt){
    if(!$dt) return '-';
    $d = substr($dt,0,10);
    if(!preg_match('/^\d{4}-\d{2}-\d{2}$/',$d)) return '-';
    list($gy,$gm,$gd) = explode('-',$d);
    return gregorian_to_jalali($gy,$gm,$gd,'/');
}
?>
<!doctype html>
<html lang="fa" dir="rtl">
<head>
<meta charset="utf-8">
<title>سفارش‌های لجستیک</title>
<meta name="viewport" content="width=device-width,initial-scale=1">
<link rel="stylesheet" href="/orders/assets/style.css">
<style>
body{background:#f3f6fa;font-family:'IRANSansWeb',sans-serif;}
.page{padding:12px;}
.card{
  background:#fff;border-radius:12px;padding:14px;margin-bottom:16px;
  box-shadow:0 2px 8px rgba(15,23,42,0.06);
}
.card h2{margin:0 0 12px;font-size:18px;font-weight:700;}
select{
  width:100%;padding:8px 10px;margin-bottom:10px;border-radius:8px;border:1px solid #d1d5db;
}
.table-responsive{overflow-x:auto;}
table{width:100%;border-collapse:collapse;font-size:13px;}
th,td{padding:8px 6px;border-bottom:1px solid #e5e7eb;text-align:center;}
th{background:#eef2f7;}
.btn-view{
  display:inline-block;padding:5px 10px;border-radius:8px;
  background:#0284c7;color:#fff;text-decoration:none;font-size:12px;
}
</style>
</head>
<body>
<div class="page">
  <div class="card">
    <h2>🚚 سفارش‌های مربوط به شما (لجستیک)</h2>

    <form>
      <select name="status" onchange="this.form.submit()">
        <option value="">همه وضعیت‌ها</option>
        <option value="handover_to_head" <?=$filter==='handover_to_head'?'selected':''?>>تحویل از مسئول خرید</option>
        <option value="out_for_delivery" <?=$filter==='out_for_delivery'?'selected':''?>>در حال ارسال</option>
      </select>
    </form>

    <div class="table-responsive">
      <table>
        <thead>
          <tr>
            <th>کد</th>
            <th>مشتری</th>
            <th>استان</th>
            <th>مبلغ</th>
            <th>وضعیت</th>
            <th>تاریخ</th>
            <th>عملیات</th>
          </tr>
        </thead>
        <tbody>
          <?php while($r = $q->fetch_assoc()): ?>
          <tr>
            <td><?=$r['order_uid']?></td>
            <td><?=$r['customer_name']?></td>
            <td><?=$r['province']?></td>
            <td><?=number_format($r['total_amount'])?></td>
            <td><?=$status_map[$r['shipping_status']] ?? $r['shipping_status']?></td>
            <td><?=toJalali($r['created_at'])?></td>
            <td>
              <a class="btn-view" href="/orders/management/logistic_view.php?id=<?=$r['id']?>">مشاهده</a>
            </td>
          </tr>
          <?php endwhile; ?>
        </tbody>
      </table>
    </div>

  </div>
</div>
</body>
</html>
