<?php
require __DIR__ . '/../includes/auth.php';
require __DIR__ . '/../includes/config.php';
require __DIR__ . '/../includes/db_connect.php';

$role     = $_SESSION['role']     ?? '';
$username = $_SESSION['username'] ?? '';

if ($role !== 'logistic' && $role !== 'admin') {
    exit('ACCESS DENIED');
}

$id            = (int)($_POST['id'] ?? 0);
$driver_name   = trim($_POST['driver_name'] ?? '');
$driver_phone  = trim($_POST['driver_phone'] ?? '');
$shipping_cost = (int)($_POST['shipping_cost'] ?? 0);
$send_date     = trim($_POST['send_date'] ?? '');
$send_note     = trim($_POST['send_note'] ?? '');

if ($id < 1 || $driver_name === '' || $driver_phone === '') {
    exit('bad data');
}

// یادداشت وضعیت
$parts = [];
$parts[] = "راننده: $driver_name ($driver_phone)";
if ($shipping_cost > 0) $parts[] = "هزینه بار تقریبی: ".number_format($shipping_cost)." تومان";
if ($send_date !== '') $parts[] = "تاریخ خروج: $send_date";
if ($send_note !== '') $parts[] = "توضیح: $send_note";
$status_note = implode(' | ', $parts);

// آپدیت سفارش
if ($role === 'admin') {
    $stmt = $mysqli->prepare("
        UPDATE orders
        SET shipping_status='out_for_delivery', status_note=?
        WHERE id=? LIMIT 1
    ");
    $stmt->bind_param("si", $status_note, $id);
} else {
    $stmt = $mysqli->prepare("
        UPDATE orders
        SET shipping_status='out_for_delivery', status_note=?
        WHERE id=? AND head_carrier_username=? LIMIT 1
    ");
    $stmt->bind_param("sis", $status_note, $id, $username);
}
$stmt->execute();

// نوتیفیکیشن برای فروشنده
$info = $mysqli->query("SELECT username, customer_name FROM orders WHERE id=".$id." LIMIT 1")->fetch_assoc();
if ($info) {
    $seller   = $mysqli->real_escape_string($info['username'] ?? '');
    $customer = $mysqli->real_escape_string($info['customer_name'] ?? '');
    if ($seller !== '') {
        $msg = "سفارش مشتری $customer در حال ارسال است (راننده: $driver_name).";
        $mysqli->query("
            INSERT INTO notifications (username, type, order_id, title, message, created_at)
            VALUES (
              '$seller',
              'status',
              $id,
              'سفارش ارسال شد',
              '$msg',
              NOW()
            )
        ");
    }
}

header("Location: logistic_view.php?id=".$id);
exit;
