<?php
require __DIR__.'/includes/auth.php';
require __DIR__.'/includes/config.php';
require __DIR__.'/includes/db_connect.php';
require __DIR__.'/includes/jdf.php';

$user = $_SESSION['username'];
$is_admin = ($_SESSION['role'] ?? '') === 'admin';

$where = $is_admin ? '1' : "username='".$mysqli->real_escape_string($user)."'";
$q = $mysqli->query("SELECT * FROM orders WHERE $where ORDER BY id DESC");

function nf($n){return number_format((int)$n,0,'.',',');}
function toJalaliEn($date){
  if(!$date || !preg_match('/^\d{4}-\d{2}-\d{2}$/',$date)) return '-';
  list($gy,$gm,$gd)=explode('-',$date);
  $j=gregorian_to_jalali((int)$gy,(int)$gm,(int)$gd,'/');
  return strtr($j, ['۰'=>'0','۱'=>'1','۲'=>'2','۳'=>'3','۴'=>'4','۵'=>'5','۶'=>'6','۷'=>'7','۸'=>'8','۹'=>'9']);
}
?>
<!doctype html>
<html lang="fa" dir="rtl">
<meta charset="utf-8">
<title>لیست فاکتورها | سلام‌بابا</title>
<link rel="stylesheet" href="assets/order.css">
<body>
<div class="container">
<?php require __DIR__.'/includes/header.php'; ?>
<section class="card">
  <h3>📦 فاکتورهای ثبت‌شده</h3>

  <!-- ✅ فیلترها -->
  <form id="filterForm" style="display:flex;flex-wrap:wrap;gap:10px;margin-bottom:16px;">
    <input type="text" name="search" placeholder="🔍 جستجو (نام مشتری یا فروشنده)" style="padding:8px 12px;border:1px solid #ccc;border-radius:8px;flex:1;min-width:180px;">
    <select name="seller" style="padding:8px 12px;border:1px solid #ccc;border-radius:8px;">
      <option value="">همه فروشنده‌ها</option>
      <?php
        $sellers = $mysqli->query("SELECT DISTINCT seller_name FROM orders ORDER BY seller_name ASC");
        while($s = $sellers->fetch_assoc()){
          echo "<option>".htmlspecialchars($s['seller_name'])."</option>";
        }
      ?>
    </select>
    <select name="month" style="padding:8px 12px;border:1px solid #ccc;border-radius:8px;">
      <option value="">ماه</option>
      <?php for($m=1;$m<=12;$m++) echo "<option value='$m'>$m</option>"; ?>
    </select>
    <select name="year" style="padding:8px 12px;border:1px solid #ccc;border-radius:8px;">
      <option value="">سال</option>
      <?php
        $years = $mysqli->query("SELECT DISTINCT YEAR(purchase_date) y FROM orders ORDER BY y DESC");
        while($y = $years->fetch_assoc()){
          echo "<option>".$y['y']."</option>";
        }
      ?>
    </select>
    <button class="btn primary" type="submit">اعمال فیلتر</button>
  </form>

  <!-- ✅ جدول -->
  <div id="ordersTable">
    <table class="table">
      <thead>
        <tr>
          <th>#</th>
          <th>مشتری</th>
          <th>فروشنده</th>
          <th>تاریخ</th>
          <th>جمع فروش</th>
          <th>بیعانه</th>
          <th>مانده</th>
          <th>وضعیت</th>
          <th>عملیات</th>
        </tr>
      </thead>
      <tbody>
        <?php if($q->num_rows==0): ?>
          <tr><td colspan="9" style="text-align:center;color:#777;">هیچ فاکتوری ثبت نشده</td></tr>
        <?php else: $i=1; while($r=$q->fetch_assoc()): ?>
          <tr>
            <td><?=$i++?></td>
            <td><?=htmlspecialchars($r['customer_name'])?></td>
            <td><?=htmlspecialchars($r['seller_name'])?></td>
            <td><?=toJalaliEn($r['purchase_date'])?></td>
            <td><?=nf($r['total_amount'])?></td>
            <td><?=nf($r['total_deposit'])?></td>
            <td><?=nf($r['total_remaining'])?></td>
            <td>
              <?php
$shipping = trim($r['shipping_status'] ?? '');

if ($shipping === '') {
    $shipping = 'new';
}

$map = [
    'new' => '🟦 ثبت شده',
    'assigned_to_buyer' => '🟩 ارجاع به خریدار',
    'purchased' => '🟨 خرید انجام شد',
    'handover_to_head' => '🟧 تحویل به سرپرست ارسال',
    'out_for_delivery' => '🟫 در حال تحویل',
    'delivered' => '🟩 تحویل موفق',
    'failed' => '🟥 تحویل ناموفق'
];

echo $map[$shipping] ?? 'نامشخص';
?>

            </td>
            <td>
              <div class="action-menu">
                <button class="action-btn" aria-label="منوی عملیات">⋯</button>
                <div class="action-list">
                  <a href="view.php?id=<?=htmlspecialchars($r['order_uid'] ?: $r['id'])?>" class="btn small ghost">👁 مشاهده</a>
                  <a href="edit.php?id=<?=htmlspecialchars($r['order_uid'] ?: $r['id'])?>" class="btn small ghost">✏️ ویرایش</a>
                  <a href="invoice.php?id=<?=htmlspecialchars($r['order_uid'] ?: $r['id'])?>" class="btn small ghost">🧾 PDF</a>
                  <?php if($is_admin): ?>
                    <button class="btn small danger" onclick="deleteOrder(<?= (int)$r['id'] ?>)">🗑 حذف</button>
                  <?php endif; ?>
                </div>
              </div>
            </td>
          </tr>
        <?php endwhile; endif; ?>
      </tbody>
    </table>
  </div>
</section>

<script>
async function deleteOrder(id){
  if(!confirm('آیا از حذف این فاکتور مطمئن هستید؟')) return;
  const fd = new FormData();
  fd.append('id', id);
  const r = await fetch('xhr_delete_order.php',{method:'POST',body:fd});
  const j = await r.json();
  alert(j.msg);
  if(j.ok) location.reload();
}
</script>


<script>
document.addEventListener("click", (e) => {
    const isBtn = e.target.closest(".action-btn");

    // اول همه منوها را ببند
    document.querySelectorAll(".action-list").forEach(list => list.classList.remove("show"));

    // اگر روی دکمه عملیات کلیک شد
    if (isBtn) {
        e.stopPropagation();
        const menu = isBtn.closest(".action-menu").querySelector(".action-list");
        menu.classList.toggle("show");
    }
});
</script>


<!-- ✅ فیلتر Ajax -->
<script>
const form = document.getElementById('filterForm');
form.addEventListener('submit', e => { e.preventDefault(); doFilter(); });

async function doFilter(){
  const params = new URLSearchParams(new FormData(form));
  const tbody = document.querySelector('#ordersTable tbody');
  tbody.innerHTML = '<tr><td colspan="9" style="text-align:center;color:#777;">در حال بارگذاری...</td></tr>';

  const res = await fetch('xhr_filter_orders.php?' + params.toString());
  const data = await res.json();
  tbody.innerHTML = data.html;

  document.querySelectorAll('.action-btn').forEach(btn=>{
    btn.addEventListener('click', e=>{
      e.stopPropagation();
      btn.closest('.action-menu').classList.toggle('active');
    });
  });
}
</script>

</body>
</html>
