<?php
require __DIR__ . '/../includes/auth.php';
require __DIR__ . '/../includes/config.php';
require __DIR__ . '/../includes/db_connect.php';

$id = (int)($_GET['id'] ?? 0);
if ($id <= 0) {
    exit('شناسه نامعتبر است.');
}

$res = $mysqli->query("SELECT * FROM product WHERE id={$id} LIMIT 1");
$product = $res->fetch_assoc();
if (!$product) {
    exit('محصول یافت نشد.');
}

$title = $product['title'];
$brand = $product['brand'];
$model = $product['model'];
$price = (int)$product['price'];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $title = trim($_POST['title'] ?? '');
    $brand = trim($_POST['brand'] ?? '');
    $model = trim($_POST['model'] ?? '');
    $price = (int)($_POST['price'] ?? 0);

    if ($title === '') {
        $error = 'عنوان محصول الزامی است.';
    } else {
        $stmt = $mysqli->prepare("UPDATE product SET title=?, brand=?, model=?, price=? WHERE id=?");
        $stmt->bind_param("sssii", $title, $brand, $model, $price, $id);
        $stmt->execute();
        header("Location: index.php");
        exit;
    }
}
?>
<!doctype html>
<html lang="fa" dir="rtl">
<head>
<meta charset="utf-8">
<title>ویرایش محصول</title>
<link rel="stylesheet" href="product.css">
</head>
<body>

<div class="product-page narrow">

  <div class="product-header">
    <h1>ویرایش محصول #<?=$id?></h1>
    <a href="index.php" class="btn-secondary">← بازگشت به لیست</a>
  </div>

  <?php if (!empty($error)): ?>
    <div class="alert alert-error"><?=$error?></div>
  <?php endif; ?>

  <form method="post" class="product-form">
    <div class="field">
      <label>عنوان محصول<span class="req">*</span></label>
      <input type="text" name="title" required value="<?=htmlspecialchars($title)?>">
    </div>

    <div class="field">
      <label>برند</label>
      <input type="text" name="brand" value="<?=htmlspecialchars($brand)?>">
    </div>

    <div class="field">
      <label>مدل</label>
      <input type="text" name="model" value="<?=htmlspecialchars($model)?>">
    </div>

    <div class="field">
      <label>قیمت پایه (تومان)</label>
      <input type="number" name="price" min="0" step="1000" value="<?=htmlspecialchars($price)?>">
    </div>

    <div class="form-actions">
      <button type="submit" class="btn-primary">ذخیره تغییرات</button>
      <a href="index.php" class="btn-secondary">انصراف</a>
    </div>
  </form>

</div>

</body>
</html>
