<?php
require __DIR__.'/../includes/auth.php';
require __DIR__.'/../includes/config.php';
require __DIR__.'/../includes/db_connect.php';

$role = $_SESSION['role'] ?? '';
if ($role !== 'admin') {
    header('Location: seller.php');
    exit;
}

function nf($n){ return number_format((int)$n,0,'.',','); }

$username = trim($_GET['username'] ?? '');
if ($username === '') {
    die('username نامعتبر است.');
}

$stmt = $mysqli->prepare("SELECT id, username, full_name, role, balance, created_at FROM users WHERE username=?");
$stmt->bind_param('s',$username);
$stmt->execute();
$userRow = $stmt->get_result()->fetch_assoc();
if (!$userRow) {
    die('کاربر یافت نشد.');
}

// پردازش ارسال فرم
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $full_name = trim($_POST['full_name'] ?? '');
    $balance   = (int)preg_replace('/[^\d-]/','', $_POST['balance'] ?? '0');

    $upd = $mysqli->prepare("UPDATE users SET full_name=?, balance=? WHERE id=?");
    $upd->bind_param('sii',$full_name,$balance,$userRow['id']);
    $upd->execute();

    header('Location: admin.php');
    exit;
}
?>
<!doctype html>
<html lang="fa" dir="rtl">
<head>
<meta charset="utf-8">
<title>✏️ ویرایش فروشنده <?=htmlspecialchars($userRow['username'])?> | سلام‌بابا</title>
<link rel="stylesheet" href="../assets/style.css">
<style>
body {
  font-family:'IRANSansWeb','IRANYekan',sans-serif;
  background:#f3f4f6;
  margin:0;
  color:#0f172a;
}
.container {
  max-width:600px;
  margin:0 auto;
  padding:20px;
}
.card {
  background:#fff;
  border-radius:16px;
  box-shadow:0 2px 10px rgba(15,23,42,0.08);
  padding:20px 24px;
}
.card h3 {
  margin:0 0 15px;
  font-size:18px;
}
.form-row {
  margin-bottom:12px;
}
.form-row label {
  display:block;
  font-size:13px;
  margin-bottom:4px;
}
.form-row input[type="text"],
.form-row input[type="number"] {
  width:100%;
  padding:7px 10px;
  border-radius:8px;
  border:1px solid #d1d5db;
  font-size:13px;
}
.actions {
  display:flex;
  justify-content:flex-end;
  gap:8px;
  margin-top:16px;
}
.btn {
  background:#2563eb;
  color:#fff;
  padding:7px 14px;
  border-radius:8px;
  font-size:13px;
  text-decoration:none;
  border:none;
  cursor:pointer;
}
.btn:hover { background:#1d4ed8; }
.btn.ghost {
  background:#f3f4f6;
  color:#111827;
}
.btn.ghost:hover { background:#e5e7eb; }
.meta {
  font-size:12px;
  color:#6b7280;
  margin-top:8px;
}
</style>
</head>
<body>
<div class="container">
<?php require __DIR__.'/../includes/header.php'; ?>

<div class="card">
  <h3>✏️ ویرایش فروشنده: <?=htmlspecialchars($userRow['username'])?></h3>

  <form method="post">
    <div class="form-row">
      <label>نام کامل</label>
      <input type="text" name="full_name" value="<?=htmlspecialchars($userRow['full_name'])?>">
    </div>

    <div class="form-row">
      <label>مانده حساب (balance) — به تومان</label>
      <input type="text" name="balance" value="<?=htmlspecialchars($userRow['balance'])?>">
    </div>

    <div class="meta">
      نقش: <?=htmlspecialchars($userRow['role'])?> — ایجاد شده در: <?=$userRow['created_at']?>
    </div>

    <div class="actions">
      <a href="admin.php" class="btn ghost">انصراف</a>
      <button type="submit" class="btn">ذخیره تغییرات</button>
    </div>
  </form>
</div>
</div>
</body>
</html>
