<?php
session_start();
if(isset($_SESSION['user_id'])){header('Location: index.php');exit;}
require __DIR__.'/includes/db_connect.php'; 
$msg='';

if($_SERVER['REQUEST_METHOD']==='POST'){
  $u=trim($_POST['username']??''); 
  $p=$_POST['password']??'';
  $remember = isset($_POST['remember']); // تیک مرا به خاطر بسپار
  $st=$mysqli->prepare('SELECT id,username,password_hash,full_name,role FROM users WHERE username=?');
  $st->bind_param('s',$u);
  $st->execute();
  $row=$st->get_result()->fetch_assoc();
  if($row && password_verify($p,$row['password_hash'])){
    $_SESSION=[
      'user_id'=>$row['id'],
      'username'=>$row['username'],
      'full_name'=>$row['full_name'],
      'role'=>$row['role']
    ];

    // ===============================
    // 🔹 Remember Admin for 30 days (only if checked)
    // ===============================
    if($row['role']==='admin' && $remember){
      $token = bin2hex(random_bytes(32));
      setcookie('remember_admin', $token, time() + (86400 * 30), '/', '', false, true);
      $stmt = $mysqli->prepare("UPDATE users SET remember_token=? WHERE username=?");
      $stmt->bind_param('ss', $token, $row['username']);
      $stmt->execute();
      $stmt->close();
    }
    // ===============================

    header('Location: index.php');exit;
  } else {
    $msg='نام کاربری یا رمز عبور اشتباه است.';
  }
}
?>
<!doctype html>
<html lang="fa" dir="rtl">
<head>
<meta charset="utf-8">
<title>ورود فروشندگان — سلام‌بابا</title>
<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
<link rel="stylesheet" href="/orders/assets/login.css">
</head>
<body>

  <div class="login-box">
    <!-- 🔹 Four-color animated logo -->
    <div class="logo-stripes" aria-label="لوگوی چهار رنگ سلام‌بابا">
      <span class="b"></span><span class="g"></span><span class="y"></span><span class="r"></span>
    </div>

    <!-- 🔹 Welcome message -->
    <div class="welcome">
      <h1>بەخێربێن بۆ سەلامـ بابا.</h1>
    </div>

    <!-- 🔹 Motivation box -->
    <div class="motivation">💙💚💛🧡 <hr>شوێنێک کە تێیدا هەوڵدەدەین بۆ گەیشتن بە خەونەکانمان</div>

    <?php if($msg):?>
      <div class="note"><?=$msg?></div>
    <?php endif;?>

    <!-- 🔹 Login form -->
    <form method="post">
      <label class="field">
        <span>ناوی بەکارهێنەر:</span>
        <input name="username" required autofocus>
      </label>

      <label class="field">
        <span>وشەی نهێنی:</span>
        <input type="password" name="password" required>
      </label>

      <button class="btn">چوونەژوورەوە</button>
    </form>
  </div>

</body>
</html>
