<?php
require __DIR__.'/includes/auth.php';
require __DIR__.'/includes/config.php';
require __DIR__.'/includes/db_connect.php';
header('Content-Type: application/json; charset=utf-8');

function nf($n){ return number_format((float)$n, 0, '.', ','); }

$uid  = trim($_POST['order_uid'] ?? '');
$oid  = isset($_POST['order_id']) ? (int)$_POST['order_id'] : 0;
$amt  = (int)preg_replace('/[^\d]/','', (string)($_POST['amount'] ?? 0));
$note = trim($_POST['note'] ?? '');

if ($uid !== '') {
  $stmt = $mysqli->prepare('SELECT id FROM orders WHERE order_uid=? LIMIT 1');
  $stmt->bind_param('s', $uid);
  $stmt->execute();
  $row = $stmt->get_result()->fetch_assoc();
  $stmt->close();
  if ($row) { $oid = (int)$row['id']; }
}

if ($oid <= 0 || $amt <= 0) {
  echo json_encode(['ok'=>false,'error'=>'اطلاعات ناقص یا نامعتبر']); exit;
}

$stmt = $mysqli->prepare('INSERT INTO withdrawals (order_id, amount, note) VALUES (?, ?, ?)');
$stmt->bind_param('iis', $oid, $amt, $note);
if (!$stmt->execute()) {
  echo json_encode(['ok'=>false,'error'=>'ثبت ناموفق']); exit;
}
$id = $stmt->insert_id;
$stmt->close();

echo json_encode([
  'ok'=>true,
  'id'=>$id,
  'amount'=>$amt,
  'amount_fmt'=>nf($amt),
  'note'=>$note,
  'created_at'=>date('Y-m-d H:i:s'),
]);
