<?php
require __DIR__.'/includes/config.php';
require __DIR__.'/includes/db_connect.php';
require __DIR__.'/includes/auth.php';
header('Content-Type: application/json; charset=utf-8');

$id = intval($_POST['id'] ?? 0);
if(!$id){ echo json_encode(['ok'=>false,'msg'=>'شناسه سفارش نامعتبر است']); exit; }

$cust = trim($_POST['customer_name'] ?? '');
$addr = trim($_POST['address'] ?? '');
$seller = trim($_POST['seller_name'] ?? '');
$war = $_POST['warranty'] ?? 'none';
$notes = trim($_POST['notes'] ?? '');
$items = $_POST['items'] ?? [];

if($cust=='' || $addr=='' || $seller==''){
  echo json_encode(['ok'=>false,'msg'=>'اطلاعات ناقص است']); exit;
}

try {
  $mysqli->begin_transaction();

  // آپدیت جدول orders
  $st = $mysqli->prepare("UPDATE orders SET customer_name=?, address=?, seller_name=?, warranty=?, notes=? WHERE id=?");
  $st->bind_param("sssssi",$cust,$addr,$seller,$war,$notes,$id);
  $st->execute();
  $st->close();

  // حذف اقلام قدیمی و درج مجدد (ساده و مطمئن)
  $mysqli->query("DELETE FROM order_items WHERE order_id=$id");
  $sti = $mysqli->prepare("INSERT INTO order_items (order_id, model, price, deposit, cod, remaining) VALUES (?,?,?,?,?,?)");

  foreach($items as $row){
    $m = trim($row['model'] ?? '');
    $p = (int)($row['price'] ?? 0);
    $d = (int)($row['deposit'] ?? 0);
    $c = (int)($row['cod'] ?? 0);
    $r = max($p - $d - $c, 0);
    if($m!==''){
      $sti->bind_param('isiiii',$id,$m,$p,$d,$c,$r);
      $sti->execute();
    }
  }
  $sti->close();

  $mysqli->commit();
  echo json_encode(['ok'=>true,'msg'=>'تغییرات با موفقیت ذخیره شد ✅']);
} catch(Throwable $e){
  $mysqli->rollback();
  echo json_encode(['ok'=>false,'msg'=>'DB ERROR: '.$e->getMessage()]);
}
