<?php
require __DIR__.'/../includes/auth.php';
require __DIR__.'/../includes/config.php';
require __DIR__.'/../includes/db_connect.php';
require_once __DIR__.'/../includes/jdf.php';

$user  = $_SESSION['username'] ?? '';
$role  = $_SESSION['role'] ?? '';
$is_admin = ($role === 'admin');

function nf($n){ return number_format((int)$n,0,'.',','); }

if (!function_exists('toJalaliEn')) {
  function toJalaliEn($date){
    if(!$date || !preg_match('/^\d{4}-\d{2}-\d{2}/',$date)) return '-';
    list($gy,$gm,$gd) = explode('-', substr($date,0,10));
    if(!function_exists('gregorian_to_jalali')) return $date;
    return gregorian_to_jalali((int)$gy,(int)$gm,(int)$gd,'/');
  }
}

// ------------------ تعیین فروشنده هدف ------------------
$targetUsername = $user;
if ($is_admin && !empty($_GET['username'])) {
    $targetUsername = trim($_GET['username']);
}

// اگر فروشنده وجود نداشت → خطای ساده
$stmt = $mysqli->prepare("SELECT username, full_name, balance FROM users WHERE username=? AND role='seller'");
$stmt->bind_param('s',$targetUsername);
$stmt->execute();
$seller = $stmt->get_result()->fetch_assoc();
if (!$seller) {
    die('فروشنده پیدا نشد.');
}

// ------------------ پردازش فرم‌های برداشت (POST) ------------------
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $action = $_POST['action'] ?? '';
    // فقط مدیر یا خود فروشنده
    $allowed = $is_admin || $targetUsername === $user;
    if ($allowed) {
        if ($action === 'add_withdraw') {
            $order_id = (int)($_POST['order_id'] ?? 0);
            $amount   = (int)preg_replace('/[^\d]/','', $_POST['amount'] ?? '0');
            $note     = trim($_POST['note'] ?? '');
            if ($order_id > 0 && $amount > 0) {
                $ins = $mysqli->prepare("INSERT INTO withdrawals (order_id, amount, note, created_at) VALUES (?,?,?,NOW())");
                $ins->bind_param('iis',$order_id,$amount,$note);
                $ins->execute();
            }
        } elseif ($action === 'edit_withdraw') {
            $wid     = (int)($_POST['withdraw_id'] ?? 0);
            $amount  = (int)preg_replace('/[^\d]/','', $_POST['amount'] ?? '0');
            $note    = trim($_POST['note'] ?? '');
            if ($wid > 0 && $amount > 0) {
                $upd = $mysqli->prepare("UPDATE withdrawals SET amount=?, note=? WHERE id=?");
                $upd->bind_param('isi',$amount,$note,$wid);
                $upd->execute();
            }
        } elseif ($action === 'delete_withdraw') {
            $wid = (int)($_POST['withdraw_id'] ?? 0);
            if ($wid > 0) {
                $del = $mysqli->prepare("DELETE FROM withdrawals WHERE id=?");
                $del->bind_param('i',$wid);
                $del->execute();
            }
        }
    }
    $qs = [];
    if (!empty($_GET['month'])) $qs['month'] = $_GET['month'];
    if ($is_admin && !empty($_GET['username'])) $qs['username'] = $_GET['username'];
    $qstr = http_build_query($qs);
    header("Location: seller.php".($qstr ? "?$qstr" : ""));
    exit;
}

// ------------------ فیلترها ------------------
$month   = $_GET['month'] ?? date('Y-m');
$type    = $_GET['type']  ?? 'all'; // all | deposit | withdraw

list($y,$m) = explode('-',$month);
$monthStart = "$y-$m-01 00:00:00";
$monthEnd   = date('Y-m-t 23:59:59', strtotime($monthStart));

// بالانس ابتدای ماه
$startBalStmt = $mysqli->prepare("
  SELECT
    (SELECT COALESCE(SUM(total_deposit),0)
       FROM orders
      WHERE username = ?
        AND created_at < ?) 
    -
    (SELECT COALESCE(SUM(w.amount),0)
       FROM withdrawals w
       JOIN orders o ON o.id = w.order_id
      WHERE o.username = ?
        AND o.created_at < ?)
  AS start_balance
");
$startBalStmt->bind_param('ssss',$targetUsername,$monthStart,$targetUsername,$monthStart);
$startBalStmt->execute();
$startBalanceRow = $startBalStmt->get_result()->fetch_assoc();
$startBalance = (int)$startBalanceRow['start_balance'];

// آمار کلی فروشنده
$statStmt = $mysqli->prepare("
  SELECT
    COALESCE(SUM(total_deposit),0) AS total_deposit,
    (
      SELECT COALESCE(SUM(w.amount),0)
      FROM withdrawals w
      JOIN orders o2 ON o2.id = w.order_id
      WHERE o2.username = ?
    ) AS total_withdraw
  FROM orders o
  WHERE o.username = ?
");
$statStmt->bind_param('ss',$targetUsername,$targetUsername);
$statStmt->execute();
$stat = $statStmt->get_result()->fetch_assoc();
$totalDepositAll  = (int)$stat['total_deposit'];
$totalWithdrawAll = (int)$stat['total_withdraw'];
$currentBalance   = $totalDepositAll - $totalWithdrawAll;

// تراکنش‌های این ماه
$txStmt = $mysqli->prepare("
  SELECT 
    o.id AS order_id,
    o.order_uid,
    o.invoice_no,
    o.customer_name,
    o.created_at,
    o.total_deposit,
    COALESCE(SUM(w.amount),0) AS total_withdraw
  FROM orders o
  LEFT JOIN withdrawals w ON w.order_id = o.id
  WHERE o.username = ?
    AND o.created_at BETWEEN ? AND ?
  GROUP BY o.id
  ORDER BY o.created_at ASC, o.id ASC
");

$txStmt->bind_param('sss',$targetUsername,$monthStart,$monthEnd);
$txStmt->execute();
$txRes = $txStmt->get_result();

// لیست همه برداشت‌ها برای ساخت مودال‌ها
$wdStmt = $mysqli->prepare("
  SELECT w.id,w.order_id,w.amount,w.note,w.created_at
  FROM withdrawals w
  JOIN orders o ON o.id = w.order_id
  WHERE o.username = ?
  ORDER BY w.created_at ASC, w.id ASC
");
$wdStmt->bind_param('s',$targetUsername);
$wdStmt->execute();
$wdRes = $wdStmt->get_result();
$withdrawByOrder = [];
while($w = $wdRes->fetch_assoc()){
    $withdrawByOrder[$w['order_id']][] = $w;
}
?>
<!doctype html>
<html lang="fa" dir="rtl">
<head>
<meta charset="utf-8">
<title>📋 گردش حساب: <?=htmlspecialchars($seller['username'])?> | سلام‌بابا</title>
<link rel="stylesheet" href="../assets/style.css">
<style>
body {
  font-family:'IRANSansWeb','IRANYekan',sans-serif;
  background:#f3f4f6;
  margin:0;
  color:#0f172a;
}
.container {
  max-width:1200px;
  margin:0 auto;
  padding:20px;
}
.card {
  background:#fff;
  border-radius:16px;
  box-shadow:0 2px 10px rgba(15,23,42,0.08);
  padding:20px 24px;
  margin-bottom:20px;
}
.card h3 {
  margin:0 0 10px;
  font-size:18px;
  display:flex;
  align-items:center;
  gap:6px;
}
.stats {
  display:flex;
  flex-wrap:wrap;
  gap:12px;
  margin-top:12px;
}
.stat {
  flex:1 1 200px;
  background:linear-gradient(135deg,#eff6ff,#ffffff);
  border-radius:14px;
  padding:12px 14px;
  border:1px solid #e5e7eb;
}
.stat span {
  font-size:12px;
  color:#6b7280;
}
.stat b {
  display:block;
  margin-top:4px;
  font-size:17px;
}
.stat.deposit b { color:#0ea5e9; }
.stat.withdraw b { color:#f97316; }
.stat.balance b { color:#22c55e; }

.filter-row {
  display:flex;
  flex-wrap:wrap;
  gap:10px;
  margin-top:10px;
  align-items:center;
}
.filter-row label {
  font-size:13px;
}
.filter-row input[type="month"],
.filter-row select {
  padding:6px 9px;
  border-radius:8px;
  border:1px solid #d1d5db;
  font-size:13px;
}
.filter-row button {
  background:#2563eb;
  color:#fff;
  border:none;
  padding:7px 14px;
  border-radius:8px;
  font-size:13px;
  cursor:pointer;
}
.filter-row button:hover { background:#1d4ed8; }

.table-wrapper {
  margin-top:14px;
  background:#fff;
  border-radius:12px;
  border:1px solid #e5e7eb;
  overflow-x:auto;
}
.finance-table {
  width:100%;
  border-collapse:collapse;
  min-width:850px;
  font-size:13px;
}
.finance-table th,
.finance-table td {
  padding:8px 10px;
  text-align:center;
  border-bottom:1px solid #f1f5f9;
  white-space:nowrap;
}
.finance-table th {
  background:#f9fafb;
  font-weight:600;
  color:#111827;
  position:sticky;
  top:0;
  z-index:1;
}
.finance-table tr:nth-child(even) td { background:#f9fafb; }
.finance-table tr:hover td { background:#eff6ff; }

.balance-pos { color:#16a34a;font-weight:bold; }
.balance-neg { color:#dc2626;font-weight:bold; }

.btn {
  background:#2563eb;
  color:#fff;
  padding:4px 9px;
  border-radius:8px;
  font-size:12px;
  text-decoration:none;
  display:inline-block;
}
.btn:hover { background:#1d4ed8; }
.btn.ghost {
  background:#f3f4f6;
  color:#111827;
}
.btn.ghost:hover { background:#e5e7eb; }
.btn.sm { font-size:11px; padding:3px 7px; }

/* مودال برداشت‌ها */
.modal-backdrop {
  position:fixed;
  inset:0;
  background:rgba(15,23,42,0.5);
  display:none;
  align-items:center;
  justify-content:center;
  z-index:50;
}
.modal {
  background:#fff;
  border-radius:16px;
  max-width:520px;
  width:100%;
  padding:16px 18px;
  max-height:80vh;
  overflow-y:auto;
  box-shadow:0 10px 30px rgba(15,23,42,0.35);
}
.modal-header {
  display:flex;
  justify-content:space-between;
  align-items:center;
  margin-bottom:8px;
}
.modal-header h4 {
  margin:0;
  font-size:15px;
}
.close-btn {
  border:none;
  background:transparent;
  font-size:18px;
  cursor:pointer;
}
.modal section {
  margin-bottom:14px;
}
.modal table {
  width:100%;
  border-collapse:collapse;
  font-size:12px;
}
.modal th,.modal td {
  padding:5px 6px;
  text-align:center;
  border-bottom:1px solid #e5e7eb;
}
.modal-form-row {
  display:flex;
  flex-wrap:wrap;
  gap:8px;
  margin-bottom:8px;
}
.modal-form-row input[type="text"],
.modal-form-row input[type="number"],
.modal-form-row textarea {
  flex:1;
  min-width:120px;
  padding:6px 8px;
  border-radius:8px;
  border:1px solid #d1d5db;
  font-size:12px;
}
.modal-form-row textarea {
  min-height:60px;
}
.modal-form-row button {
  background:#22c55e;
  color:#fff;
  border:none;
  padding:6px 10px;
  border-radius:8px;
  font-size:12px;
  cursor:pointer;
}
.modal-form-row button:hover { background:#16a34a; }

.modal small {
  font-size:11px;
  color:#6b7280;
}

@media (max-width:768px){
  .container { padding:10px; }
  .finance-table { font-size:12px; }
  .finance-table th,.finance-table td { padding:6px; }
}
</style>
</head>
<body>
<div class="container">
<?php require __DIR__.'/../includes/header.php'; ?>

<section class="card">
  <h3>📋 گردش حساب: <?=htmlspecialchars($seller['username'])?> <?=($seller['full_name']?' — '.htmlspecialchars($seller['full_name']):'')?></h3>
  <div class="stats">
    <div class="stat deposit">
      <span>جمع کل بیعانه‌ها</span>
      <b><?=nf($totalDepositAll)?> تومان</b>
    </div>
    <div class="stat withdraw">
      <span>جمع کل برداشت‌ها</span>
      <b><?=nf($totalWithdrawAll)?> تومان</b>
    </div>
    <div class="stat balance">
      <span>مانده کل حساب (تا این لحظه)</span>
      <b><?=nf($currentBalance)?> تومان</b>
    </div>
    <div class="stat">
      <span>مانده ابتدای ماه <?=toJalaliEn($monthStart)?></span>
      <b><?=nf($startBalance)?> تومان</b>
    </div>
  </div>

  <form method="get" class="filter-row">
    <?php if($is_admin): ?>
      <input type="hidden" name="username" value="<?=htmlspecialchars($targetUsername)?>">
    <?php endif; ?>
    <label>ماه:</label>
    <input type="month" name="month" value="<?=$month?>">
    <label>نوع تراکنش:</label>
    <select name="type">
      <option value="all"     <?=$type==='all'?'selected':''?>>همه</option>
      <option value="deposit" <?=$type==='deposit'?'selected':''?>>فقط بیعانه‌دار</option>
      <option value="withdraw"<?=$type==='withdraw'?'selected':''?>>فقط برداشت‌دار</option>
    </select>
    <button type="submit">اعمال فیلتر</button>
    <?php if($is_admin): ?>
      <a class="btn ghost" href="admin.php" style="margin-right:auto;">⬅ بازگشت به داشبورد مدیر</a>
    <?php endif; ?>
  </form>
</section>

<section class="card">
  <h3>💰 تراکنش‌های ماه <?=toJalaliEn($monthStart)?></h3>
  <div class="table-wrapper">
    <table class="finance-table">
      <thead>
        <tr>
          <th>#</th>
          <th>نام مشتری</th>
          <th>تاریخ فاکتور</th>
          <th>بیعانه</th>
          <th>برداشت</th>
          <th>مانده پس از تراکنش</th>
          <th>عملیات</th>
        </tr>
      </thead>
      <tbody>
      <?php
        $i = 1;
        $runningBalance = $startBalance;
        $hasRows = false;
        while($r = $txRes->fetch_assoc()):
          $deposit  = (int)$r['total_deposit'];
          $withdraw = (int)$r['total_withdraw'];

          if ($type === 'deposit' && $deposit <= 0)  continue;
          if ($type === 'withdraw' && $withdraw <= 0) continue;

          $hasRows = true;
          $runningBalance += $deposit - $withdraw;
          $balClass = $runningBalance >= 0 ? 'balance-pos' : 'balance-neg';
          $orderId = (int)$r['order_id'];
          $wdList  = $withdrawByOrder[$orderId] ?? [];
          $wdJson  = htmlspecialchars(json_encode($wdList, JSON_UNESCAPED_UNICODE), ENT_QUOTES, 'UTF-8');
      ?>
        <tr>
          <td><?=$i++?></td>
          <td><?=htmlspecialchars($r['customer_name'])?></td>
          <td><?=toJalaliEn(substr($r['created_at'],0,10))?></td>
          <td><?=nf($deposit)?></td>
          <td><?=nf($withdraw)?></td>
          <td class="<?=$balClass?>"><?=nf($runningBalance)?></td>
<td>
    <a href="../view.php?id=<?= htmlspecialchars($r['order_uid'], ENT_QUOTES, 'UTF-8') ?>"
       class="btn sm">👁 مشاهده</a>

    <a href="../edit.php?id=<?= htmlspecialchars($r['order_uid'], ENT_QUOTES, 'UTF-8') ?>"
       class="btn ghost sm">✏️ ویرایش</a>

    <button type="button"
            class="btn sm"
            onclick="openWithdrawModal(
                <?= (int)$r['order_id'] ?>,
                '<?= htmlspecialchars($r['customer_name'], ENT_QUOTES, 'UTF-8') ?>',
                <?= (int)$deposit ?>,
                '<?= $wdJson ?>'
            )">
      💸 برداشت‌ها
    </button>
</td>


        </tr>
      <?php endwhile; ?>
      <?php if(!$hasRows): ?>
        <tr><td colspan="7">📭 در این ماه هیچ تراکنشی برای این فیلتر ثبت نشده است.</td></tr>
      <?php endif; ?>
      </tbody>
    </table>
  </div>
</section>

<!-- مودال مدیریت برداشت‌ها -->
<div class="modal-backdrop" id="withdrawModalBackdrop">
  <div class="modal">
    <div class="modal-header">
      <h4>مدیریت برداشت‌ها</h4>
      <button class="close-btn" onclick="closeWithdrawModal()">×</button>
    </div>
    <div id="withdrawModalBody"></div>
  </div>
</div>

<script>
function closeWithdrawModal(){
  document.getElementById('withdrawModalBackdrop').style.display = 'none';
  document.getElementById('withdrawModalBody').innerHTML = '';
}

function openWithdrawModal(orderId, customerName, deposit, wdJson){
  const backdrop = document.getElementById('withdrawModalBackdrop');
  const body     = document.getElementById('withdrawModalBody');
  let withdrawals = [];
  try {
    withdrawals = wdJson ? JSON.parse(wdJson) : [];
  } catch(e){ withdrawals = []; }

  let html = '';
  html += '<section>';
  html += '<strong>فاکتور #' + orderId + '</strong>';
  html += '<br>مشتری: ' + customerName;
  html += '<br>بیعانه ثبت شده: ' + deposit.toLocaleString('fa-IR') + ' تومان';
  html += '</section>';

  // لیست برداشت‌های موجود
  html += '<section>';
  html += '<h5 style="margin:0 0 4px;">برداشت‌های ثبت شده</h5>';
  if (withdrawals.length === 0){
    html += '<small>هنوز هیچ برداشتی برای این فاکتور ثبت نشده است.</small>';
  } else {
    html += '<table><thead><tr><th>تاریخ</th><th>مبلغ</th><th>یادداشت</th><th>ویرایش</th><th>حذف</th></tr></thead><tbody>';
    withdrawals.forEach(function(w){
      html += '<tr>';
      html += '<td>' + (w.created_at || '') + '</td>';
      html += '<td>' + (parseInt(w.amount)||0).toLocaleString('fa-IR') + '</td>';
      html += '<td>' + (w.note || '') + '</td>';

      // فرم ویرایش
      html += '<td>';
      html += '<form method="post" style="display:inline-block;">';
      html += '<input type="hidden" name="action" value="edit_withdraw">';
      html += '<input type="hidden" name="withdraw_id" value="'+ w.id +'">';
      html += '<input type="hidden" name="month" value="<?=$month?>">';
      html += '<input type="hidden" name="type" value="<?=$type?>">';
      <?php if($is_admin): ?>
      html += '<input type="hidden" name="username" value="<?=htmlspecialchars($targetUsername,ENT_QUOTES,'UTF-8')?>">';
      <?php endif; ?>
      html += '<input type="text" name="amount" value="'+ w.amount +'" style="width:90px;font-size:11px;margin-bottom:3px;">';
      html += '<input type="text" name="note" value="'+ (w.note || '') +'" style="width:120px;font-size:11px;margin-bottom:3px;">';
      html += '<button type="submit" style="font-size:11px;padding:2px 6px;">ذخیره</button>';
      html += '</form>';
      html += '</td>';

      // فرم حذف
      html += '<td>';
      html += '<form method="post" onsubmit="return confirm(\'حذف این برداشت؟\');" style="display:inline-block;">';
      html += '<input type="hidden" name="action" value="delete_withdraw">';
      html += '<input type="hidden" name="withdraw_id" value="'+ w.id +'">';
      html += '<input type="hidden" name="month" value="<?=$month?>">';
      html += '<input type="hidden" name="type" value="<?=$type?>">';
      <?php if($is_admin): ?>
      html += '<input type="hidden" name="username" value="<?=htmlspecialchars($targetUsername,ENT_QUOTES,'UTF-8')?>">';
      <?php endif; ?>
      html += '<button type="submit" style="font-size:11px;padding:2px 6px;background:#fee2e2;color:#b91c1c;border:none;border-radius:6px;">حذف</button>';
      html += '</form>';
      html += '</td>';

      html += '</tr>';
    });
    html += '</tbody></table>';
  }
  html += '</section>';

  // فرم افزودن برداشت جدید
  html += '<section>';
  html += '<h5 style="margin:4px 0;">افزودن برداشت جدید</h5>';
  html += '<form method="post">';
  html += '<input type="hidden" name="action" value="add_withdraw">';
  html += '<input type="hidden" name="order_id" value="'+ orderId +'">';
  html += '<input type="hidden" name="month" value="<?=$month?>">';
  html += '<input type="hidden" name="type" value="<?=$type?>">';
  <?php if($is_admin): ?>
  html += '<input type="hidden" name="username" value="<?=htmlspecialchars($targetUsername,ENT_QUOTES,'UTF-8')?>">';
  <?php endif; ?>
  html += '<div class="modal-form-row">';
  html += '<input type="text" name="amount" placeholder="مبلغ برداشت (تومان)">';
  html += '<input type="text" name="note" placeholder="یادداشت (اختیاری)">';
  html += '<button type="submit">ثبت برداشت</button>';
  html += '</div>';
  html += '<small>توجه: مجموع برداشت‌ها نباید از بیعانه بیشتر شود (محدودیت نرم‌افزاری هنوز اعمال نشده است).</small>';
  html += '</form>';
  html += '</section>';

  body.innerHTML = html;
  backdrop.style.display = 'flex';
}
</script>
</div>
</body>
</html>
