(function () {
  // ---- کمکی‌ها ----
  function div(a, b) { return Math.floor(a / b); }
  function fa2en(s) {
    return s.replace(/[۰-۹٠-٩]/g, d => {
      const f = "۰۱۲۳۴۵۶۷۸۹", a = "٠١٢٣٤٥٦٧٨٩";
      let i = f.indexOf(d);
      if (i !== -1) return String(i);
      i = a.indexOf(d);
      return i !== -1 ? String(i) : d;
    });
  }

  // ---- تبدیل تاریخ‌ها ----
  function gregorianToJD(gy, gm, gd) {
    var a = div(14 - gm, 12),
      y = gy + 4800 - a,
      m = gm + 12 * a - 3;
    return gd + div(153 * m + 2, 5) + 365 * y + div(y, 4) - div(y, 100) + div(y, 400) - 32045;
  }
  function jdToJalali(jd) {
    jd = jd - 226895;
    var cy = div(33 * jd + 3, 12053);
    jd -= 12053 * cy;
    var y = 979 + 33 * cy + 4 * div(jd, 1461);
    jd %= 1461;
    if (jd > 365) { y += div(jd - 1, 365); jd = (jd - 1) % 365; }
    var m = jd < 186 ? div(jd, 31) + 1 : div(jd - 186, 30) + 7;
    var d = jd < 186 ? (jd % 31) + 1 : ((jd - 186) % 30) + 1;
    return [y, m, d];
  }
  function todayJ() {
    var t = new Date();
    var jd = gregorianToJD(t.getFullYear(), t.getMonth() + 1, t.getDate());
    var j = jdToJalali(jd);
    return `${j[0]}/${String(j[1]).padStart(2, "0")}/${String(j[2]).padStart(2, "0")}`;
  }

  // ---- مقداردهی تاریخ ----
  function ensureDate() {
    const sh = document.getElementById("purchase_date_sh");
    const g = document.getElementById("purchase_date");
    if (!sh || !g) return;
    if (!sh.value) sh.value = todayJ();
    const val = fa2en(sh.value);
    g.value = val;
    sh.addEventListener("input", () => { g.value = fa2en(sh.value); });
  }

  // ---- جمع خودکار اقلام ----
  function sumBy(sel) {
    return Array.from(document.querySelectorAll(sel))
      .reduce((s, el) => s + (parseInt(el.value || 0, 10) || 0), 0);
  }
  function recalc() {
    document.getElementById("sumPrice").textContent = sumBy("input[name$='[price]']");
    document.getElementById("sumDeposit").textContent = sumBy("input[name$='[deposit]']");
    document.getElementById("sumCOD").textContent = sumBy("input[name$='[cod]']");
    document.getElementById("sumRemaining").textContent = sumBy("input[name$='[remaining]']");
  }

  // ---- مدیریت اقلام ----
  function attach(row) {
    const p = row.querySelector("[name*='[price]']");
    const d = row.querySelector("[name*='[deposit]']");
    const c = row.querySelector("[name*='[cod]']");
    const r = row.querySelector("[name*='[remaining]']");
    const rm = row.querySelector(".removeItemBtn");
    const rec = () => {
      const pv = +p.value || 0, dv = +d.value || 0, cv = +c.value || 0;
      r.value = Math.max(pv - dv - cv, 0);
      recalc();
    };
    [p, d, c].forEach(x => x.addEventListener("input", rec));
    rm.addEventListener("click", () => { row.remove(); recalc(); });
  }
  function addItem() {
    const tpl = document.getElementById("itemTpl");
    const wrap = document.getElementById("itemsWrap");
    if (!tpl || !wrap) return;
    const node = tpl.content.cloneNode(true);
    wrap.appendChild(node);
    attach(wrap.lastElementChild);
    recalc();
  }

  // ---- اجرا ----
  window.addEventListener("DOMContentLoaded", () => {
    ensureDate();
    const add = document.getElementById("addItemBtn");
    if (add) add.addEventListener("click", addItem);
    addItem();
  });

})();
