<?php
ini_set('display_errors',1);
error_reporting(E_ALL);

require __DIR__.'/includes/auth.php';
require __DIR__.'/includes/config.php';
require __DIR__.'/includes/db_connect.php';
require __DIR__.'/includes/header.php';

/* ===========================
   Helper
=========================== */
function safeNum($v){
    return ($v === null || $v === '' ? 0 : $v);
}

$username = $_SESSION['username'] ?? '';
$role     = $_SESSION['role'] ?? 'seller';

/* ===========================
   WHERE Condition
=========================== */
$where = ($role === 'admin')
    ? '1'
    : " (username='".$mysqli->real_escape_string($username)."' 
         OR seller_name='".$mysqli->real_escape_string($username)."') ";

/* ===========================
   Dashboard Cards
=========================== */

$q1 = $mysqli->query("SELECT COUNT(*) FROM orders WHERE $where AND MONTH(created_at)=MONTH(CURDATE()) AND YEAR(created_at)=YEAR(CURDATE())");
$month_orders = safeNum($q1->fetch_row()[0] ?? 0);

$q2 = $mysqli->query("SELECT COUNT(*) FROM orders WHERE $where AND DATE(created_at)=CURDATE()");
$today_orders = safeNum($q2->fetch_row()[0] ?? 0);

$q3 = $mysqli->query("SELECT SUM(total_amount) FROM orders WHERE $where");
$total_amount = safeNum($q3->fetch_row()[0] ?? 0);

$q4 = $mysqli->query("SELECT SUM(total_deposit) FROM orders WHERE $where");
$total_deposit = safeNum($q4->fetch_row()[0] ?? 0);

$q5 = $mysqli->query("SELECT SUM(total_cod) FROM orders WHERE $where");
$total_cod = safeNum($q5->fetch_row()[0] ?? 0);

$account_balance = $total_deposit - $total_cod;

/* ===========================
   Recent Orders
=========================== */
$q_recent = $mysqli->query("
    SELECT id, customer_name, total_amount, status, created_at 
    FROM orders 
    WHERE $where 
    ORDER BY id DESC 
    LIMIT 5
");

/* ===========================
   Sales Chart (Real)
=========================== */

$daily_sales = array_fill(1,31,0);

$q_sales = $mysqli->query("
    SELECT DAY(created_at) AS d, SUM(total_amount) AS s
    FROM orders
    WHERE $where
    AND MONTH(created_at)=MONTH(CURDATE())
    AND YEAR(created_at)=YEAR(CURDATE())
    GROUP BY DAY(created_at)
");

if ($q_sales){
    while($row=$q_sales->fetch_assoc()){
        $daily_sales[(int)$row['d']] = safeNum($row['s']);
    }
}

$chart_days = json_encode(range(1,31));
$chart_vals = json_encode(array_values($daily_sales));

?>
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
<meta charset="UTF-8">
<title>داشبورد سفارشات</title>
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<link rel="stylesheet" href="assets/index.css">
</head>
<body>

<div class="dashboard-header">
  <h2>👋 خوش آمدی <?= htmlspecialchars($username) ?></h2>
  <p>نقش: <strong><?= $role=='admin'?'مدیر سیستم':'فروشنده' ?></strong></p>
</div>

<section class="dashboard">
  <div class="card"><h2><?= number_format($month_orders) ?></h2><p>فاکتورهای ماه جاری</p></div>
  <div class="card"><h2><?= number_format($today_orders) ?></h2><p>سفارش‌های امروز</p></div>
  <div class="card"><h2><?= number_format($total_amount) ?> تومان</h2><p>جمع کل مبالغ</p></div>
  <div class="card"><h2><?= number_format($account_balance) ?> تومان</h2><p>مانده حساب</p></div>
</section>

<!-- ===============================
      📈 فروش ماه جاری
================================ -->
<section class="chart-section">
  <h3>📈 فروش ماه جاری</h3>
  <canvas id="salesChart"></canvas>
</section>

<script>
new Chart(document.getElementById('salesChart'), {
    type:"line",
    data:{
        labels: <?= $chart_days ?>,
        datasets:[{
            label:"فروش ماه جاری (تومان)",
            data: <?= $chart_vals ?>,
            borderColor:"#0ea5e9",
            borderWidth:2,
            tension:.35
        }]
    },
    options:{
        responsive:true,
        scales:{y:{beginAtZero:true}}
    }
});
</script>

<!-- =================================================================
      📊 مقایسه دو فروشنده — فقط مدیر
================================================================= -->
<?php if ($role === 'admin'): ?>

<?php
// ================================
// لیست فروشنده‌ها از جدول users
// ================================
$q_sellers = $mysqli->query("
    SELECT username 
    FROM users 
    WHERE role='seller'
    ORDER BY username ASC
");

$sellers = [];
while($r=$q_sellers->fetch_assoc()){
    $name = trim(mb_strtolower($r['username']));
    if ($name !== '') $sellers[] = $name;
}
?>

<section class="chart-section" id="compare">
  <h3>📊 مقایسه دو فروشنده (فقط مدیر)</h3>

  <form method="GET" style="margin-bottom:20px; display:flex; gap:15px;">
    <select name="s1" required>
      <option value="">فروشنده اول…</option>
      <?php foreach ($sellers as $s): ?>
        <option value="<?= $s ?>" <?= (($_GET['s1'] ?? '')==$s)?'selected':'' ?>><?= $s ?></option>
      <?php endforeach; ?>
    </select>

    <select name="s2" required>
      <option value="">فروشنده دوم…</option>
      <?php foreach ($sellers as $s): ?>
        <option value="<?= $s ?>" <?= (($_GET['s2'] ?? '')==$s)?'selected':'' ?>><?= $s ?></option>
      <?php endforeach; ?>
    </select>

    <button class="btn">مقایسه</button>
  </form>
</section>

<?php
if (isset($_GET['s1'], $_GET['s2']) && $_GET['s1'] && $_GET['s2']):

$s1 = $mysqli->real_escape_string($_GET['s1']);
$s2 = $mysqli->real_escape_string($_GET['s2']);

function sellerStats($seller, $mysqli){
    $q=$mysqli->query("
        SELECT 
           COUNT(*) AS orders,
           SUM(total_amount) AS amount,
           SUM(total_deposit) AS deposit,
           SUM(total_cod) AS cod
        FROM orders
        WHERE 
            LOWER(seller_name)='$seller'
            OR LOWER(username)='$seller'
    ");
    $r=$q->fetch_assoc();

    return [
        "orders"  => safeNum($r['orders']),
        "amount"  => safeNum($r['amount']),
        "deposit" => safeNum($r['deposit']),
        "cod"     => safeNum($r['cod'])
    ];
}

$a = sellerStats($s1,$mysqli);
$b = sellerStats($s2,$mysqli);

$cmp_labels = json_encode(["تعداد فاکتور","جمع مبلغ","بیعانه","COD"],JSON_UNESCAPED_UNICODE);
$cmp_s1 = json_encode([$a["orders"],$a["amount"],$a["deposit"],$a["cod"]]);
$cmp_s2 = json_encode([$b["orders"],$b["amount"],$b["deposit"],$b["cod"]]);
?>

<section class="chart-section">
  <h3>📊 نتیجه مقایسه: <?= $s1 ?> ↔ <?= $s2 ?></h3>
  <canvas id="sellerCompare"></canvas>
</section>

<script>
new Chart(document.getElementById('sellerCompare'), {
    type: "bar",
    data: {
        labels: <?= $cmp_labels ?>,
        datasets: [
            {
                label: "<?= $s1 ?>",
                data: <?= $cmp_s1 ?>,
                backgroundColor:"rgba(0, 102, 255, .6)"
            },
            {
                label: "<?= $s2 ?>",
                data: <?= $cmp_s2 ?>,
                backgroundColor:"rgba(255, 51, 102, .6)"
            }
        ]
    },
    options:{scales:{y:{beginAtZero:true}}}
});
</script>

<?php endif; ?>
<?php endif; ?>

<!-- ===============================
     🔻 منوی پایین + رول
=============================== -->
<div class="nav-menu" id="navMenu">
    <a href="index.php">🏠 خانه</a>
    <a href="new.php">🛒 فاکتور جدید</a>
    <a href="orders.php">🛍️ فاکتورها</a>
    <a href="product/">📦 محصولات</a>
    <a href="payment/withdraw.php">💸 برداشت</a>
    <a href="dashboard.php">💰 داشبورد مالی</a>

    <?php if ($role === 'admin'): ?>
      <a href="reports.php">📊 گزارش ماهانه</a>
      <a href="payment/withdraw_list.php">🧾 گزارش برداشت</a>
      <a href="#compare">⚖️ مقایسه فروشنده‌ها</a>
    <?php endif; ?>

    <a class="danger" href="logout.php">🚪 خروج</a>
</div>

</body>
</html>
