<?php
error_reporting(0);
require __DIR__.'/includes/jdf.php';
require __DIR__.'/includes/auth.php';
require __DIR__.'/includes/db_connect.php';
require __DIR__.'/includes/config.php';

$id = trim($_GET['id'] ?? '');
if ($id === '') exit('bad id');

// واکشی سفارش
if (ctype_digit($id)) {
    $o = $mysqli->query("SELECT * FROM orders WHERE id=".(int)$id)->fetch_assoc();
    $items = $mysqli->query("SELECT * FROM order_items WHERE order_id=".(int)$id);
} elseif (preg_match('/^[A-Z0-9]{4,6}$/i', $id)) {
    $st = $mysqli->prepare("SELECT * FROM orders WHERE order_uid=? LIMIT 1");
    $st->bind_param('s', $id);
    $st->execute();
    $o = $st->get_result()->fetch_assoc();
    $st->close();
    if ($o) {
        $oid = (int)$o['id'];
        $items = $mysqli->query("SELECT * FROM order_items WHERE order_id=$oid");
    }
} else exit('bad id');

if (!$o) exit('not found');

// ===============================
// توابع کمکی
// ===============================
function nf($n){ return number_format((int)$n,0,'.',','); }
function toJalaliEn($date){
  if(!$date || !preg_match('/^\d{4}-\d{2}-\d{2}/',$date)) return '-';
  list($gy,$gm,$gd)=explode('-',$date);
  $j=gregorian_to_jalali((int)$gy,(int)$gm,(int)$gd,'/');
  return strtr($j,['۰'=>'0','۱'=>'1','۲'=>'2','۳'=>'3','۴'=>'4','۵'=>'5','۶'=>'6','۷'=>'7','۸'=>'8','۹'=>'9']);
}
function numberToWordsFa($num){
  $num = (int)$num;
  if($num == 0) return 'صفر';
  $ones = ['', 'یک','دو','سه','چهار','پنج','شش','هفت','هشت','نه','ده','یازده','دوازده','سیزده','چهارده','پانزده','شانزده','هفده','هجده','نوزده'];
  $tens = ['', '', 'بیست','سی','چهل','پنجاه','شصت','هفتاد','هشتاد','نود'];
  $hundreds = ['', 'صد','دویست','سیصد','چهارصد','پانصد','ششصد','هفتصد','هشتصد','نهصد'];
  $parts = ['', 'هزار','میلیون','میلیارد'];
  $str = ''; $i=0;
  while($num>0){
    $chunk=$num%1000;
    if($chunk){
      $t='';
      $h=intdiv($chunk,100); $chunk%=100;
      if($h) $t.=$hundreds[$h];
      if($chunk){
        if($h) $t.=' و ';
        if($chunk<20) $t.=$ones[$chunk];
        else{
          $t.=$tens[intdiv($chunk,10)];
          if($chunk%10) $t.=' و '.$ones[$chunk%10];
        }
      }
      $str = trim($t.' '.$parts[$i].($str ? ' و '.$str : ''));
    }
    $num=intdiv($num,1000); $i++;
  }
  return $str;
}

// ===============================
// PDF
// ===============================
require_once __DIR__.'/lib/tcpdf/tcpdf.php';

// کلاس برای واترمارک زیر محتوا
class SALAMBABA_PDF extends TCPDF {
    public $logo;
    public function Header() {
        // واترمارک فقط صفحه اول
        if($this->page == 1 && file_exists($this->logo)){
            $this->SetAlpha(0.2);
            $this->Image($this->logo, 45, 25, 130, 0, '', '', '', false, 300, '', false, false, 0, true);
            $this->SetAlpha(1);
        }
    }
}

$pdf = new SALAMBABA_PDF('L','mm','A5',true,'UTF-8',false);
$pdf->SetCreator('Salambaba');
$pdf->SetAuthor('Salambaba');
$pdf->SetTitle('فاکتور فروش سلامـ بابا - '.$o['invoice_no']);
$pdf->SetMargins(8,8,8,true);
$pdf->AddPage();
$pdf->setRTL(true);
$pdf->SetFontSubsetting(true);
$pdf->logo = __DIR__.'/assets/logo-salambaba.png';

// فونت فارسی
$fontname = 'freeserif';
$fontPath = __DIR__.'/assets/IRANSansWeb.ttf';
if (file_exists($fontPath)) {
    $fontname = TCPDF_FONTS::addTTFfont($fontPath, 'TrueTypeUnicode', '', 32);
    $pdf->SetFont($fontname, '', 10, '', true);
} else {
    $pdf->SetFont('freeserif', '', 11, '', true);
}

// داده‌ها
$stamp = __DIR__.'/assets/stamp-salambaba.png';
$customer_name   = htmlspecialchars($o['customer_name'] ?? '');
$seller_name     = htmlspecialchars($o['seller_name'] ?? '');
$customer_phone  = htmlspecialchars($o['customer_phone'] ?? '');
$warranty_raw = trim(strtolower($o['warranty'] ?? ''));
$warranty = ($warranty_raw === '' || $warranty_raw === 'none') ? 'بدون گارانتی' : htmlspecialchars($o['warranty']);
$address         = htmlspecialchars($o['address'] ?? '');
$total_amount    = (int)($o['total_amount'] ?? 0);
$amount_words    = numberToWordsFa($total_amount).' تومان';

// ===============================
// HTML
// ===============================
$html = '
<style>
  body, td, th { font-size:10pt; line-height:1.5; color:#111; }
  table { border-collapse:collapse; width:100%; }
  th, td { border:0.2mm solid #aaa; padding:4px 6px; }
  th { background-color:#e5e7eb; font-weight:bold; text-align:center; }
  .section-title {
    background-color:#d1d5db;
    text-align:center;
    font-weight:bold;
    font-size:11pt;
    padding:4px;
    border:0.2mm solid #aaa;
    margin:5px 0 3px 0;
  }
</style>

<div style="direction:rtl; font-family:'.$fontname.';">

  <!-- هدر -->
  <table border="0" cellpadding="2" style="margin-bottom:2px;">
    <tr>
      <td width="25%" align="right" style="font-size:10pt;"><b>شماره :</b> '.$o['invoice_no'].'</td>
      <td width="50%" align="center" style="font-size:14pt;font-weight:bold;">فاکتور فروش سلامـ بابا</td>
      <td width="25%" align="left" style="font-size:10pt;"><b>تاریخ:</b> '.toJalaliEn($o['purchase_date']).'</td>
    </tr>
  </table>

  <!-- مشخصات خریدار -->
  <div class="section-title">مشخصات خریدار</div>
  <table>
    <tr>
      <td width="25%"><b>نام مشتری:</b></td><td width="35%">'.$customer_name.'</td>
      <td width="15%"><b>شماره تماس:</b></td><td width="25%">'.$customer_phone.'</td>
    </tr>
    <tr>
      <td><b>فروشنده:</b></td><td>'.$seller_name.'</td>
      <td><b>گارانتی:</b></td><td>'.$warranty.'</td>
    </tr>
    <tr>
      <td><b>آدرس:</b></td><td colspan="3">'.$address.'</td>
    </tr>
  </table>

  <!-- اقلام -->
  <div class="section-title">اقلام خریداری‌شده</div>
  <table>
    <thead>
      <tr>
        <th width="6%">ردیف</th>
        <th width="42%">شرح کالا / مدل</th>
        <th width="13%">قیمت واحد</th>
        <th width="13%">بیعانه</th>
        <th width="13%">پرداخت در محل</th>
        <th width="13%">مانده</th>
      </tr>
    </thead>
    <tbody>';
$i=1;
foreach($items as $it){
  $html .= '<tr>
    <td align="center">'.$i++.'</td>
    <td>'.htmlspecialchars($it['model']).'</td>
    <td align="center">'.nf($it['price']).'</td>
    <td align="center">'.nf($it['deposit']).'</td>
    <td align="center">'.nf($it['cod']).'</td>
    <td align="center">'.nf($it['remaining']).'</td>
  </tr>';
}
$html .= '
      <tr>
        <td colspan="5" align="left"><b>جمع کل:</b></td>
        <td align="center"><b>'.nf($o['total_amount']).'</b></td>
      </tr>
    </tbody>
  </table>

  <!-- خلاصه مالی -->
  <div class="section-title">خلاصه مالی فاکتور</div>
  <table width="100%" border="0" cellpadding="6" style="font-size:11pt;border:0.2mm solid #aaa;">
    <tr>
      <td width="33%" align="center"><b>بیعانه</b><br>'.nf($o['total_deposit']).' تومان</td>
      <td width="33%" align="center"><b>پرداخت در محل</b><br>'.nf($o['total_cod']).' تومان</td>
      <td width="33%" align="center"><b>مانده قابل پرداخت</b><br><b>'.nf($o['total_remaining']).' تومان</b></td>
    </tr>
  </table>

  <p style="margin-top:6px;font-size:10.5pt;text-align:center;">
    <b>مبلغ کل فاکتور به حروف:</b> '.$amount_words.'
  </p>

  <!-- امضا -->
  <table width="100%" style="margin-top:10px;" border="0">
    <tr>
      <td width="50%" align="center">امضا خریدار</td>
      <td width="50%" align="center">امضا فروشنده</td>
    </tr>
    <tr>
      <td height="45">&nbsp;</td>
      <td align="center"><img src="'.$stamp.'" height="45"></td>
    </tr>
  </table>

  <hr style="border:none;height:2px;background:linear-gradient(90deg,#2563eb,#16a34a,#f59e0b,#dc2626);border-radius:3px;margin-top:10px;">
</div>';

@ob_end_clean();
$pdf->writeHTML($html,true,false,true,false,'');

if(isset($_GET['download'])){
  $pdf->Output('invoice-'.$o['invoice_no'].'.pdf','D');
} else {
  $pdf->Output('invoice-'.$o['invoice_no'].'.pdf','I');
}
exit;
?>
