<?php
require __DIR__ . '/../includes/auth.php';
require __DIR__ . '/../includes/config.php';
require __DIR__ . '/../includes/db_connect.php';
require __DIR__ . '/../includes/header.php';

// نقش و نام کاربر لاگین شده
$role = $_SESSION['role'] ?? '';
$login_user = $_SESSION['username'] ?? '';

// دریافت پارامترهای فیلتر
$search      = trim($_GET['search'] ?? '');
$userFilter  = trim($_GET['username'] ?? '');
$year        = intval($_GET['year'] ?? 0);
$month       = intval($_GET['month'] ?? 0);
$day         = intval($_GET['day'] ?? 0);
$balanceView = trim($_GET['balance'] ?? '');

// ----------------------------------
// ساخت WHERE اصلی
// ----------------------------------
$where = "1";

// اگر فروشنده است → فقط داده‌های خودش
if ($role === 'seller') {
    $usernameEsc = $mysqli->real_escape_string($login_user);
    $where .= " AND w.username = '$usernameEsc'";
} else {
    // مدیر می‌تواند فیلتر فروشنده استفاده کند
    if ($userFilter !== '') {
        $userFilterEsc = $mysqli->real_escape_string($userFilter);
        $where .= " AND w.username = '$userFilterEsc'";
    }
}

// فیلتر تاریخ
if ($year > 0)  $where .= " AND YEAR(w.created_at)=$year";
if ($month > 0) $where .= " AND MONTH(w.created_at)=$month";
if ($day > 0)   $where .= " AND DAY(w.created_at)=$day";

// جستجو
if ($search !== '') {
    $s = $mysqli->real_escape_string($search);
    $where .= " AND (
        w.username LIKE '%$s%' OR
        w.amount LIKE '%$s%' OR
        w.method LIKE '%$s%' OR
        w.note LIKE '%$s%'
    )";
}

// ----------------------------------
// کوئری اصلی داده‌ها
// ----------------------------------
$sql = "
    SELECT 
        w.*,
        (SELECT balance FROM seller_balance WHERE username=w.username LIMIT 1) AS balance
    FROM withdrawals w
    WHERE $where
    ORDER BY w.id DESC
";

$q = $mysqli->query($sql);

// ----------------------------------
// مجموع برداشت‌های فروشنده‌ها
// ----------------------------------
$sumSql = "
    SELECT username, SUM(amount) AS total 
    FROM withdrawals
    WHERE ".str_replace("w.", "", $where)."
    GROUP BY username
";
$sumQ = $mysqli->query($sumSql);

// ----------------------------------
// نمودار ماهانه
// ----------------------------------
$chartYear = $year > 0 ? $year : date("Y");

$chartSql = "
    SELECT MONTH(created_at) AS m, SUM(amount) AS t
    FROM withdrawals
    WHERE YEAR(created_at)=$chartYear
    GROUP BY MONTH(created_at)
";
$chartQ = $mysqli->query($chartSql);

$chartLabels = [];
$chartData   = [];

while ($c = $chartQ->fetch_assoc()) {
    $chartLabels[] = "ماه " . $c['m'];
    $chartData[]   = (int)$c['t'];
}

// ----------------------------------
// لیست سال‌ها برای فیلتر
// ----------------------------------
$yearsRes = $mysqli->query("SELECT DISTINCT YEAR(created_at) AS y FROM withdrawals ORDER BY y DESC");
$years = [];
while($yr = $yearsRes->fetch_assoc()){
    $years[] = (int)$yr['y'];
}
?>

<!doctype html>
<html lang="fa" dir="rtl">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width,initial-scale=1">
<title>مدیریت برداشت‌ها — سلام‌بابا</title>

<link rel="stylesheet" href="../assets/style.css">
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

<style>
body {
  background:#f3f4f6;
  font-family:IRANSansWeb;
}

.page-header {
  position:sticky;
  top:0;
  background:white;
  padding:15px;
  border-bottom:1px solid #e5e7eb;
  display:flex;
  justify-content:space-between;
  align-items:center;
  z-index:999;
}

.page-header h2 {
  font-size:20px;
  margin:0;
}

.card {
  background:white;
  padding:20px;
  border-radius:12px;
  border:1px solid #e5e7eb;
  max-width:1200px;
  margin:20px auto;
}

.filter-box {
  display:flex;
  flex-wrap:wrap;
  gap:10px;
}

.filter-box input,
.filter-box select {
  padding:8px;
  border-radius:8px;
  border:1px solid #cbd5e1;
}

.filter-box button {
  padding:8px 15px;
  background:#0ea5e9;
  color:white;
  border:none;
  border-radius:8px;
}

table {
  width:100%;
  border-collapse:collapse;
  margin-top:20px;
}

th, td {
  padding:10px;
  border-bottom:1px solid #eee;
  text-align:center;
}

th {
  background:#f1f5f9;
  font-weight:bold;
}

.balance-neg {
  color:#b91c1c;
  background:#fee2e2;
  padding:3px 8px;
  border-radius:6px;
}

.balance-pos {
  color:#166534;
  background:#dcfce7;
  padding:3px 8px;
  border-radius:6px;
}

.view-buttons a {
  padding:6px 10px;
  background:#e2e8f0;
  border-radius:8px;
  text-decoration:none;
  font-size:13px;
  margin-left:5px;
}

.view-buttons a.active {
  background:#0ea5e9;
  color:white;
}

.summary-card {
  margin-top:20px;
  background:#f8fafc;
  border:1px solid #e2e8f0;
  padding:15px;
  border-radius:12px;
}

.summary-card h3 {
  margin:0 0 10px 0;
  font-size:16px;
}
</style>
</head>
<body>

<div class="page-header">
  <h2>لیست برداشت‌ها</h2>

  <div class="view-buttons">
    <?php
      $baseUrl = strtok($_SERVER["REQUEST_URI"],'?');
      $params  = $_GET;
      unset($params['balance']);
      $p = http_build_query($params);
      $base = $baseUrl . ($p?'?'.$p.'&':'?');
    ?>
    <a href="<?=$base?>" class="<?=($balanceView==''?'active':'')?>">همه</a>
    <a href="<?=$base?>balance=positive" class="<?=($balanceView=='positive'?'active':'')?>">بستانکار</a>
    <a href="<?=$base?>balance=negative" class="<?=($balanceView=='negative'?'active':'')?>">بدهکار</a>
  </div>
</div>

<div class="card">

  <!-- فیلترها -->
  <form method="get" class="filter-box">

    <input type="text" name="search" placeholder="جستجو..." value="<?=htmlspecialchars($search)?>">

    <?php if($role === 'admin'): ?>
    <select name="username">
      <option value="">همه فروشنده‌ها</option>
      <?php
      $uq = $mysqli->query("SELECT username FROM users WHERE role='seller'");
      while($u = $uq->fetch_assoc()):
      ?>
      <option value="<?=$u['username']?>" <?=($userFilter==$u['username']?'selected':'')?>>
        <?=$u['username']?>
      </option>
      <?php endwhile; ?>
    </select>
    <?php endif; ?>

    <select name="year">
      <option value="">سال</option>
      <?php foreach($years as $y): ?>
      <option value="<?=$y?>" <?=($year==$y?'selected':'')?>><?=$y?></option>
      <?php endforeach; ?>
    </select>

    <select name="month">
      <option value="">ماه</option>
      <?php for($m=1;$m<=12;$m++): ?>
      <option value="<?=$m?>" <?=($month==$m?'selected':'')?>><?=$m?></option>
      <?php endfor; ?>
    </select>

    <select name="day">
      <option value="">روز</option>
      <?php for($d=1;$d<=31;$d++): ?>
      <option value="<?=$d?>" <?=($day==$d?'selected':'')?>><?=$d?></option>
      <?php endfor; ?>
    </select>

    <button type="submit">اعمال فیلتر</button>

  </form>

  <!-- نمودار -->
  <canvas id="chart" height="90"></canvas>

  <script>
  const chartData = <?=json_encode($chartData)?>;
  const chartLabels = <?=json_encode($chartLabels, JSON_UNESCAPED_UNICODE)?>;
  const ctx = document.getElementById("chart").getContext("2d");

  new Chart(ctx, {
    type: "bar",
    data: {
      labels: chartLabels,
      datasets: [{
        label: "جمع برداشت ماهیانه",
        data: chartData,
        borderWidth: 1
      }]
    },
    options: {
      scales: { y: { beginAtZero:true } }
    }
  });
  </script>

  <!-- مجموع برداشت‌ها -->
  <div class="summary-card">
    <h3>مجموع برداشت‌ها (بر اساس فیلتر)</h3>
    <table>
      <tr>
        <th>فروشنده</th>
        <th>جمع برداشت</th>
      </tr>
      <?php while($s = $sumQ->fetch_assoc()): ?>
      <tr>
        <td><?=$s['username']?></td>
        <td><?=number_format($s['total'])?></td>
      </tr>
      <?php endwhile; ?>
    </table>
  </div>

  <!-- جدول اصلی -->
  <table>

    <tr>
      <th>#</th>
      <th>فروشنده</th>
      <th>مبلغ</th>
      <th>روش</th>
      <th>مانده</th>
      <th>توضیحات</th>
      <th>تاریخ</th>
    </tr>

    <?php
    $i=1;
    while($row = $q->fetch_assoc()):
        $bal = (int)$row['balance'];

        // اعمال فیلتر بدهکار / بستانکار
        if ($balanceView==='negative' && $bal>=0) continue;
        if ($balanceView==='positive' && $bal<=0) continue;
    ?>

    <tr>
      <td><?=$i++?></td>
      <td><?=$row['username']?></td>
      <td><?=number_format($row['amount'])?></td>
      <td><?=$row['method']?></td>

      <td>
        <?php if($bal < 0): ?>
          <span class="balance-neg"><?=number_format($bal)?></span>
        <?php else: ?>
          <span class="balance-pos"><?=number_format($bal)?></span>
        <?php endif; ?>
      </td>

      <td><?=$row['note']?></td>
      <td><?=$row['created_at']?></td>
    </tr>

    <?php endwhile; ?>

  </table>

</div>

</body>
</html>
