<?php
require __DIR__ . '/includes/auth.php';
require __DIR__ . '/includes/config.php';
require __DIR__ . '/includes/db_connect.php';
require __DIR__ . '/includes/jalali.php';
require __DIR__ . '/includes/helpers.php';
require __DIR__ . '/includes/telegram.php';

// تبدیل رشته به عدد صحیح
function toInt($s){
    return (int)preg_replace('/[^\d]/','', (string)$s);
}

function normalize_items($items){
    if (isset($items[0]) && is_array($items[0])) {
        $out = [];
        foreach ($items as $it) {
            $out[] = [
                'model'         => trim($it['model'] ?? ''),
                'price'         => toInt($it['price'] ?? 0),
                'deposit'       => toInt($it['deposit'] ?? 0),
                'cod'           => toInt($it['cod'] ?? 0),
                'remaining'     => toInt($it['remaining'] ?? 0),
                'qty'           => max(1, toInt($it['qty'] ?? 1)),
                'warranty_type' => trim($it['warranty_type'] ?? 'none'),
                'notes'         => trim($it['notes'] ?? ''),
                'brand'         => trim($it['brand'] ?? ''),
                'category'      => trim($it['category'] ?? ''),
            ];
        }
        return $out;
    }

    if (isset($items['model'])) {
        $count = max(
            count($items['model'] ?? []),
            count($items['price'] ?? []),
            count($items['deposit'] ?? []),
            count($items['cod'] ?? []),
            count($items['remaining'] ?? []),
            count($items['qty'] ?? []),
            count($items['warranty_type'] ?? []),
            count($items['notes'] ?? [])
        );
        $out = [];
        for ($i = 0; $i < $count; $i++) {
            $out[] = [
                'model'         => trim($items['model'][$i] ?? ''),
                'price'         => toInt($items['price'][$i] ?? 0),
                'deposit'       => toInt($items['deposit'][$i] ?? 0),
                'cod'           => toInt($items['cod'][$i] ?? 0),
                'remaining'     => toInt($items['remaining'][$i] ?? 0),
                'qty'           => max(1, toInt($items['qty'][$i] ?? 1)),
                'warranty_type' => trim($items['warranty_type'][$i] ?? 'none'),
                'notes'         => trim($items['notes'][$i] ?? ''),
                'brand'         => trim($items['brand'][$i] ?? ''),
                'category'      => trim($items['category'][$i] ?? ''),
            ];
        }
        return $out;
    }

    return [];
}

/* =======================
   دریافت داده‌های فرم
======================= */

$customer_name = trim($_POST['customer_name'] ?? '');
$seller_name   = trim($_POST['seller_name'] ?? '');

if ($seller_name === '') {
    $seller_name = trim($_SESSION['full_name'] ?? $_SESSION['username'] ?? '');
}

$mobile1  = trim($_POST['mobile1'] ?? '');
$mobile2  = trim($_POST['mobile2'] ?? '');
$phone    = trim($_POST['phone'] ?? '');
$province = trim($_POST['province'] ?? '');
$address  = trim($_POST['address'] ?? '');
$location_url = trim($_POST['location_url'] ?? '');

$notes   = trim($_POST['notes'] ?? '');
$targets = $_POST['target'] ?? [];

$withdraw_amount = toInt($_POST['withdraw_amount'] ?? 0);
$withdraw_note   = trim($_POST['withdraw_note'] ?? '');

$purchase_date_raw = fa2en($_POST['purchase_date'] ?? '');
$purchase_date_sh  = fa2en($_POST['purchase_date_sh'] ?? '');

$items_raw = $_POST['items'] ?? [];
$items     = normalize_items($items_raw);

$items = array_values(array_filter($items, function($it){
    $model = trim($it['model'] ?? '');
    $price = (int)($it['price'] ?? 0);
    $qty   = (int)($it['qty'] ?? 0);
    return $model !== '' || ($price > 0 && $qty > 0);
}));

/* =======================
   تبدیل تاریخ
======================= */
if (preg_match('/^\d{4}-\d{2}-\d{2}$/', $purchase_date_raw)) {
    $purchase_date = $purchase_date_raw;
} elseif ($purchase_date_sh && ($g = jdate_to_gdate_ymd($purchase_date_sh))) {
    $purchase_date = $g;
} else {
    $purchase_date = date('Y-m-d');
}

/* =======================
   اعتبارسنجی
======================= */
if ($customer_name === '' || empty($items)) {
    http_response_code(400);
    exit('❌ پارامترها ناقص است.');
}

/* =======================
   محاسبه مبالغ
======================= */
$sum_p = $sum_d = $sum_c = $sum_r = 0;

foreach ($items as &$it) {
    $unit   = (int)$it['price'];
    $qty    = max(1, (int)$it['qty']);
    $total  = $unit * $qty;
    $dep    = (int)$it['deposit'];
    $cod    = (int)$it['cod'];
    $remain = $total - $dep - $cod;

    $it['price']     = $total;
    $it['remaining'] = $remain;

    $sum_p += $total;
    $sum_d += $dep;
    $sum_c += $cod;
    $sum_r += $remain;
}
unset($it);

$order_warranty = 'none';

/* مهم‌ترین اصلاح: شماره‌ها دیگر وارد notes نمی‌شوند */
$merged_notes = $notes;

/* =======================
   تراکنش
======================= */
$mysqli->begin_transaction();

try {

$st = $mysqli->prepare("
    INSERT INTO orders (
        invoice_no, tracking_code, status, status_note,
        username, customer_name, address, seller_name, warranty,
        purchase_date, total_amount, total_deposit, total_cod,
        total_remaining, notes, location_url,
        mobile1, mobile2, phone, province,
        created_at
    ) VALUES (
        NULL, NULL, 'pending', NULL,
        ?, ?, ?, ?, ?,
        ?, ?, ?, ?,
        ?, ?, ?,
        ?, ?, ?, ?,
        NOW()
    )
");

$st->bind_param(
    "ssssssiiiissssss",
    $_SESSION['username'],
    $customer_name,
    $address,
    $seller_name,
    $order_warranty,
    $purchase_date,
    $sum_p,
    $sum_d,
    $sum_c,
    $sum_r,
    $merged_notes,
    $location_url,
    $mobile1,
    $mobile2,
    $phone,
    $province
);

$st->execute();
$oid = $st->insert_id;
$st->close();

/* UID */
function gen_uid($len = 5){
    $alphabet = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789';
    $s = '';
    for($i=0; $i<$len; $i++){
        $s .= $alphabet[random_int(0, strlen($alphabet)-1)];
    }
    return $s;
}

$uid = null;
do {
    $candidate = gen_uid(5);
    $chk = $mysqli->prepare("SELECT 1 FROM orders WHERE order_uid=? LIMIT 1");
    $chk->bind_param('s', $candidate);
    $chk->execute();
    $exists = $chk->get_result()->num_rows > 0;
    $chk->close();
    if (!$exists) $uid = $candidate;
} while(!$uid);

$up = $mysqli->prepare("UPDATE orders SET order_uid=? WHERE id=?");
$up->bind_param('si', $uid, $oid);
$up->execute();
$up->close();

/* ITEMS */
$sti = $mysqli->prepare("
    INSERT INTO order_items
    (order_id, model, qty, price, deposit, cod, remaining, warranty_type, notes)
    VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)
");

foreach ($items as $it) {
    $sti->bind_param(
        "isiiiiiss",
        $oid,
        $it['model'],
        $it['qty'],
        $it['price'],
        $it['deposit'],
        $it['cod'],
        $it['remaining'],
        $it['warranty_type'],
        $it['notes']
    );
    $sti->execute();
}
$sti->close();

/* برداشت */
if ($withdraw_amount > 0) {
    $stw = $mysqli->prepare("
        INSERT INTO withdrawals (order_id, amount, note)
        VALUES (?, ?, ?)
    ");
    $stw->bind_param('iis', $oid, $withdraw_amount, $withdraw_note);
    $stw->execute();
    $stw->close();
}

/* شماره فاکتور */
$digits  = str_pad((string)random_int(0, 99999), 5, '0', STR_PAD_LEFT);
$letters = chr(random_int(65,90)) . chr(random_int(65,90));
$invoice_no = "SB-{$digits}-{$letters}";
$tracking   = $invoice_no;

$up2 = $mysqli->prepare("UPDATE orders SET invoice_no=?, tracking_code=? WHERE id=?");
$up2->bind_param('ssi', $invoice_no, $tracking, $oid);
$up2->execute();
$up2->close();

$mysqli->commit();

} catch (Throwable $e) {
    $mysqli->rollback();
    http_response_code(500);
    exit('❌ DB INSERT ERROR: ' . $e->getMessage());
}

/* پیام تلگرام */
$track_url = BASE_URL . 'track.php?code=' . urlencode($tracking);

$wmap = [
    'none'            => 'بدون گارانتی',
    'tv_silver'       => 'نقره‌ای تلویزیون',
    'tv_gold'         => 'طلایی تلویزیون',
    'home_appliance'  => 'لوازم خانگی',
    'small_appliance' => 'لوازم ریز'
];

$txt  = "🧾 <b>فاکتور جدید</b>\n#{$invoice_no}\n";
$txt .= "👤 مشتری: <b>{$customer_name}</b>\n";
if ($mobile1)  $txt .= "📱 همراه ۱: {$mobile1}\n";
if ($mobile2)  $txt .= "📱 همراه ۲: {$mobile2}\n";
if ($phone)    $txt .= "☎ تلفن ثابت: {$phone}\n";
if ($province) $txt .= "📍 استان: {$province}\n";
$txt .= "👨‍💼 فروشنده: {$seller_name}\n";
$txt .= "📅 تاریخ: {$purchase_date}\n";
$txt .= "📍 آدرس: {$address}\n\n";

$txt .= "<b>اقلام خرید:</b>\n";

$i = 1;
foreach ($items as $it) {
    $qty    = (int)$it['qty'];
    $total  = (int)$it['price'];
    $unit   = $qty > 0 ? floor($total / $qty) : $total;

    $txt .= "{$i}) <b>{$it['model']}</b>\n";
    $txt .= "🔢 تعداد: {$qty}\n";
    $txt .= "💵 قیمت واحد: " . nf($unit) . "\n";
    $txt .= "💰 قیمت کل: "   . nf($total) . "\n";
    $txt .= "💳 بیعانه: "     . nf($it['deposit']) . "\n";
    $txt .= "💳 COD: "        . nf($it['cod']) . "\n";
    $txt .= "🧮 مانده: "      . nf($it['remaining']) . "\n";
    $txt .= "🛡 گارانتی: "    . ($wmap[$it['warranty_type']] ?? '—') . "\n";
    if (!empty($it['notes'])) {
        $txt .= "📝 {$it['notes']}\n";
    }
    $txt .= "────────────\n";
    $i++;
}

$txt .= "<b>جمع کل:</b> " . nf($sum_p) . "\n";
$txt .= "<b>بیعانه:</b> " . nf($sum_d) . "\n";
$txt .= "<b>COD:</b> "    . nf($sum_c) . "\n";
$txt .= "<b>مانده:</b> "  . nf($sum_r) . "\n";
$txt .= "\n🔗 پیگیری سفارش:\n{$track_url}\n";

if ($withdraw_amount > 0) {
    $txt .= "\n💸 برداشت: " . nf($withdraw_amount);
    if ($withdraw_note) $txt .= " — {$withdraw_note}";
}
if ($notes) {
    $txt .= "\n📝 توضیحات مشتری:\n{$notes}";
}

foreach ($targets as $t) {
    global $CHAT_MAP, $BOT_TOKEN;
    if (!isset($CHAT_MAP[$t])) continue;
    tg_send_message($BOT_TOKEN, $CHAT_MAP[$t], $txt);
}

header("Location: invoice.php?id={$uid}");
exit;
