<?php
require __DIR__ . '/../includes/auth.php';
require __DIR__ . '/../includes/config.php';
require __DIR__ . '/../includes/db_connect.php';

header("Content-Type: text/plain; charset=utf-8");

// فقط POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    exit('method_not_allowed');
}

// سشن
$role       = $_SESSION['role'] ?? '';
$login_user = $_SESSION['username'] ?? '';

if (!$login_user) {
    exit('no_session');
}

// ورودی‌ها
$username = trim($_POST['username'] ?? '');
$amountRaw = $_POST['amount'] ?? '';
$method   = trim($_POST['method'] ?? 'bank');
$note     = trim($_POST['note'] ?? '');

// نرمال‌سازی مبلغ (حذف کاما و کاراکتر غیرعددی)
$amount = (int)preg_replace('/[^\d]/', '', (string)$amountRaw);

// کنترل پایه
if ($username === '' || $amount <= 0) {
    exit('invalid_input');
}

// محدودیت دسترسی: فروشنده فقط خودش، ادمین هرکسی
if ($role !== 'admin' && $username !== $login_user) {
    exit('forbidden');
}

// روش برداشت امن
$allowed_methods = ['bank', 'cash', 'wallet'];
if (!in_array($method, $allowed_methods, true)) {
    $method = 'bank';
}

// چک وجود فروشنده
$stmt = $mysqli->prepare("
    SELECT id 
    FROM users 
    WHERE username = ? AND role = 'seller'
    LIMIT 1
");
$stmt->bind_param('s', $username);
$stmt->execute();
$res = $stmt->get_result();
$userRow = $res->fetch_assoc();
$stmt->close();

if (!$userRow) {
    exit('seller_not_found');
}

// محاسبه مجموع بیعانه‌ها (total_deposit) از orders
$stmt = $mysqli->prepare("
    SELECT COALESCE(SUM(total_deposit), 0) AS total_deposit
    FROM orders
    WHERE username = ?
");
$stmt->bind_param('s', $username);
$stmt->execute();
$res = $stmt->get_result();
$row = $res->fetch_assoc();
$stmt->close();

$total_deposit = (int)($row['total_deposit'] ?? 0);

// محاسبه مجموع برداشت‌ها از withdrawals
$stmt = $mysqli->prepare("
    SELECT COALESCE(SUM(amount), 0) AS total_withdraw
    FROM withdrawals
    WHERE username = ?
");
$stmt->bind_param('s', $username);
$stmt->execute();
$res = $stmt->get_result();
$row = $res->fetch_assoc();
$stmt->close();

$total_withdraw = (int)($row['total_withdraw'] ?? 0);

// مانده فعلی
$current_balance = $total_deposit - $total_withdraw;

// چک موجودی کافی
if ($amount > $current_balance) {
    exit('balance_not_enough');
}

// ثبت برداشت جدید
$stmt = $mysqli->prepare("
    INSERT INTO withdrawals (username, order_id, amount, method, note, created_at)
    VALUES (?, NULL, ?, ?, ?, NOW())
");
$stmt->bind_param('siss', $username, $amount, $method, $note);

if (!$stmt->execute()) {
    $stmt->close();
    exit('db_error');
}

$stmt->close();

exit('OK');
