<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

require __DIR__.'/includes/auth.php';
require __DIR__.'/includes/config.php';
require __DIR__.'/includes/db_connect.php';

header('Content-Type: application/json; charset=utf-8');

// ==========================
// دریافت و اعتبارسنجی ID
// ==========================
$id = (int)($_POST['id'] ?? 0);
if ($id <= 0) {
    echo json_encode(['ok'=>false, 'error'=>'شناسه سفارش نامعتبر است']);
    exit;
}

// ==========================
// ورودی‌های اصلی
// ==========================
$customer_name = trim($_POST['customer_name'] ?? '');
$seller_name   = trim($_POST['seller_name'] ?? '');
$address       = trim($_POST['address'] ?? '');
$notes         = trim($_POST['notes'] ?? '');

$mobile1       = trim($_POST['mobile1'] ?? '');
$mobile2       = trim($_POST['mobile2'] ?? '');
$phone         = trim($_POST['phone'] ?? '');

$province      = trim($_POST['province'] ?? '');
$location_url  = trim($_POST['location_url'] ?? '');

$purchase_date = trim($_POST['purchase_date'] ?? '');

$total_amount    = (int)($_POST['total_amount'] ?? 0);
$total_deposit   = (int)($_POST['total_deposit'] ?? 0);
$total_cod       = (int)($_POST['total_cod'] ?? 0);
$total_remaining = (int)($_POST['total_remaining'] ?? 0);

// امنیت: مانده کل نباید منفی باشد
if ($total_remaining < 0) {
    echo json_encode(['ok'=>false, 'error'=>'مانده کل نمی‌تواند منفی باشد.']);
    exit;
}

// ==========================
// آپدیت اطلاعات جدول orders
// ==========================
$q = "
    UPDATE orders SET
        customer_name=?,
        seller_name=?,
        address=?,
        notes=?,
        mobile1=?,
        mobile2=?,
        phone=?,
        province=?,
        location_url=?,
        purchase_date=?,
        total_amount=?,
        total_deposit=?,
        total_cod=?,
        total_remaining=?
    WHERE id=?
";

$stmt = $mysqli->prepare($q);

if (!$stmt) {
    echo json_encode(['ok'=>false, 'error'=>'Database Prepare Error: '.$mysqli->error]);
    exit;
}

// 10 × string + 5 × integer = دقیقاً 15 پارامتر
$stmt->bind_param(
    "ssssssssssiiiii",
    $customer_name,
    $seller_name,
    $address,
    $notes,
    $mobile1,
    $mobile2,
    $phone,
    $province,
    $location_url,
    $purchase_date,
    $total_amount,
    $total_deposit,
    $total_cod,
    $total_remaining,
    $id
);

if (!$stmt->execute()) {
    echo json_encode(['ok'=>false, 'error'=>'خطا در بروزرسانی سفارش: '.$stmt->error]);
    exit;
}
$stmt->close();

// ==========================
// مدیریت اقلام فاکتور
// ==========================
$items = $_POST['items'] ?? [];

if (!is_array($items)) {
    echo json_encode(['ok'=>false, 'error'=>'ساختار اقلام نامعتبر است.']);
    exit;
}

// حذف اقلام قبلی
$mysqli->query("DELETE FROM order_items WHERE order_id={$id}");

// درج اقلام جدید
$ins = $mysqli->prepare("
    INSERT INTO order_items
        (order_id, model, qty, price, deposit, cod, remaining, warranty_type, notes)
    VALUES
        (?, ?, ?, ?, ?, ?, ?, ?, ?)
");

if (!$ins) {
    echo json_encode(['ok'=>false, 'error'=>'Database Prepare Error: '.$mysqli->error]);
    exit;
}

foreach ($items as $it) {

    $model   = trim($it['model'] ?? '');
    $qty     = (int)($it['qty'] ?? 1);
    $price   = (int)($it['price'] ?? 0);
    $deposit = (int)($it['deposit'] ?? 0);
    $cod     = (int)($it['cod'] ?? 0);
    $remain  = (int)($it['remaining'] ?? 0);
    $wtype   = trim($it['warranty_type'] ?? 'none');
    $inote   = trim($it['notes'] ?? '');

    // ردیف خالی رد شود
    if ($model === '' && $price === 0 && $deposit === 0 && $cod === 0)
        continue;

    // امنیت: مانده منفی
    if ($remain < 0) {
        echo json_encode(['ok'=>false, 'error'=>"مانده منفی در قلم: {$model}"]);
        exit;
    }

    $ins->bind_param(
        "isiiiiiss",
        $id,
        $model,
        $qty,
        $price,
        $deposit,
        $cod,
        $remain,
        $wtype,
        $inote
    );

    if (!$ins->execute()) {
        echo json_encode(['ok'=>false, 'error'=>'خطا در ذخیره قلم: '.$ins->error]);
        exit;
    }
}

$ins->close();

// ==========================
// OK
// ==========================
echo json_encode(['ok'=>true, 'msg'=>'✔ فاکتور با موفقیت بروزرسانی شد']);
exit;
