<?php
require __DIR__ . '/../includes/config.php';
require __DIR__ . '/../includes/db_connect.php';
require __DIR__ . '/../includes/auth.php';
header('Content-Type: application/json; charset=utf-8');

$id = intval($_POST['id'] ?? 0);
$status = trim($_POST['status'] ?? '');
$note = trim($_POST['note'] ?? '');

if(!$id || $status === ''){
    echo json_encode(['ok'=>false,'msg'=>'پارامترها ناقص است']);
    exit;
}

try {
    $st = $mysqli->prepare("UPDATE orders SET status=?, status_note=? WHERE id=?");
    $st->bind_param("ssi", $status, $note, $id);
    $st->execute();

    if($st->affected_rows > 0){
        echo json_encode(['ok'=>true,'msg'=>'وضعیت با موفقیت بروزرسانی شد ✅']);
    } else {
        echo json_encode(['ok'=>false,'msg'=>'هیچ تغییری اعمال نشد ❌']);
    }
    $st->close();
} catch(Throwable $e){
    echo json_encode(['ok'=>false,'msg'=>'DB ERROR: '.$e->getMessage()]);
}
