<?php
// =====================
//  Start Safe Session
// =====================
if (session_status() === PHP_SESSION_NONE) {
    // امنیت بیشتر برای کوکی‌ها
    session_set_cookie_params([
        'lifetime' => 0,
        'path'     => '/',
        'secure'   => false,
        'httponly' => true,
        'samesite' => 'Lax'
    ]);
    session_start();
}

// =====================
//  Check Login Status
// =====================
if (empty($_SESSION['username']) || empty($_SESSION['role'])) {

    // آدرس فعلی کاربر برای بازگشت بعد از لاگین
    $current = urlencode($_SERVER['REQUEST_URI']);

    header("Location: /orders/login.php?redirect=$current");
    exit;
}

// =====================
// Allowed Roles
// =====================
$allowed_roles = ['admin','seller','buyer','head_carrier'];

if (!in_array($_SESSION['role'], $allowed_roles)) {

    // اگر نقش دارد اما اجازه ندارد
    http_response_code(403);
    echo "<h3 style='color:#b91c1c;font-family:IRANSansWeb;text-align:center;margin-top:50px'>
            ❌ دسترسی غیرمجاز
          </h3>";
    exit;
}

// ===== AUTH COMPLETED =====
?>