<?php
error_reporting(0);
require __DIR__.'/includes/jdf.php';
require __DIR__.'/includes/auth.php';
require __DIR__.'/includes/db_connect.php';
require __DIR__.'/includes/config.php';


// شناسه ورودی (ممکن است عدد یا کد رندوم باشد)
$id = trim($_GET['id'] ?? '');
if ($id === '') exit('bad id');

// اگر فقط عدد بود
if (ctype_digit($id)) {
    $o = $mysqli->query("SELECT * FROM orders WHERE id=".(int)$id)->fetch_assoc();
    $items = $mysqli->query("SELECT * FROM order_items WHERE order_id=".(int)$id);
}
// اگر حروفی بود (کد 4-6 کاراکتری)
elseif (preg_match('/^[A-Z0-9]{4,6}$/i', $id)) {
    $st = $mysqli->prepare("SELECT * FROM orders WHERE order_uid=? LIMIT 1");
    $st->bind_param('s', $id);
    $st->execute();
    $o = $st->get_result()->fetch_assoc();
    $st->close();
    if ($o) {
        $oid = (int)$o['id'];
        $items = $mysqli->query("SELECT * FROM order_items WHERE order_id=$oid");
    }
} else exit('bad id');

if (!$o) exit('not found');

function nf($n){ return number_format((int)$n,0,'.',','); }
function toJalaliEn($date){
  if(!$date || !preg_match('/^\d{4}-\d{2}-\d{2}$/',$date)) return '-';
  list($gy,$gm,$gd)=explode('-',$date);
  $j=gregorian_to_jalali((int)$gy,(int)$gm,(int)$gd,'/');
  return strtr($j,['۰'=>'0','۱'=>'1','۲'=>'2','۳'=>'3','۴'=>'4','۵'=>'5','۶'=>'6','۷'=>'7','۸'=>'8','۹'=>'9']);
}

// ====================
// ✅ PDF Download
// ====================
if(isset($_GET['download'])){
  require_once __DIR__.'/lib/tcpdf/tcpdf.php';
  $pdf = new TCPDF('P','mm','A4',true,'UTF-8',false);
  $pdf->SetCreator('Salambaba');
  $pdf->SetTitle('فاکتور '.$o['invoice_no']);
  $pdf->SetMargins(10,20,10,true);
  $pdf->AddPage();
  $pdf->setRTL(true);
  $pdf->SetFont('freeserif','',12,'',true);

  // ثبت فونت IRANSans
  $fontPath = __DIR__.'/assets/IRANSansWeb.ttf';
  if(file_exists($fontPath)){
      $pdf->addTTFfont($fontPath, 'TrueTypeUnicode', '', 32);
      $pdf->SetFont('iransans','',11,'',true);
  }

  $logo = __DIR__.'/assets/logo-salambaba.png';
  $stamp = __DIR__.'/assets/stamp-salambaba.png';
  $trackUrl = BASE_URL.'track.php?code='.urlencode($o['tracking_code']);

  // نوار رنگی برند بالا
  $pdf->Rect(10, 15, 190, 3, 'F', [], [37,99,235]);   // آبی
  $pdf->Rect(57.5, 15, 47.5, 3, 'F', [], [22,163,74]); // سبز
  $pdf->Rect(105, 15, 47.5, 3, 'F', [], [245,158,11]); // زرد
  $pdf->Rect(152.5, 15, 47.5, 3, 'F', [], [220,38,38]); // قرمز

  $pdf->write2DBarcode($trackUrl, 'QRCODE,H', 15, 25, 25, 25, [], 'N');

  $html = '
  <div style="direction:rtl;text-align:right;font-family:iransans;">
    <table width="100%" border="0" cellpadding="4">
      <tr>
        <td width="70%">
          <h2 style="margin:0;">فاکتور فروش</h2>
          <p style="font-size:13px;color:#2563eb;"><b>سلام‌بابا</b></p>
          <p style="font-size:11px;">شماره فاکتور: <b>'.$o['invoice_no'].'</b><br>تاریخ: '.toJalaliEn($o['purchase_date']).'</p>
        </td>
        <td width="30%" align="left"><img src="'.$logo.'" height="45"></td>
      </tr>
    </table>

    <hr style="border:none;height:2px;background:#ddd;margin:10px 0;">

    <p style="font-size:11pt; line-height:1.9">
      <b>نام مشتری:</b> '.htmlspecialchars($o['customer_name']).'<br>
      <b>موبایل ۱:</b> '.htmlspecialchars($o['mobile1'] ?? '').'<br>
      <b>موبایل ۲:</b> '.htmlspecialchars($o['mobile2'] ?? '').'<br>
      <b>تلفن ثابت:</b> '.htmlspecialchars($o['phone'] ?? '').'<br>
      <b>استان:</b> '.htmlspecialchars($o['province'] ?? '').'<br>
      <b>آدرس:</b> '.htmlspecialchars($o['address'] ?? '').'<br>
      <b>گارانتی فاکتور:</b> '.htmlspecialchars($o['warranty'] ?? '').'<br>
      <b>لوکیشن:</b> '.htmlspecialchars($o['location_url'] ?? '').'<br>
      <b>توضیحات:</b><br>'.nl2br(htmlspecialchars($o['notes'] ?? '')).'
    </p>

    <table border="1" cellpadding="5" cellspacing="0" width="100%" style="text-align:center;border-color:#ccc;font-size:10pt;">
      <tr style="background-color:#f3f4f6;font-weight:bold;">
        <th width="5%">#</th>
        <th width="22%">مدل</th>
        <th width="12%">برند</th>
        <th width="7%">تعداد</th>
        <th width="12%">قیمت واحد</th>
        <th width="12%">جمع</th>
        <th width="10%">گارانتی</th>
        <th width="10%">بیعانه</th>
        <th width="10%">COD</th>
        <th width="10%">مانده</th>
      </tr>';
      $i=1; foreach($items as $it){
        $html.='<tr>
          <td>'.$i++.'</td>
          <td>'.htmlspecialchars($it['model']).'</td>
          <td>'.htmlspecialchars($it['brand']).'</td>
          <td>'.nf($it['qty']).'</td>
          <td>'.nf($it['price_unit']).'</td>
          <td>'.nf($it['price_total']).'</td>
          <td>'.htmlspecialchars($it['warranty_type']).'</td>
          <td>'.nf($it['deposit']).'</td>
          <td>'.nf($it['cod']).'</td>
          <td>'.nf($it['remaining']).'</td>
        </tr>';
      }
  $html.='</table>

  <br>
  <table width="100%" border="0" cellpadding="4" style="font-size:11pt;">
    <tr><td><b>جمع کل:</b></td><td>'.nf($o['total_amount']).' تومان</td></tr>
    <tr><td><b>بیعانه:</b></td><td>'.nf($o['total_deposit']).' تومان</td></tr>
    <tr><td><b>COD:</b></td><td>'.nf($o['total_cod']).' تومان</td></tr>
    <tr><td><b>مانده:</b></td><td>'.nf($o['total_remaining']).' تومان</td></tr>
  </table>

  <p style="font-size:11px;">🔗 پیگیری سفارش: '.$trackUrl.'</p>

  <div style="text-align:center;margin-top:25px;">
    <img src="'.$stamp.'" height="65"><br>
    <span style="font-size:11px;color:#555;">تأیید مدیریت فروش سلام‌بابا</span>
  </div>

  <hr style="border:none;height:3px;background:linear-gradient(90deg,#2563eb,#16a34a,#f59e0b,#dc2626);border-radius:3px;margin-top:25px;">
  <div style="text-align:center;font-size:10pt;color:#555;">قدرت‌گرفته از <b>سلام‌بابا</b> — <a href="'.BASE_URL.'" style="color:#2563eb;text-decoration:none;">'.BASE_URL.'</a></div>
  </div>';

  $pdf->writeHTML($html,true,false,true,false,'');
  $pdf->Output('invoice-'.$o['invoice_no'].'.pdf','D');
  exit;
}
?>

<!doctype html>
<html lang="fa" dir="rtl">
<meta charset="utf-8">
<title>فاکتور <?=htmlspecialchars($o['invoice_no'])?> | سلام‌بابا</title>
<body>
<div class="container">
<header class="brand">
<meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="stylesheet" href="assets/invoice.css">
<?php require __DIR__.'/includes/header.php'; ?>

  <div class="userbox">
    <a class="btn ghost" href="orders.php">فاکتورهای من</a>
    <a class="btn ghost" href="invoice_pdf.php?id=<?=htmlspecialchars($o['id'])?>&download=1">دانلود PDF</a>
    <a class="btn ghost" href="invoice_pdf.php?id=<?=htmlspecialchars($o['id'])?>">مشاهده PDF</a>
    <a class="btn ghost" href="new.php">فاکتور جدید</a>
  </div>
  
</header>

<section class="card">
  <div class="brand-strip"></div>

  <div class="invoice-header">
    <div class="invoice-top">
      <div class="invoice-title">
        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"><path d="M3 4h18v2H3zm0 4h18v14H3z"/></svg>
        فاکتور <?=htmlspecialchars($o['invoice_no'])?>
      </div>

      <a href="<?=BASE_URL?>track.php?code=<?=urlencode($o['tracking_code'])?>"
        target="_blank"
        class="track-chip"
        data-copy="<?=BASE_URL?>track.php?code=<?=urlencode($o['tracking_code'])?>">
        <span>🔗 لینک پیگیری</span>
        <span class="code"><?=htmlspecialchars($o['tracking_code'])?></span>
        <button type="button" class="copy-btn" title="کپی لینک">
          <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
            <path d="M16 1H4v12h12V1zm3 4H8v14h11V5z"/>
          </svg>
        </button>
      </a>
    </div>

    <div class="info-grid">

      <div class="info">👤 نام مشتری: <?=htmlspecialchars($o['customer_name'])?></div>
      <div class="info">📞 موبایل ۱: <?=htmlspecialchars($o['mobile1'] ?? '')?></div>
      <div class="info">📞 موبایل ۲: <?=htmlspecialchars($o['mobile2'] ?? '-')?></div>
      <div class="info">☎ تلفن ثابت: <?=htmlspecialchars($o['phone'] ?? '')?></div>

      <div class="info">👨‍💼 فروشنده: <?=htmlspecialchars($o['seller_name'])?></div>
      <div class="info">📅 تاریخ خرید: <?=toJalaliEn($o['purchase_date'])?></div>

      <div class="info">🗺 استان: <?=htmlspecialchars($o['province'] ?? '')?></div>
      

      <div class="info">
        📍 لینک موقعیت:
        <?php if(!empty($o['location_url'])): ?>
          <a href="<?=htmlspecialchars($o['location_url'])?>" target="_blank" style="color:#2563eb">
            مشاهده روی نقشه
          </a>
        <?php else: ?>
          <span>-</span>
        <?php endif; ?>
      </div>

      <div class="info">
        🛡 وضعیت گارانتی فاکتور:
        <?= ($o['warranty'] && strtolower(trim($o['warranty'])) !== 'none')
          ? htmlspecialchars($o['warranty'])
          : 'بدون گارانتی'; ?>
      </div>

      <div class="info full">🏠 آدرس کامل: <?=htmlspecialchars($o['address'])?></div>

      <div class="info full">📝 توضیحات فاکتور: <?=nl2br(htmlspecialchars($o['notes'] ?? ''))?></div>

    </div>
  </div>
</section>

<section class="card">
  <h3>📦 اقلام فاکتور</h3>
  <div class="table-responsive">
    <table class="items-table" cellpadding="6" cellspacing="0" width="100%" style="margin-top:10px;border-collapse:collapse;">
      <thead>
        <tr style="background:#f3f4f6;font-weight:bold;text-align:center;">
          <th>#</th>
          <th>مدل</th>
          <th>برند</th>
          <th>تعداد</th>
          <th>قیمت واحد</th>
          <th>جمع</th>
          <th>گارانتی</th>
          <th>بیعانه</th>
          <th>COD</th>
          <th>مانده</th>
        </tr>
      </thead>
      <tbody>
        <?php 
        $i = 1; 
        foreach($items as $it): 
            

          $qty = (int)($it['qty'] ?: 1);
          $price_total = (int)$it['price'];              // جمع فروش واقعی
          $price_unit  = $qty > 0 ? floor($price_total / $qty) : $price_total;  // قیمت واحد

        ?>
        <tr style="text-align:center;">
          <td><?=$i++?></td>
          <td><?=htmlspecialchars($it['model'] ?? '')?></td>
          <td><?=htmlspecialchars($it['brand'] ?? '')?></td>
          <td><?=nf($qty)?></td>
          <td><?=nf($price_unit)?></td>
          <td><?=nf($price_total)?></td>
<td>
  <?php 
    $wt = $it['warranty_type'] ?? 'none';

    switch($wt){
      case 'none':            echo 'بدون گارانتی'; break;
      case 'tv_silver':       echo 'نقره‌ای تلویزیون (۲٪)'; break;
      case 'tv_gold':         echo 'طلایی تلویزیون (۵٪)'; break;
      case 'home_appliance':  echo 'گارانتی لوازم خانگی (۳٪)'; break;
      case 'small_appliance': echo 'لوازم ریز (۲٪)'; break;
      default:                echo htmlspecialchars($wt);
    }
  ?>
</td>
          <td><?=nf($it['deposit'] ?? 0)?></td>
          <td><?=nf($it['cod'] ?? 0)?></td>
          <td><?=nf($it['remaining'] ?? 0)?></td>
        </tr>
        <?php if (!empty($it['notes'])): ?>
<tr class="item-note-row">
  <td></td>
  <td colspan="9" class="item-note">
    📝 <?= nl2br(htmlspecialchars($it['notes'])) ?>
  </td>
</tr>
<?php endif; ?>

        <?php endforeach; ?>
        
      </tbody>
    </table>
  </div>
</section>


<section class="invoice-totals">
  <h3>💰 خلاصه مالی فاکتور</h3>
  <div class="totals-grid">
    <div class="total-box amount">
      <span>جمع کل</span>
      <strong><?=nf($o['total_amount'])?></strong>
      <label>تومان</label>
    </div>
    <div class="total-box deposit">
      <span>بیعانه</span>
      <strong><?=nf($o['total_deposit'])?></strong>
      <label>تومان</label>
    </div>
    <div class="total-box cod">
      <span>پرداخت در محل</span>
      <strong><?=nf($o['total_cod'])?></strong>
      <label>تومان</label>
    </div>
    <div class="total-box remaining">
      <span>مانده قابل پرداخت</span>
      <strong><?=nf($o['total_remaining'])?></strong>
      <label>تومان</label>
    </div>
  </div>
</section>

<section class="card">
  <div class="totals">
    <div>جمع کل: <b><?=nf($o['total_amount'])?></b> تومان</div>
    <div>بیعانه: <b><?=nf($o['total_deposit'])?></b> تومان</div>
    <div>پرداخت در محل: <b><?=nf($o['total_cod'])?></b> تومان</div>
    <div>مانده: <b><?=nf($o['total_remaining'])?></b> تومان</div>
  </div>
</section>

</div>

<script>
document.addEventListener('click', function(e){
  const btn = e.target.closest('.copy-btn');
  if(!btn) return;
  e.preventDefault();
  e.stopImmediatePropagation();

  let url = btn.getAttribute('data-copy');
  if (!url) {
    const parent = btn.closest('.track-chip');
    url = parent ? parent.getAttribute('data-copy') : '';
  }
  if (!url) return alert('آدرس لینک یافت نشد');

  if (navigator.clipboard && window.isSecureContext) {
    navigator.clipboard.writeText(url).then(() => {
      btn.innerHTML = '✓';
      setTimeout(() => {
        btn.innerHTML = `
          <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
            <path d="M16 1H4c-1.1 0-2 .9-2 2v12h2V3h12V1zm3 4H8c-1.1 0-2 .9-2 2v14
            c0 1.1.9 2 2 2h11c1.1 0 2-.9 2-2V7c0-1.1-.9-2-2-2zm0 16H8V7h11v14z"/>
          </svg>`;
      }, 1000);
    }).catch(() => {
      alert('⚠️ کپی انجام نشد. لطفاً دستی کپی کنید.');
    });
  } else {
    const temp = document.createElement('textarea');
    temp.value = url;
    document.body.appendChild(temp);
    temp.select();
    try {
      document.execCommand('copy');
      btn.innerHTML = '✓';
      setTimeout(() => { temp.remove(); btn.innerHTML = '📋'; }, 1000);
    } catch {
      alert('کپی دستی انجام دهید.');
    }
  }
});

window.addEventListener('scroll', () => {
  document.body.classList.toggle('scrolled', window.scrollY > 30);
});
</script>

</body>
</html>
