CREATE DATABASE IF NOT EXISTS `salambaba_orders` CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci;
USE `salambaba_orders`;
CREATE TABLE IF NOT EXISTS `users`(id INT AUTO_INCREMENT PRIMARY KEY,username VARCHAR(100) UNIQUE,password_hash VARCHAR(255),full_name VARCHAR(120),role ENUM('seller','admin') DEFAULT 'seller',created_at DATETIME DEFAULT CURRENT_TIMESTAMP) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
CREATE TABLE IF NOT EXISTS `orders`(id INT AUTO_INCREMENT PRIMARY KEY,invoice_no VARCHAR(32) UNIQUE,tracking_code VARCHAR(64) UNIQUE,status ENUM('pending','shipped','delivered','cancelled') DEFAULT 'pending',status_note TEXT,username VARCHAR(100) NOT NULL,customer_name VARCHAR(190) NOT NULL,address TEXT NOT NULL,seller_name VARCHAR(120) NOT NULL,warranty ENUM('none','gold','silver') DEFAULT 'none',purchase_date DATE NOT NULL,total_amount BIGINT DEFAULT 0,total_deposit BIGINT DEFAULT 0,total_cod BIGINT DEFAULT 0,total_remaining BIGINT DEFAULT 0,notes TEXT,created_at DATETIME DEFAULT CURRENT_TIMESTAMP,INDEX(username),INDEX(purchase_date),INDEX(invoice_no)) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
CREATE TABLE IF NOT EXISTS `order_items`(id INT AUTO_INCREMENT PRIMARY KEY,order_id INT NOT NULL,model VARCHAR(190) NOT NULL,price BIGINT DEFAULT 0,deposit BIGINT DEFAULT 0,cod BIGINT DEFAULT 0,remaining BIGINT DEFAULT 0,FOREIGN KEY (order_id) REFERENCES orders(id) ON DELETE CASCADE) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
CREATE TABLE IF NOT EXISTS `withdrawals`(id INT AUTO_INCREMENT PRIMARY KEY,order_id INT NOT NULL,amount BIGINT NOT NULL,note VARCHAR(255),created_at DATETIME DEFAULT CURRENT_TIMESTAMP,FOREIGN KEY (order_id) REFERENCES orders(id) ON DELETE CASCADE) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;