<?php
require __DIR__.'/includes/auth.php';
require __DIR__.'/includes/config.php';
require __DIR__.'/includes/db_connect.php';
require __DIR__.'/includes/jalali.php';
require __DIR__.'/includes/helpers.php';
require __DIR__.'/includes/telegram.php';

$customer_name=trim($_POST['customer_name']??''); $seller_name=trim($_POST['seller_name']??'');
$purchase_date_raw=$_POST['purchase_date']??''; $purchase_date_sh=$_POST['purchase_date_sh']??'';
$warranty=$_POST['warranty']??'none'; $address=trim($_POST['address']??''); $notes=trim($_POST['notes']??'');
$items=$_POST['items']??[]; $targets=$_POST['target']??[];
$withdraw_amount=(int)($_POST['withdraw_amount']??0); $withdraw_note=trim($_POST['withdraw_note']??'');

$purchase_date_raw=fa2en(trim($purchase_date_raw)); $purchase_date_sh=fa2en(trim($purchase_date_sh));
if(preg_match('/^\d{4}-\d{2}-\d{2}$/',$purchase_date_raw)){$purchase_date=$purchase_date_raw;}
elseif($purchase_date_sh && ($g=jdate_to_gdate_ymd($purchase_date_sh))){$purchase_date=$g;}
else{$purchase_date=date('Y-m-d');}

if($customer_name===''||$seller_name===''||empty($items)){http_response_code(400);exit('پارامترها ناقص است.');}

$sum_p=0;$sum_d=0;$sum_c=0;$sum_r=0;
foreach($items as &$it){$p=(int)($it['price']??0);$d=(int)($it['deposit']??0);$c=(int)($it['cod']??0);$r=max($p-$d-$c,0);$it['remaining']=$r;$sum_p+=$p;$sum_d+=$d;$sum_c+=$c;$sum_r+=$r;}unset($it);

$mysqli->begin_transaction();
try{
  $st=$mysqli->prepare("INSERT INTO orders (invoice_no,tracking_code,status,status_note,username,customer_name,address,seller_name,warranty,purchase_date,total_amount,total_deposit,total_cod,total_remaining,notes,created_at) VALUES (NULL,NULL,'pending',NULL,?,?,?,?,?,?,?,?,?,?,?,NOW())");
  $st->bind_param("ssssssiiiiis", $_SESSION['username'],$customer_name,$address,$seller_name,$warranty,$purchase_date,$sum_p,$sum_d,$sum_c,$sum_r,$notes);
  $st->execute(); $oid=$st->insert_id; $st->close();

  $sti=$mysqli->prepare("INSERT INTO order_items (order_id,model,price,deposit,cod,remaining) VALUES (?,?,?,?,?,?)");
  foreach($items as $it){$m=trim($it['model']??'');$p=(int)($it['price']??0);$d=(int)($it['deposit']??0);$c=(int)($it['cod']??0);$r=(int)($it['remaining']??0);$sti->bind_param('isiiii',$oid,$m,$p,$d,$c,$r);$sti->execute();}$sti->close();

  if($withdraw_amount>0){$stw=$mysqli->prepare("INSERT INTO withdrawals (order_id,amount,note) VALUES (?,?,?)");$stw->bind_param('iis',$oid,$withdraw_amount,$withdraw_note);$stw->execute();$stw->close();}

  $ymj=ym_jalali_from_gregorian($purchase_date); $prefix='SB-'.$ymj.'-';
  $res=$mysqli->query("SELECT MAX(invoice_no) mx FROM orders WHERE invoice_no LIKE '".$mysqli->real_escape_string($prefix)."%'");
  $mx=$res->fetch_assoc()['mx']; $n=1; if($mx){$last=(int)substr($mx,-5);$n=$last+1;} $invoice_no=$prefix.str_pad((string)$n,5,'0',STR_PAD_LEFT);
  $tracking=sb_make_tracking_code($invoice_no,$oid);
  $up=$mysqli->prepare("UPDATE orders SET invoice_no=?,tracking_code=? WHERE id=?"); $up->bind_param('ssi',$invoice_no,$tracking,$oid); $up->execute(); $up->close();
  $mysqli->commit();
}catch(Throwable $e){$mysqli->rollback(); http_response_code(500); exit('❌ DB INSERT ERROR: '.$e->getMessage());}

$track_url=BASE_URL.'track.php?code='.urlencode($tracking); $wmap=['none'=>'بدون گارانتی','gold'=>'طلایی','silver'=>'نقره‌ای'];
$txt='🧾 <b>فاکتور جدید</b>\n#'.$invoice_no.'\n'.'👤 مشتری: <b>'.$customer_name.'</b>\n'.'👨‍💼 فروشنده: '.$seller_name.'\n'.'📅 تاریخ: '.$purchase_date.'\n'.'🛡 گارانتی: '.$wmap[$warranty].'\n'.'📍 آدرس: '.$address.'\n\n<b>اقلام:</b>\n';
$rs=$mysqli->query('SELECT model,price,deposit,cod,remaining FROM order_items WHERE order_id='.$oid); $i=1; while($r=$rs->fetch_assoc()){ $txt.=$i++.'. '.$r['model'].' — مبلغ: '.nf($r['price']).' / بیعانه: '.nf($r['deposit']).' / COD: '.nf($r['cod']).' / مانده: '.nf($r['remaining'])."\n"; }
$txt.="\n<b>جمع کل:</b> ".nf($sum_p)." — <b>بیعانه:</b> ".nf($sum_d)." — <b>COD:</b> ".nf($sum_c)." — <b>مانده:</b> ".nf($sum_r)."\n\n🔗 پیگیری: ".$track_url;
if($withdraw_amount>0){$txt.="\n💸 برداشت: ".nf($withdraw_amount).($withdraw_note?" — $withdraw_note":"");}
if($notes)$txt.="\n📝 $notes";
$targets=is_array($targets)?$targets:[]; foreach($targets as $t){global $CHAT_MAP,$BOT_TOKEN; if(!isset($CHAT_MAP[$t]))continue; tg_send_message($BOT_TOKEN,$CHAT_MAP[$t],$txt);}
header('Location: invoice.php?id='.$oid);