<?php
/**
 * jdf.php — Persian (Jalali) date conversion library
 * Version: 2.0 — Clean, UTF8-safe, PHP 7+
 * Author: سلام‌بابا نسخه اختصاصی
 */

/**
 * تبدیل تاریخ میلادی به شمسی
 * خروجی: 1404/08/18
 */
function gregorian_to_jalali($gy, $gm, $gd, $mod = '/'){
    $g_d_m = array(0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334);
    $gy2 = ($gm > 2) ? ($gy + 1) : $gy;
    $days = 355666 + (365 * $gy)
           + floor(($gy2 + 3) / 4)
           - floor(($gy2 + 99) / 100)
           + floor(($gy2 + 399) / 400)
           + $gd + $g_d_m[$gm - 1];
    $jy = -1595 + (33 * floor($days / 12053));
    $days %= 12053;
    $jy += 4 * floor($days / 1461);
    $days %= 1461;
    if ($days > 365) {
        $jy += floor(($days - 1) / 365);
        $days = ($days - 1) % 365;
    }
    if ($days < 186) {
        $jm = 1 + floor($days / 31);
        $jd = 1 + ($days % 31);
    } else {
        $jm = 7 + floor(($days - 186) / 30);
        $jd = 1 + (($days - 186) % 30);
    }
    // خروجی با جداکننده انتخابی
    $result = $jy . $mod . str_pad($jm, 2, '0', STR_PAD_LEFT) . $mod . str_pad($jd, 2, '0', STR_PAD_LEFT);
    return _toEnglishDigits($result);
}

/**
 * تبدیل تاریخ شمسی به میلادی
 * خروجی: 2025-11-08
 */
function jalali_to_gregorian($jy, $jm, $jd, $mod = '-'){
    $jy += 1595;
    $days = -355668 + (365 * $jy)
          + floor($jy / 33) * 8
          + floor((($jy % 33) + 3) / 4)
          + $jd
          + (($jm < 7) ? (($jm - 1) * 31) : ((($jm - 7) * 30) + 186));
    $gy = 400 * floor($days / 146097);
    $days %= 146097;
    if ($days > 36524) {
        $gy += 100 * floor(--$days / 36524);
        $days %= 36524;
        if ($days >= 365) $days++;
    }
    $gy += 4 * floor($days / 1461);
    $days %= 1461;
    if ($days > 365) {
        $gy += floor(($days - 1) / 365);
        $days = ($days - 1) % 365;
    }
    $sal_a = array(0, 31, (($gy % 4 == 0 && $gy % 100 != 0) || ($gy % 400 == 0)) ? 29 : 28,
        31, 30, 31, 30, 31, 31, 30, 31, 30, 31);
    for ($gm = 0; $gm < 13 && $days >= $sal_a[$gm]; $gm++)
        $days -= $sal_a[$gm];
    $gd = $days + 1;
    $result = $gy . $mod . str_pad($gm, 2, '0', STR_PAD_LEFT) . $mod . str_pad($gd, 2, '0', STR_PAD_LEFT);
    return _toEnglishDigits($result);
}

/**
 * تابع کمکی برای تبدیل اعداد فارسی یا عربی به انگلیسی
 */
function _toEnglishDigits($str){
    return strtr($str, [
        '۰'=>'0','۱'=>'1','۲'=>'2','۳'=>'3','۴'=>'4',
        '۵'=>'5','۶'=>'6','۷'=>'7','۸'=>'8','۹'=>'9',
        '٠'=>'0','١'=>'1','٢'=>'2','٣'=>'3','٤'=>'4',
        '٥'=>'5','٦'=>'6','٧'=>'7','٨'=>'8','٩'=>'9'
    ]);
}
?>
