<?php
// ========================
// invoice.php - نسخه ضد‌خطا TCPDF
// ========================

// جلوگیری از ارسال هرگونه خطا
error_reporting(0);
ini_set('display_errors', 0);
ob_start();

require __DIR__.'/includes/jdf.php';
require __DIR__.'/includes/auth.php';
require __DIR__.'/includes/db_connect.php';
require __DIR__.'/includes/config.php';

$id = (int)($_GET['id'] ?? 0);
if ($id <= 0) exit('bad id');

$o = $mysqli->query('SELECT * FROM orders WHERE id='.$id)->fetch_assoc();
if (!$o) exit('not found');
$items = $mysqli->query('SELECT * FROM order_items WHERE order_id='.$id);

function nf($n){ return number_format((int)$n,0,'.',','); }
function toJalaliEn($date){
  if(!$date || !preg_match('/^\d{4}-\d{2}-\d{2}$/',$date)) return '-';
  list($gy,$gm,$gd)=explode('-',$date);
  $j=gregorian_to_jalali((int)$gy,(int)$gm,(int)$gd,'/');
  return strtr($j,['۰'=>'0','۱'=>'1','۲'=>'2','۳'=>'3','۴'=>'4','۵'=>'5','۶'=>'6','۷'=>'7','۸'=>'8','۹'=>'9']);
}

// مسیر TCPDF
define('TCPDF_PATH', __DIR__.'/lib/tcpdf/tcpdf.php');

if (!file_exists(TCPDF_PATH)) exit('TCPDF not found');

require_once TCPDF_PATH;
$pdf = new TCPDF('P', 'mm', 'A4', true, 'UTF-8', false);
$pdf->SetCreator('Salambaba');
$pdf->SetTitle('فاکتور فروش '.$o['invoice_no']);
$pdf->SetMargins(12, 20, 12, true);
$pdf->SetAutoPageBreak(true, 20);
$pdf->AddPage();
$pdf->SetFont('dejavusans', '', 11, '', true);

// QR code پیگیری
$trackUrl = BASE_URL.'track.php?code='.urlencode($o['tracking_code']);
$pdf->write2DBarcode($trackUrl, 'QRCODE,H', 170, 20, 25, 25, [], 'N');

// HTML محتوا
$html = '
<div style="direction:rtl;text-align:right;font-family:DejaVuSans;">
  <h2 style="margin:0;color:#111;">فاکتور فروش — <span style="color:#2563eb;">سلام‌بابا</span></h2>
  <p>شماره فاکتور: <b>'.$o['invoice_no'].'</b></p>
  <p>تاریخ خرید: '.toJalaliEn($o['purchase_date']).'</p>
  <p><b>مشتری:</b> '.htmlspecialchars($o['customer_name']).' | <b>فروشنده:</b> '.htmlspecialchars($o['seller_name']).'</p>
  <p><b>آدرس:</b> '.htmlspecialchars($o['address']).'</p>
  <p><b>گارانتی:</b> '.htmlspecialchars($o['warranty']).'</p>
</div>
<br>
<table border="1" cellpadding="4" cellspacing="0" style="direction:rtl;text-align:center;">
<tr style="background:#f3f4f6;font-weight:bold;">
<th>#</th><th>مدل</th><th>قیمت</th><th>بیعانه</th><th>COD</th><th>مانده</th>
</tr>';
$i=1;
foreach($items as $it){
  $html .= '<tr>
    <td>'.$i++.'</td>
    <td>'.htmlspecialchars($it['model']).'</td>
    <td>'.nf($it['price']).'</td>
    <td>'.nf($it['deposit']).'</td>
    <td>'.nf($it['cod']).'</td>
    <td>'.nf($it['remaining']).'</td>
  </tr>';
}
$html .= '</table>
<br>
<p><b>جمع کل:</b> '.nf($o['total_amount']).' تومان — <b>بیعانه:</b> '.nf($o['total_deposit']).' تومان — <b>COD:</b> '.nf($o['total_cod']).' تومان — <b>مانده:</b> '.nf($o['total_remaining']).' تومان</p>
<br>
<p>پیگیری مشتری: '.$trackUrl.'</p>
<div style="margin-top:20px;text-align:center;color:#666;">قدرت‌گرفته از سلام‌بابا</div>
';

// پاک‌سازی تمام بافرها برای جلوگیری از خطای header
if (ob_get_length()) ob_end_clean();
while (ob_get_level()) ob_end_clean();

// خروجی PDF واقعی (دانلود اجباری)
$pdf->writeHTML($html, true, false, true, false, '');
$pdf->Output('invoice-'.$o['invoice_no'].'.pdf', 'D');
exit;
?>
