<?php
require __DIR__ . '/includes/config.php';
require __DIR__ . '/includes/db_connect.php';
require __DIR__ . '/includes/auth.php';
header('Content-Type: application/json; charset=utf-8');

$order_id = intval($_POST['order_id'] ?? 0);
$amount   = intval($_POST['amount'] ?? 0);
$note     = trim($_POST['note'] ?? '');

if(!$order_id || $amount <= 0){
  echo json_encode(['ok'=>false,'error'=>'اطلاعات ناقص یا نامعتبر']);
  exit;
}

try {
  $mysqli->begin_transaction();

  // ثبت برداشت جدید
  $st = $mysqli->prepare("INSERT INTO withdrawals (order_id, amount, note) VALUES (?, ?, ?)");
  $st->bind_param("iis", $order_id, $amount, $note);
  $st->execute();
  $st->close();

  // محاسبه مجموع برداشت‌های این فروشنده
  $q = $mysqli->query("
    SELECT o.username, 
           SUM(w.amount) AS total_withdraw,
           (SELECT SUM(total_deposit) FROM orders WHERE username=o.username) AS total_deposit
    FROM orders o
    JOIN withdrawals w ON o.id=w.order_id
    WHERE o.username = (SELECT username FROM orders WHERE id=$order_id LIMIT 1)
    GROUP BY o.username
  ");
  $r = $q->fetch_assoc();
  if($r){
    $remain = (int)$r['total_deposit'] - (int)$r['total_withdraw'];
    // به‌روزرسانی مانده حساب در جدول users
    $u = $mysqli->prepare("UPDATE users SET balance=? WHERE username=?");
    $u->bind_param("is", $remain, $r['username']);
    $u->execute();
    $u->close();
  }

  $mysqli->commit();
  echo json_encode(['ok'=>true]);

} catch(Throwable $e){
  $mysqli->rollback();
  echo json_encode(['ok'=>false,'error'=>'DB ERROR: '.$e->getMessage()]);
}
