<?php
require __DIR__.'/includes/auth.php';
require __DIR__.'/includes/config.php';
require __DIR__.'/includes/db_connect.php';

$id = (int)($_GET['id'] ?? 0);
if($id <= 0) exit('شناسه معتبر نیست');

$o = $mysqli->query("SELECT * FROM orders WHERE id=$id")->fetch_assoc();
if(!$o) exit('فاکتور یافت نشد');
$items = $mysqli->query("SELECT * FROM order_items WHERE order_id=$id")->fetch_all(MYSQLI_ASSOC);

function h($x){return htmlspecialchars($x,ENT_QUOTES,'UTF-8');}
?>
<!doctype html>
<html lang="fa" dir="rtl">
<meta charset="utf-8">
<title>✏️ ویرایش فاکتور #<?=$id?> | سلام‌بابا</title>
<link rel="stylesheet" href="assets/style.css">
<style>
body{font-family:'IRANYekan',sans-serif;background:#f7f8fb;margin:0;}
.container{max-width:950px;margin:40px auto;padding:20px;}
.card{background:#fff;padding:25px;border-radius:15px;box-shadow:0 2px 5px rgba(0,0,0,.08);}
h2{font-size:20px;margin-bottom:20px;border-bottom:2px solid #e5e7eb;padding-bottom:8px;}
.form-grid{display:grid;grid-template-columns:repeat(auto-fit,minmax(260px,1fr));gap:15px;}
label span{font-size:13px;color:#374151;display:block;margin-bottom:5px;}
input,select,textarea{width:100%;padding:8px 10px;border:1px solid #d1d5db;border-radius:8px;font-size:14px;box-sizing:border-box;}
textarea{resize:vertical;min-height:80px;}
.btns{display:flex;justify-content:space-between;margin-top:25px;}
.btn{display:inline-block;padding:10px 18px;border-radius:8px;border:none;cursor:pointer;font-weight:bold;transition:.2s;}
.btn.primary{background:#2563eb;color:#fff;}
.btn.primary:hover{background:#1e40af;}
.btn.ghost{background:#e5e7eb;color:#111;}
.btn.ghost:hover{background:#d1d5db;}
.note{margin-top:10px;font-size:13px;color:#6b7280;}
.table-wrapper{overflow-x:auto;margin-top:20px;}
table{width:100%;border-collapse:collapse;font-size:14px;}
th,td{border-bottom:1px solid #eee;padding:6px;text-align:center;}
th{background:#f3f4f6;}
.action-btns button{padding:5px 8px;border:none;border-radius:5px;cursor:pointer;}
.action-btns .del{background:#dc2626;color:#fff;}
.action-btns .del:hover{background:#b91c1c;}
.action-btns .add{background:#16a34a;color:#fff;}
.action-btns .add:hover{background:#15803d;}
#msgBox{margin-top:15px;font-weight:bold;text-align:center;}
.success{color:#16a34a;}
.error{color:#dc2626;}
@media(max-width:600px){.btns{flex-direction:column;gap:10px;}}
</style>

<body>
<div class="container">
<div class="card">
<h2>✏️ ویرایش فاکتور #<?=$id?></h2>

<form id="editForm">
<input type="hidden" name="id" value="<?=$id?>">

<div class="form-grid">
  <label><span>نام مشتری</span><input name="customer_name" value="<?=h($o['customer_name'])?>" required></label>
  <label><span>آدرس</span><input name="address" value="<?=h($o['address'])?>"></label>
  <label><span>گارانتی</span>
    <select name="warranty">
      <option <?=$o['warranty']=='ندارد'?'selected':''?>>ندارد</option>
      <option <?=$o['warranty']=='طلایی'?'selected':''?>>طلایی</option>
      <option <?=$o['warranty']=='نقره‌ای'?'selected':''?>>نقره‌ای</option>
    </select>
  </label>
  <label><span>تاریخ خرید</span><input name="purchase_date" type="date" value="<?=h($o['purchase_date'])?>"></label>
  <label><span>مبلغ کل فروش</span><input name="total_amount" type="number" value="<?=h($o['total_amount'])?>"></label>
  <label><span>بیعانه</span><input name="total_deposit" type="number" value="<?=h($o['total_deposit'])?>"></label>
  <label><span>مانده حساب</span><input name="total_remaining" type="number" value="<?=h($o['total_remaining'])?>"></label>
  <label><span>توضیحات اضافی</span><textarea name="notes"><?=h($o['notes'])?></textarea></label>
</div>

<h3 style="margin-top:30px;">🧾 اقلام فاکتور</h3>
<div class="table-wrapper">
<table id="itemsTable">
<thead><tr>
  <th>#</th><th>مدل</th><th>قیمت</th><th>بیعانه</th><th>COD</th><th>مانده</th><th>عملیات</th>
</tr></thead>
<tbody>
<?php $i=1; foreach($items as $it): ?>
<tr>
  <td><?=$i++?></td>
  <td><input name="model[]" value="<?=h($it['model'])?>"></td>
  <td><input name="price[]" type="number" value="<?=h($it['price'])?>"></td>
  <td><input name="deposit[]" type="number" value="<?=h($it['deposit'])?>"></td>
  <td><input name="cod[]" type="number" value="<?=h($it['cod'])?>"></td>
  <td><input name="remaining[]" type="number" value="<?=h($it['remaining'])?>"></td>
  <td class="action-btns"><button type="button" class="del" onclick="removeRow(this)">✖</button></td>
</tr>
<?php endforeach; ?>
</tbody>
</table>
<div style="margin-top:10px;text-align:left;">
  <button type="button" class="btn add" onclick="addRow()">➕ افزودن قلم جدید</button>
</div>
</div>

<div class="btns">
  <button class="btn primary" type="submit">💾 ذخیره تغییرات</button>
  <a href="orders.php" class="btn ghost">بازگشت</a>
</div>
<p class="note">با افزودن یا حذف اقلام، مجموع فاکتور در گزارشات به‌روز می‌شود.</p>
<div id="msgBox"></div>
</form>
</div>
</div>

<script>
function removeRow(btn){btn.closest('tr').remove();}
function addRow(){
  const tbody = document.querySelector('#itemsTable tbody');
  const tr = document.createElement('tr');
  tr.innerHTML = `
    <td>+</td>
    <td><input name="model[]" placeholder="مدل کالا"></td>
    <td><input name="price[]" type="number" placeholder="قیمت"></td>
    <td><input name="deposit[]" type="number" placeholder="بیعانه"></td>
    <td><input name="cod[]" type="number" placeholder="COD"></td>
    <td><input name="remaining[]" type="number" placeholder="مانده"></td>
    <td class="action-btns"><button type="button" class="del" onclick="removeRow(this)">✖</button></td>
  `;
  tbody.appendChild(tr);
}

document.getElementById('editForm').addEventListener('submit', async (e)=>{
  e.preventDefault();
  const fd = new FormData(e.target);
  const msg = document.getElementById('msgBox');
  msg.innerHTML = '⏳ در حال ذخیره...';
  msg.className = '';
  try {
    const res = await fetch('/orders/xhr_update_order.php', {method:'POST', body:fd});
    const text = await res.text(); // اول متن خام رو بگیر
    let j;
    try { j = JSON.parse(text); } catch(e){ throw new Error('Bad JSON: '+text); }

    if(j.ok){
      msg.className = 'success';
      msg.innerHTML = '✅ اطلاعات با موفقیت ذخیره شد!';
      setTimeout(()=>location.href='/orders/orders.php', 1500);
    } else {
      msg.className = 'error';
      msg.innerHTML = '❌ '+(j.error || 'خطا در ذخیره اطلاعات');
    }
  } catch(e){
    msg.className = 'error';
    msg.innerHTML = '⚠️ خطای ارتباط با سرور<br>'+e.message;
  }
});

</script>
</body>
</html>
