<?php
session_start();
ini_set('display_errors', 1);
error_reporting(E_ALL);

require_once __DIR__.'/db_connect.php';

$user = $_SESSION['username'] ?? '';
$role = $_SESSION['role'] ?? '';
$full_name = '';

if ($user && isset($mysqli) && $mysqli instanceof mysqli) {
    $stmt = $mysqli->prepare("SELECT full_name FROM users WHERE username=? LIMIT 1");
    if ($stmt) {
        $stmt->bind_param("s", $user);
        $stmt->execute();
        $stmt->bind_result($full_name);
        $stmt->fetch();
        $stmt->close();
    }
}
?>
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
<meta charset="UTF-8">
<title>مدیریت سفارشات</title>
<style>
/* ================================
   🎨 Font Definitions (IRANSansWeb)
   ================================ */
@font-face {
  font-family: 'IRANSans';
  src: url('https://salambaba.co/font/IRANSansWeb.woff2') format('woff2'),
       url('https://salambaba.co/font/IRANSansWeb.woff') format('woff');
  font-weight: normal;
  font-style: normal;
  font-display: swap;
}
@font-face {
  font-family: 'IRANSans';
  src: url('https://salambaba.co/font/IRANSansWeb_Bold.woff2') format('woff2'),
       url('https://salambaba.co/font/IRANSansWeb_Bold.woff') format('woff');
  font-weight: bold;
  font-style: normal;
  font-display: swap;
}
@font-face {
  font-family: 'IRANSans';
  src: url('https://salambaba.co/font/IRANSansWeb_Light.woff2') format('woff2'),
       url('https://salambaba.co/font/IRANSansWeb_Light.woff') format('woff');
  font-weight: 300;
  font-style: normal;
  font-display: swap;
}

body {
  margin: 0;
  font-family: 'IRANSans', sans-serif;
  background: #f8fafc;
  color: #1f2937;
}

/* ================================
   🌈 Header Styling
   ================================ */
header.brand {
  background: linear-gradient(145deg, #1e293b, #334155);
  color: #fff;
  display: flex;
  justify-content: space-between;
  align-items: center;
  padding: 0rem 1.5rem;
  border-bottom: 3px solid #0ea5e9;
  box-shadow: 0 2px 8px rgba(0,0,0,0.15);
  position: relative;
  border-radius: 0 0 18px 18px;
  z-index: 1001;
}

/* Logo */
header .logo {
  font-size: 1.4rem;
  font-weight: bold;
  background: linear-gradient(90deg, #3b82f6, #10b981, #facc15, #ef4444);
  -webkit-background-clip: text;
  -webkit-text-fill-color: transparent;
}

/* Right section (menu button + logo) */
.header-right {
  display: flex;
  align-items: center;
  gap: 1rem;
}

/* Left section (user info) */
.header-left {
  display: flex;
  align-items: center;
  gap: 0.6rem;
}

/* User info box */
.user-info {
  background: rgba(255,255,255,0.12);
  padding: 0.35rem 0.9rem;
  border-radius: 50px;
  font-size: 0.9rem;
  white-space: nowrap;
}

/* Hamburger button */
.menu-toggle {
  background: rgba(255,255,255,0.1);
  border: none;
  color: #fff;
  font-size: 1.8rem;
  cursor: pointer;
  width: 44px;
  height: 44px;
  border-radius: 50%;
  display: flex;
  justify-content: center;
  align-items: center;
  transition: background 0.2s ease;
}
.menu-toggle:hover {
  background: rgba(255,255,255,0.25);
}

/* ================================
   📱 Dropdown Menu
   ================================ */
.nav-overlay {
  display: none;
  position: fixed;
  inset: 0;
  background: rgba(0,0,0,0.4);
  backdrop-filter: blur(5px);
  z-index: 1000;
  transition: opacity 0.3s ease;
}

.nav-menu {
  position: absolute;
  top: 100%;
  right: 1rem;
  background: rgba(31,41,55,0.95);
  border-radius: 16px;
  padding: 0.8rem;
  display: none;
  flex-direction: column;
  gap: 0.5rem;
  width: 230px;
  box-shadow: 0 8px 20px rgba(0,0,0,0.3);
  animation: fadeDown 0.25s ease;
  z-index: 1001;
}
.nav-menu.active {
  display: flex;
}
.nav-overlay.active {
  display: block;
}

.nav-menu a {
  text-decoration: none;
  color: #fff;
  background: rgba(255,255,255,0.08);
  padding: 0.5rem 0.9rem;
  border-radius: 8px;
  font-size: 0.92rem;
  transition: 0.2s;
}
.nav-menu a:hover {
  background: rgba(255,255,255,0.2);
}
.nav-menu a.danger {
  background: #ef4444;
}
.nav-menu a.danger:hover {
  background: #dc2626;
}

@keyframes fadeDown {
  from {opacity: 0; transform: translateY(-6px);}
  to {opacity: 1; transform: translateY(0);}
}

/* Responsive */
@media (max-width: 768px) {
  header.brand {
    border-radius: 12px;
    width: 100%;
    padding: 0px;
  }
  .nav-menu {
    right: 0.8rem;
    width: 85%;
  }
}
</style>
</head>
<body>

<header class="brand">
  <div class="header-right">
    <button class="menu-toggle" id="menuToggle">☰</button>
    <div class="logo">سلام‌بابا</div>
  </div>

  <div class="header-left">
    <span class="user-info">👤 <?php echo htmlspecialchars($full_name ?: $user); ?></span>
  </div>

  <div class="nav-menu" id="navMenu">
    <a href="../orders">📦 فاکتور جدید</a>
    <a href="orders.php">📦 فاکتورها</a>
    <a href="dashboard.php">💰 داشبورد مالی</a>
    <?php if ($role === 'admin'): ?>
      <a href="reports.php">📊 گزارش ماهانه</a>
    <?php endif; ?>
    <a class="danger" href="logout.php">خروج</a>
  </div>
</header>

<div class="nav-overlay" id="navOverlay"></div>

<script>
// همبرگری و پس‌زمینه تار
const toggle = document.getElementById('menuToggle');
const menu = document.getElementById('navMenu');
const overlay = document.getElementById('navOverlay');

toggle.addEventListener('click', () => {
  menu.classList.toggle('active');
  overlay.classList.toggle('active');
});

// کلیک بیرون از منو = بستن
overlay.addEventListener('click', () => {
  menu.classList.remove('active');
  overlay.classList.remove('active');
});
</script>

</body>
</html>
