<?php
error_reporting(0);
require __DIR__.'/includes/jdf.php';
require __DIR__.'/includes/auth.php';
require __DIR__.'/includes/db_connect.php';
require __DIR__.'/includes/config.php';

$id = (int)($_GET['id'] ?? 0);
if ($id <= 0) exit('bad id');

$o = $mysqli->query("SELECT * FROM orders WHERE id=$id")->fetch_assoc();
if (!$o) exit('not found');
$items = $mysqli->query("SELECT * FROM order_items WHERE order_id=$id");

function nf($n){ return number_format((int)$n,0,'.',','); }
function toJalaliEn($date){
  if(!$date || !preg_match('/^\d{4}-\d{2}-\d{2}$/',$date)) return '-';
  list($gy,$gm,$gd) = explode('-',$date);
  $j = gregorian_to_jalali((int)$gy,(int)$gm,(int)$gd,'/');
  return strtr($j,['۰'=>'0','۱'=>'1','۲'=>'2','۳'=>'3','۴'=>'4','۵'=>'5','۶'=>'6','۷'=>'7','۸'=>'8','۹'=>'9']);
}

if(isset($_GET['download'])){
  require_once __DIR__.'/lib/tcpdf/tcpdf.php';
  $pdf = new TCPDF('P','mm','A4',true,'UTF-8',false);
  $pdf->SetCreator('Salambaba');
  $pdf->SetTitle('فاکتور '.$o['invoice_no']);
  $pdf->SetMargins(10,25,10,true);
  $pdf->AddPage();
  $pdf->SetFont('dejavusans','',11,'',true);

  $logo = __DIR__.'/assets/logo-salambaba.png';
  $stamp = __DIR__.'/assets/stamp-salambaba.png';
  $trackUrl = BASE_URL.'track.php?code='.urlencode($o['tracking_code']);

  // نوار رنگی برند
  $pdf->Rect(10, 15, 190, 4, 'F', [], [37,99,235]); // آبی
  $pdf->Rect(57.5, 15, 47.5, 4, 'F', [], [22,163,74]); // سبز
  $pdf->Rect(105, 15, 47.5, 4, 'F', [], [245,158,11]); // زرد
  $pdf->Rect(152.5, 15, 47.5, 4, 'F', [], [220,38,38]); // قرمز

  // QR سمت چپ بالا
  $pdf->write2DBarcode($trackUrl, 'QRCODE,H', 15, 25, 25, 25, [], 'N');

  $html = '
  <div style="direction:rtl;text-align:right">
    <table width="100%" border="0" cellpadding="4">
      <tr>
        <td width="70%">
          <h2 style="margin:0;">فاکتور فروش</h2>
          <p style="font-size:13px;color:#2563eb;"><b>سلام‌بابا</b></p>
          <p style="font-size:11px;">شماره فاکتور: <b>'.$o['invoice_no'].'</b><br>تاریخ: '.toJalaliEn($o['purchase_date']).'</p>
        </td>
        <td width="30%" align="left"><img src="'.$logo.'" height="50"></td>
      </tr>
    </table>

    <hr style="border:none;height:2px;background:#e5e7eb;margin:10px 0;">

    <p><b>مشتری:</b> '.htmlspecialchars($o['customer_name']).'<br>
       <b>فروشنده:</b> '.htmlspecialchars($o['seller_name']).'<br>
       <b>آدرس:</b> '.htmlspecialchars($o['address']).'<br>
       <b>گارانتی:</b> '.htmlspecialchars($o['warranty']).'</p>

    <table border="1" cellpadding="5" cellspacing="0" width="100%" style="text-align:center;border-color:#ddd;">
      <tr style="background-color:#f3f4f6;font-weight:bold;">
        <th width="6%">#</th>
        <th width="38%">مدل</th>
        <th width="14%">قیمت</th>
        <th width="14%">بیعانه</th>
        <th width="14%">COD</th>
        <th width="14%">مانده</th>
      </tr>';
      $i=1; foreach($items as $it){
        $html .= '<tr>
          <td>'.$i++.'</td>
          <td>'.htmlspecialchars($it['model']).'</td>
          <td>'.nf($it['price']).'</td>
          <td>'.nf($it['deposit']).'</td>
          <td>'.nf($it['cod']).'</td>
          <td>'.nf($it['remaining']).'</td>
        </tr>';
      }
  $html .= '</table>
  <br>
  <table width="100%" border="0" cellpadding="4">
    <tr><td><b>جمع کل:</b></td><td>'.nf($o['total_amount']).' تومان</td></tr>
    <tr><td><b>بیعانه:</b></td><td>'.nf($o['total_deposit']).' تومان</td></tr>
    <tr><td><b>مانده:</b></td><td>'.nf($o['total_remaining']).' تومان</td></tr>
  </table>

  <p style="font-size:11px;">🔗 پیگیری سفارش: '.$trackUrl.'</p>

  <div style="text-align:center;margin-top:25px;">
    <img src="'.$stamp.'" height="65"><br>
    <span style="font-size:11px;color:#555;">تأیید مدیریت فروش سلام‌بابا</span>
  </div>

  <hr style="border:none;height:3px;background:linear-gradient(90deg,#2563eb,#16a34a,#f59e0b,#dc2626);border-radius:3px;margin-top:25px;">
  <div style="text-align:center;font-size:10pt;color:#555;">قدرت‌گرفته از <b>سلام‌بابا</b> — <a href="'.BASE_URL.'" style="color:#2563eb;text-decoration:none;">'.BASE_URL.'</a></div>
  </div>';

  $pdf->writeHTML($html,true,false,true,false,'');
  $pdf->Output('invoice-'.$o['invoice_no'].'.pdf','D');
  exit;
}
?>
<!doctype html><html lang="fa" dir="rtl"><meta charset="utf-8">
<title>فاکتور <?=htmlspecialchars($o['invoice_no'])?> | سلام‌بابا</title>
<link rel="stylesheet" href="assets/style.css">
<body>
<div class="container">
<header class="brand">
  <div class="logo">سلام‌بابا</div>
  <div class="userbox">
    <a class="btn ghost" href="orders.php">بازگشت</a>
    <a class="btn primary" href="?id=<?=$id?>&download=1">دانلود PDF</a>
    <a class="btn danger" href="index.php">ثبت جدید</a>
  </div>
</header>

<section class="card">
  <h3>فاکتور <?=htmlspecialchars($o['invoice_no'])?></h3>
  <p><b>مشتری:</b> <?=htmlspecialchars($o['customer_name'])?> — <b>فروشنده:</b> <?=htmlspecialchars($o['seller_name'])?></p>
  <p><b>تاریخ:</b> <?=toJalaliEn($o['purchase_date'])?> — <b>گارانتی:</b> <?=htmlspecialchars($o['warranty'])?></p>
  <p><b>آدرس:</b> <?=htmlspecialchars($o['address'])?></p>
  <p class="note">پیگیری: <a href="<?=BASE_URL?>track.php?code=<?=urlencode($o['tracking_code'])?>" target="_blank"><?=BASE_URL?>track.php?code=<?=htmlspecialchars($o['tracking_code'])?></a></p>

  <table class="table">
    <thead><tr><th>#</th><th>مدل</th><th>قیمت</th><th>بیعانه</th><th>COD</th><th>مانده</th></tr></thead>
    <tbody>
      <?php $i=1; $items->data_seek(0); while($it=$items->fetch_assoc()): ?>
        <tr><td><?=$i++?></td><td><?=htmlspecialchars($it['model'])?></td><td><?=nf($it['price'])?></td><td><?=nf($it['deposit'])?></td><td><?=nf($it['cod'])?></td><td><?=nf($it['remaining'])?></td></tr>
      <?php endwhile; ?>
    </tbody>
  </table>

  <div class="totals">
    <div>جمع کل: <b><?=nf($o['total_amount'])?></b></div>
    <div>بیعانه: <b><?=nf($o['total_deposit'])?></b></div>
    <div>مانده: <b><?=nf($o['total_remaining'])?></b></div>
  </div>
</section>
</div>
</body>
</html>
