<?php
session_start();
if(isset($_SESSION['user_id'])){header('Location: index.php');exit;}
require __DIR__.'/includes/db_connect.php'; 
$msg='';

if($_SERVER['REQUEST_METHOD']==='POST'){
  $u=trim($_POST['username']??''); 
  $p=$_POST['password']??'';
  $st=$mysqli->prepare('SELECT id,username,password_hash,full_name,role FROM users WHERE username=?');
  $st->bind_param('s',$u);
  $st->execute();
  $row=$st->get_result()->fetch_assoc();
  if($row && password_verify($p,$row['password_hash'])){
    $_SESSION=[
      'user_id'=>$row['id'],
      'username'=>$row['username'],
      'full_name'=>$row['full_name'],
      'role'=>$row['role']
    ];
    header('Location: index.php');exit;
  } else $msg='نام کاربری یا رمز عبور اشتباه است.';
}
?>
<!doctype html>
<html lang="fa" dir="rtl">
<head>
<meta charset="utf-8">
<title>ورود — سلام‌بابا</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="stylesheet" href="assets/style.css">
<style>
body {
  display:flex;
  justify-content:center;
  align-items:center;
  min-height:100vh;
  background:var(--bg);
  font-family:'IRANYekan','IRANSans',Tahoma,Arial,sans-serif;
}
.login-box {
  width:100%;
  max-width:400px;
  background:var(--card);
  border:1px solid var(--border);
  border-radius:16px;
  box-shadow:0 10px 28px rgba(15,23,42,.08);
  padding:24px;
}
.login-box header {
  text-align:center;
  margin-bottom:20px;
}
.login-box .logo {
  font-size:26px;
  font-weight:800;
  display:inline-flex;
  align-items:center;
  gap:8px;
}
.logo:before {
  content:'';
  width:16px;
  height:16px;
  border-radius:50%;
  background:conic-gradient(from 0deg,#0ea5e9 0 25%,#22c55e 0 50%,#facc15 0 75%,#ef4444 0 100%);
}
.note {
  color:#b91c1c;
  background:#fee2e2;
  border:1px solid #fecaca;
  padding:10px;
  border-radius:10px;
  margin-bottom:12px;
  text-align:center;
}
.field {margin-bottom:14px;}
.field span {display:block;margin-bottom:6px;font-size:14px;color:var(--muted);}
input {
  width:100%;
  padding:10px;
  border:1px solid var(--border);
  border-radius:10px;
  background:var(--card);
  color:var(--text);
  font-family:'IRANYekan','IRANSans',Tahoma,Arial,sans-serif;
}
input:focus {
  border-color:var(--brand);
  box-shadow:0 0 0 3px rgba(10,99,246,.2);
  outline:none;
}
.btn {
  width:100%;
  background:var(--brand);
  color:#fff;
  border:none;
  padding:12px;
  border-radius:10px;
  font-weight:700;
  cursor:pointer;
  font-family:'IRANYekan','IRANSans',Tahoma,Arial,sans-serif;
}
.btn:hover {opacity:.9;}
@media(max-width:480px){
  .login-box{margin:0 16px;padding:20px;}
  .logo{font-size:22px;}
}
</style>
</head>
<body>
  <div class="login-box">
    <header>
      <div class="logo">سلام‌بابا</div>
      <p style="color:var(--muted);font-size:13px;">سیستم ورود فروشندگان</p>
    </header>

    <?php if($msg):?>
      <div class="note"><?=$msg?></div>
    <?php endif;?>

    <form method="post">
      <label class="field">
        <span>نام کاربری</span>
        <input name="username" required autofocus>
      </label>
      <label class="field">
        <span>رمز عبور</span>
        <input type="password" name="password" required>
      </label>
      <button class="btn primary">ورود به حساب</button>
    </form>
  </div>
</body>
</html>
