<?php
require __DIR__.'/includes/auth.php';
require __DIR__.'/includes/config.php';
require __DIR__.'/includes/db_connect.php';
?>
<!doctype html>
<html lang="fa" dir="rtl">
<meta charset="utf-8">
<title>ثبت فاکتور چندمرحله‌ای | سلام‌بابا</title>
<link rel="stylesheet" href="assets/style.css">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/persian-datepicker@1.2.0/dist/css/persian-datepicker.min.css">
<script src="https://cdn.jsdelivr.net/npm/jquery@3.7.1/dist/jquery.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/persian-date@1.1.0/dist/persian-date.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/persian-datepicker@1.2.0/dist/js/persian-datepicker.min.js"></script>

<body>
<div class="container">
<header class="brand">
  <div class="logo">سلام‌بابا</div>
  <div class="userbox">
    <a class="btn ghost" href="orders.php">بازگشت</a>
    <a class="btn danger" href="logout.php">خروج</a>
  </div>
</header>

<section class="card">
  <h3>🧾 ثبت فاکتور جدید (مرحله‌ای)</h3>

  <!-- 🔹 مراحل -->
  <div id="steps" class="steps">
    <div class="step active" data-step="1">۱. مشخصات مشتری</div>
    <div class="step" data-step="2">۲. اقلام خرید</div>
    <div class="step" data-step="3">۳. بررسی و ثبت</div>
  </div>

  <form id="orderForm">
    <!-- 🔸 مرحله ۱ -->
    <div class="step-pane" data-step="1">
      <label class="field"><span>نام مشتری</span><input name="customer_name" required></label>
      <label class="field"><span>آدرس</span><input name="address" required></label>
      <label class="field"><span>فروشنده</span><input name="seller_name" value="<?=htmlspecialchars($_SESSION['username'])?>" required></label>

      <label class="field"><span>گارانتی</span>
        <select name="warranty">
          <option value="none">ندارد</option>
          <option value="gold">طلایی</option>
          <option value="silver">نقره‌ای</option>
        </select>
      </label>

      <label class="field"><span>تاریخ خرید (شمسی)</span>
        <input id="purchase_date_sh" name="purchase_date_sh" required>
        <input type="hidden" id="purchase_date" name="purchase_date">
      </label>

      <button type="button" class="btn primary nextBtn">ادامه ⏩</button>
    </div>

    <!-- 🔸 مرحله ۲ -->
    <div class="step-pane hidden" data-step="2">
      <h4>اقلام خرید</h4>
      <div id="itemsWrap"></div>
      <button type="button" id="addItemBtn" class="btn ghost">➕ افزودن قلم</button>

      <div style="margin-top:15px;">
        <button type="button" class="btn ghost prevBtn">⏪ بازگشت</button>
        <button type="button" class="btn primary nextBtn">ادامه ⏩</button>
      </div>
    </div>

    <!-- 🔸 مرحله ۳ -->
    <div class="step-pane hidden" data-step="3">
      <h4>بررسی نهایی</h4>
      <label class="field"><span>برداشت از حساب</span><input type="number" name="withdraw_amount" placeholder="در صورت نیاز"></label>
      <label class="field"><span>توضیح برداشت</span><input name="withdraw_note"></label>
      <label class="field"><span>توضیحات کلی</span><textarea name="notes" rows="2"></textarea></label>

      <div style="margin-top:15px;">
        <button type="button" class="btn ghost prevBtn">⏪ بازگشت</button>
        <button type="submit" class="btn primary">ثبت فاکتور ✅</button>
      </div>
      <div id="result" style="margin-top:10px;font-weight:bold;"></div>
    </div>
  </form>
</section>
</div>

<style>
.steps {display:flex;gap:5px;margin-bottom:10px;justify-content:center;}
.step {padding:6px 10px;border-radius:10px;background:#eee;cursor:pointer;font-weight:bold;}
.step.active{background:#2563eb;color:#fff;}
.step-pane{display:block;}
.step-pane.hidden{display:none;}
.itemRow{display:flex;gap:5px;margin-bottom:5px;align-items:center;}
.itemRow input{flex:1;}
</style>

<script>
// تقویم شمسی
$("#purchase_date_sh").persianDatepicker({
  format: "YYYY/MM/DD",
  initialValueType: "persian",
  autoClose: true,
  initialValue: true,
  onSelect: function(unix){
    const g = new persianDate(unix).toCalendar('gregorian').format("YYYY-MM-DD");
    $("#purchase_date").val(g);
  }
});
$("#purchase_date").val(new persianDate().toCalendar('gregorian').format("YYYY-MM-DD"));

// افزودن اقلام
function addItemRow(){
  const id = Date.now();
  const row = `
  <div class="itemRow">
    <input name="items[${id}][model]" placeholder="مدل">
    <input name="items[${id}][price]" type="number" placeholder="قیمت">
    <input name="items[${id}][deposit]" type="number" placeholder="بیعانه">
    <input name="items[${id}][cod]" type="number" placeholder="COD">
    <button type="button" onclick="this.parentElement.remove()">🗑</button>
  </div>`;
  $("#itemsWrap").append(row);
}
$("#addItemBtn").click(addItemRow);
addItemRow();

// کنترل مراحل
const steps = document.querySelectorAll('.step');
const panes = document.querySelectorAll('.step-pane');
let current = 1;

function showStep(n){
  current = n;
  steps.forEach(s=>s.classList.toggle('active', s.dataset.step==n));
  panes.forEach(p=>p.classList.toggle('hidden', p.dataset.step!=n));
}
$('.nextBtn').click(()=>showStep(current+1));
$('.prevBtn').click(()=>showStep(current-1));
steps.forEach(s=>s.onclick=()=>showStep(parseInt(s.dataset.step)));

// ارسال فرم
$("#orderForm").on("submit", async function(e){
  e.preventDefault();
  const fd = new FormData(this);
  const res = await fetch("send.php",{method:"POST",body:fd});
  const text = await res.text();
  if(text.startsWith("❌")){
    $("#result").css("color","red").text(text);
  } else {
    $("#result").css("color","green").text("✅ فاکتور با موفقیت ثبت شد");
    setTimeout(()=>location.href="orders.php",1500);
  }
});
</script>
</body>
</html>
