<?php
require __DIR__.'/includes/auth.php';
require __DIR__.'/includes/config.php';
require __DIR__.'/includes/db_connect.php';
require __DIR__.'/includes/jdf.php'; // ✅ اضافه شد

$user = $_SESSION['username'];
$role = $_SESSION['role'] ?? '';
$is_admin = ($role === 'admin');

function nf($n){return number_format((int)$n,0,'.',',');}

// 🧩 تبدیل تاریخ میلادی به شمسی با اعداد انگلیسی
function toJalaliEn($date){
  if(!$date || !preg_match('/^\d{4}-\d{2}-\d{2}$/',$date)) return '-';
  list($gy,$gm,$gd)=explode('-',$date);
  $j=gregorian_to_jalali((int)$gy,(int)$gm,(int)$gd,'/');
  return strtr($j, ['۰'=>'0','۱'=>'1','۲'=>'2','۳'=>'3','۴'=>'4','۵'=>'5','۶'=>'6','۷'=>'7','۸'=>'8','۹'=>'9']);
}

// فیلترها
$brand  = trim($_GET['brand'] ?? '');
$month  = (int)($_GET['month'] ?? 0);
$year   = (int)($_GET['year'] ?? 0);
$seller = $is_admin ? trim($_GET['seller'] ?? '') : $user;

// شرط فیلتر دینامیک
$where = "1";
if($brand) $where .= " AND oi.model LIKE '%".$mysqli->real_escape_string($brand)."%'";

// 🧩 اگر فیلتر سال یا ماه وارد شده، از تبدیل شمسی → میلادی استفاده کن
if($year > 0 || $month > 0){
  $jy = $year ?: jdate('Y'); // اگر سال انتخاب نشده، سال جاری شمسی
  $jm = $month ?: 1;         // اگر ماه انتخاب نشده، از اول سال
  list($gsY,$gsM,$gsD) = jalali_to_gregorian($jy,$jm,1,'-');
  if($month > 0) {
    // اگر ماه انتخاب شده، تا ماه بعدی
    $nextY = ($month==12)?$jy+1:$jy;
    $nextM = ($month==12)?1:$month+1;
    list($geY,$geM,$geD) = jalali_to_gregorian($nextY,$nextM,1,'-');
  } else {
    // فقط سال انتخاب شده
    list($geY,$geM,$geD) = jalali_to_gregorian($jy+1,1,1,'-');
  }
  $where .= " AND o.purchase_date >= '{$gsY}-{$gsM}-{$gsD}' AND o.purchase_date < '{$geY}-{$geM}-{$geD}'";
}

if(!$is_admin) $where .= " AND o.username='".$mysqli->real_escape_string($seller)."'";
elseif($seller) $where .= " AND o.username='".$mysqli->real_escape_string($seller)."'";

// کوئری جزئیات فروش
$sql = "
SELECT oi.model, oi.price, o.username, o.purchase_date
FROM order_items oi
JOIN orders o ON o.id=oi.order_id
WHERE $where
ORDER BY o.purchase_date DESC
";
$result = $mysqli->query($sql);
$rows = $result->fetch_all(MYSQLI_ASSOC);

// جمع آمار
$total_items = count($rows);
$total_value = 0;
$brand_summary = [];
$seller_summary = [];
foreach($rows as $r){
  $total_value += (int)$r['price'];
  $m = strtoupper(preg_replace('/[^A-Za-z0-9آ-ی]/','',$r['model']));
  $brandName = '';
  if(strpos($m,'LG')!==false) $brandName='LG';
  elseif(strpos($m,'SAMSUNG')!==false) $brandName='SAMSUNG';
  elseif(strpos($m,'SONY')!==false) $brandName='SONY';
  elseif(strpos($m,'TCL')!==false) $brandName='TCL';
  elseif(strpos($m,'XIAOMI')!==false) $brandName='XIAOMI';
  else $brandName='سایر برندها';
  $brand_summary[$brandName] = ($brand_summary[$brandName] ?? 0) + (int)$r['price'];
  $seller_summary[$r['username']] = ($seller_summary[$r['username']] ?? 0) + (int)$r['price'];
}

// فروشنده‌ها برای ادمین
$sellers = [];
if($is_admin){
  $q=$mysqli->query("SELECT username, full_name FROM users WHERE role='seller' ORDER BY username");
  $sellers=$q->fetch_all(MYSQLI_ASSOC);
}
?>
<!doctype html>
<html lang="fa" dir="rtl">
<meta charset="utf-8">
<title>📈 گزارش تحلیلی فروش | سلام‌بابا</title>
<link rel="stylesheet" href="assets/style.css">
<script src="https://cdn.jsdelivr.net/npm/chart.js@4.4.0/dist/chart.umd.min.js"></script>
<style>
.filters{display:flex;flex-wrap:wrap;gap:10px;margin-bottom:15px;}
.filters select,.filters input{padding:6px 8px;border:1px solid #ccc;border-radius:6px;}
.table-wrapper{overflow-x:auto;margin-top:15px;}
table{width:100%;border-collapse:collapse;font-size:14px;}
th,td{border-bottom:1px solid #eee;padding:6px;text-align:center;}
th{background:#f3f4f6;}
.summary{display:flex;gap:15px;margin:10px 0;font-weight:bold;flex-wrap:wrap;}
.summary div{background:#f8fafc;padding:10px 15px;border-radius:8px;box-shadow:0 1px 2px rgba(0,0,0,.05);}
.charts{display:flex;flex-wrap:wrap;gap:20px;margin-top:20px;}
.chartBox{flex:1;min-width:300px;background:#fff;border:1px solid #eee;border-radius:10px;padding:15px;}
</style>

<body>
<div class="container">
<?php require __DIR__.'/includes/header.php'; ?>

<section class="card">
  <h3>📊 گزارش تحلیلی فروش (شمسی)</h3>

  <form class="filters" method="get">
    <input type="text" name="brand" placeholder="🔍 برند یا مدل (مثلاً LG)" value="<?=htmlspecialchars($brand)?>">

    <select name="month">
      <option value="0" <?=$month==0?'selected':''?>>📅 همه ماه‌ها</option>
      <?php
      $months=['فروردین','اردیبهشت','خرداد','تیر','مرداد','شهریور','مهر','آبان','آذر','دی','بهمن','اسفند'];
      for($m=1;$m<=12;$m++): ?>
        <option value="<?=$m?>" <?=$m==$month?'selected':''?>><?=$months[$m-1]?></option>
      <?php endfor; ?>
    </select>

    <select name="year">
      <option value="0" <?=$year==0?'selected':''?>>📆 همه سال‌ها</option>
      <?php for($y=1400;$y<=1404;$y++): ?>
        <option value="<?=$y?>" <?=$y==$year?'selected':''?>><?=$y?></option>
      <?php endfor; ?>
    </select>

    <?php if($is_admin): ?>
    <select name="seller">
      <option value="">👥 همه فروشنده‌ها</option>
      <?php foreach($sellers as $s): ?>
        <option value="<?=$s['username']?>" <?=$seller==$s['username']?'selected':''?>><?=$s['full_name']?> (<?=$s['username']?>)</option>
      <?php endforeach; ?>
    </select>
    <?php endif; ?>

    <button class="btn primary">نمایش گزارش</button>
  </form>

  <div class="summary">
    <div>🛒 تعداد فروش: <b><?=$total_items?></b></div>
    <div>💰 مبلغ کل: <b><?=nf($total_value)?></b> تومان</div>
    <?php if($total_items>0): ?>
    <div>📉 میانگین فروش: <b><?=nf(round($total_value/$total_items))?></b> تومان</div>
    <?php endif; ?>
    <?php if($brand): ?><div>🏷 برند جستجو: <b><?=htmlspecialchars($brand)?></b></div><?php endif; ?>
  </div>

  <div class="charts">
    <div class="chartBox">
      <h4>📊 فروش بر اساس فروشنده</h4>
      <canvas id="sellerChart" height="250"></canvas>
    </div>
    <div class="chartBox">
      <h4>🥧 سهم برندها از کل فروش</h4>
      <canvas id="brandChart" height="250"></canvas>
    </div>
  </div>

  <div class="table-wrapper">
  <table>
    <thead>
      <tr>
        <?php if($is_admin): ?><th>فروشنده</th><?php endif; ?>
        <th>مدل کالا</th>
        <th>قیمت</th>
        <th>تاریخ خرید (شمسی)</th>
      </tr>
    </thead>
    <tbody>
      <?php if(!$rows): ?>
        <tr><td colspan="<?=$is_admin?4:3?>">هیچ فروشی یافت نشد</td></tr>
      <?php else: foreach($rows as $r): ?>
        <tr>
          <?php if($is_admin): ?><td><?=htmlspecialchars($r['username'])?></td><?php endif; ?>
          <td><?=htmlspecialchars($r['model'])?></td>
          <td><?=nf($r['price'])?></td>
          <td><?=toJalaliEn($r['purchase_date'])?></td>
        </tr>
      <?php endforeach; endif; ?>
    </tbody>
  </table>
  </div>
</section>
</div>

<script src="https://cdn.jsdelivr.net/npm/chart.js@4.4.0/dist/chart.umd.min.js"></script>
<script>
const sellerData = <?=json_encode($seller_summary, JSON_UNESCAPED_UNICODE)?>;
const brandData  = <?=json_encode($brand_summary, JSON_UNESCAPED_UNICODE)?>;
if(Object.keys(sellerData).length){
  new Chart(document.getElementById('sellerChart'), {
    type: 'bar',
    data: { labels: Object.keys(sellerData),
      datasets: [{ label: 'مبلغ فروش (تومان)', data: Object.values(sellerData),
        backgroundColor: 'rgba(37,99,235,0.7)', borderRadius: 5 }] },
    options: { scales:{y:{beginAtZero:true}}, plugins:{legend:{display:false}} }
  });
}
if(Object.keys(brandData).length){
  new Chart(document.getElementById('brandChart'), {
    type: 'pie',
    data: { labels: Object.keys(brandData),
      datasets: [{ data: Object.values(brandData),
        backgroundColor:['#2563eb','#16a34a','#f59e0b','#dc2626','#7c3aed','#9ca3af'] }] },
    options: { plugins:{legend:{position:'bottom'}} }
  });
}
</script>
</body>
</html>
