<?php
require __DIR__.'/includes/auth.php';
require __DIR__.'/includes/config.php';
require __DIR__.'/includes/db_connect.php';
require __DIR__.'/includes/jdf.php';

if(($_SESSION['role'] ?? '') !== 'admin'){
  die('<p style="color:red;text-align:center">دسترسی غیرمجاز</p>');
}

$user = $_GET['username'] ?? '';
if(!$user){
  die('<p style="text-align:center">فروشنده مشخص نشده است.</p>');
}

function nf($n){return number_format((int)$n,0,'.',',');}

// فیلتر ماهیانه
$month = $_GET['month'] ?? date('Y-m');
list($y,$m)=explode('-',$month);
$monthStart="$y-$m-01 00:00:00";
$monthEnd=date('Y-m-t 23:59:59',strtotime($monthStart));

// مجموع واریز و برداشت
$q = $mysqli->prepare("
  SELECT
    COALESCE(SUM(total_deposit),0) AS total_deposit,
    (
      SELECT COALESCE(SUM(w.amount),0)
      FROM withdrawals w
      JOIN orders o2 ON o2.id=w.order_id
      WHERE o2.username=?
      AND w.created_at BETWEEN ? AND ?
    ) AS total_withdraw
  FROM orders o
  WHERE username=? AND o.created_at BETWEEN ? AND ?
");
$q->bind_param('ssssss',$user,$monthStart,$monthEnd,$user,$monthStart,$monthEnd);
$q->execute();
$d=$q->get_result()->fetch_assoc();
$totalDeposit=(int)$d['total_deposit'];
$totalWithdraw=(int)$d['total_withdraw'];
$balance=$totalDeposit-$totalWithdraw;
?>

<!doctype html>
<html lang="fa" dir="rtl">
<meta charset="utf-8">
<title>گردش حساب <?=htmlspecialchars($user)?> | سلام‌بابا</title>
<link rel="stylesheet" href="assets/style.css">
<style>
body{font-family:'IRANYekan',sans-serif;background:#f7f7f9;}
.container{max-width:1100px;margin:30px auto;background:#fff;padding:25px;border-radius:12px;}
.finance-summary{display:flex;flex-wrap:wrap;gap:15px;justify-content:center;text-align:center;margin-bottom:20px;}
.finance-summary .item{flex:1 1 200px;background:#f8fafc;border:1px solid #eee;border-radius:10px;padding:15px;}
.finance-table{width:100%;border-collapse:collapse;}
.finance-table th,.finance-table td{border:1px solid #eee;padding:8px;text-align:center;}
.finance-table th{background:#f1f5f9;}
@media(max-width:768px){
  .finance-table{font-size:13px;}
  .finance-summary .item{flex:1 1 100px;}
}
</style>
<body>
<div class="container">
<h2>📋 گردش حساب فروشنده: <?=htmlspecialchars($user)?></h2>

<form method="get" style="text-align:center;margin-bottom:15px;">
  <input type="hidden" name="username" value="<?=htmlspecialchars($user)?>">
  <label>ماه:</label>
  <input type="month" name="month" value="<?=$month?>">
  <button type="submit">نمایش</button>
</form>

<div class="finance-summary">
  <div class="item">💵 جمع بیعانه‌ها<br><b><?=nf($totalDeposit)?> تومان</b></div>
  <div class="item">💸 جمع برداشت‌ها<br><b><?=nf($totalWithdraw)?> تومان</b></div>
  <div class="item">🏦 مانده حساب<br><b><?=nf($balance)?> تومان</b></div>
</div>

<table class="finance-table">
  <thead>
    <tr>
      <th>#</th>
      <th>نام مشتری</th>
      <th>شماره تماس</th>
      <th>تاریخ فاکتور</th>
      <th>بیعانه</th>
      <th>برداشت</th>
      <th>مانده پس از تراکنش</th>
      <th>شماره فاکتور</th>
    </tr>
  </thead>
  <tbody>
  <?php
  $q2 = $mysqli->prepare("
    SELECT o.id,o.customer_name,o.phone,o.created_at,o.total_deposit,
      COALESCE((
        SELECT SUM(w.amount) FROM withdrawals w WHERE w.order_id=o.id
      ),0) AS total_withdraw
    FROM orders o
    WHERE o.username=? AND o.created_at BETWEEN ? AND ?
    ORDER BY o.created_at DESC
  ");
  $q2->bind_param('sss',$user,$monthStart,$monthEnd);
  $q2->execute();
  $res=$q2->get_result();
  $i=1;$running=0;
  while($r=$res->fetch_assoc()):
    $running += ($r['total_deposit'] - $r['total_withdraw']);
  ?>
    <tr>
      <td><?=$i++?></td>
      <td><?=htmlspecialchars($r['customer_name'])?></td>
      <td><?=htmlspecialchars($r['phone'])?></td>
      <td><?=toJalaliEn(substr($r['created_at'],0,10))?></td>
      <td><?=nf($r['total_deposit'])?></td>
      <td><?=nf($r['total_withdraw'])?></td>
      <td><?=nf($running)?></td>
      <td><a href="view_order.php?id=<?=$r['id']?>">🧾 <?=$r['id']?></a></td>
    </tr>
  <?php endwhile; ?>
  </tbody>
</table>

</div>
</body>
</html>
