
<?php
$user = $_SESSION['username'] ?? '';
$role = $_SESSION['role'] ?? '';
require_once __DIR__.'/db_connect.php';

// گرفتن نام کامل از دیتابیس
$full_name = '';
if($user){
  $stmt = $mysqli->prepare("SELECT full_name FROM users WHERE username=? LIMIT 1");
  $stmt->bind_param("s", $user);
  $stmt->execute();
  $stmt->bind_result($full_name);
  $stmt->fetch();
  $stmt->close();
}
?>
<header class="brand">
  <div class="logo">سلام‌بابا</div>
  <div class="userbox">
    <span class="user-info">👤 <?=htmlspecialchars($full_name ?: $user)?> (<?=htmlspecialchars($user)?>)</span>
            <a class="btn ghost" href="../orders">📦 فاکتور جدید</a>

    <a class="btn ghost" href="orders.php">📦 فاکتورها</a>
    <a class="btn ghost" href="dashboard.php">💰 داشبورد مالی</a>
    <?php if($role === 'admin'): ?>
      <a class="btn ghost" href="reports.php">📊 گزارش ماهانه</a>
    <?php endif; ?>
    <a class="btn danger" href="logout.php">خروج</a>
  </div>
</header>

<style>
.user-info {
  background:#f3f4f6;
  padding:5px 10px;
  border-radius:8px;
  margin-left:8px;
  font-weight:bold;
  color:#374151;
}
</style>
