<?php
require __DIR__.'/includes/auth.php';
require __DIR__.'/includes/config.php';
require __DIR__.'/includes/db_connect.php';

$user = $_SESSION['username'];
$role = $_SESSION['role'] ?? '';
$is_admin = ($role === 'admin');
function nf($n){return number_format((int)$n,0,'.',',');}
?>
<!doctype html>
<html lang="fa" dir="rtl">
<meta charset="utf-8">
<title>📊 داشبورد مالی | سلام‌بابا</title>
<link rel="stylesheet" href="assets/style.css">
<style>
/* ====== طراحی عمومی ====== */
.table-wrapper {overflow-x:auto;margin-top:15px;}
table {border-collapse:collapse;width:100%;font-size:14px;}
th,td {padding:8px 10px;border-bottom:1px solid #eee;text-align:center;}
th {background:#f3f4f6;cursor:pointer;white-space:nowrap;}
th.sort-asc::after {content:" ▲";}
th.sort-desc::after {content:" ▼";}
tr:hover {background:#f9fafb;}
input#searchBox {width:200px;padding:6px 10px;border:1px solid #ccc;border-radius:6px;margin-bottom:8px;}
.pagination {display:flex;justify-content:center;gap:5px;margin-top:10px;}
.pagination button {padding:5px 10px;border:none;border-radius:6px;background:#e5e7eb;cursor:pointer;}
.pagination button.active {background:#2563eb;color:#fff;}
.stats {display:flex;gap:10px;flex-wrap:wrap;justify-content:center;text-align:center;}
.stat {flex:1;min-width:180px;background:#f8fafc;border:1px solid #ddd;border-radius:12px;padding:15px;box-shadow:0 1px 2px rgba(0,0,0,.05);}
.stat b{font-size:18px;}
</style>

<body>
<div class="container">
<?php require __DIR__.'/includes/header.php'; ?>

<section class="card">
  <h3>💰 داشبورد مالی</h3>

<?php if($is_admin): ?>
  <input type="text" id="searchBox" placeholder="🔍 جستجو در فروشنده‌ها...">
  <div class="table-wrapper">
  <table id="sellerTable">
    <thead>
      <tr>
        <th data-type="text">👤 فروشنده</th>
        <th data-type="text">نام کامل</th>
        <th data-type="num">بیعانه‌ها</th>
        <th data-type="num">برداشت‌ها</th>
        <th data-type="num">مانده حساب</th>
      </tr>
    </thead>
    <tbody>
    <?php
    $res = $mysqli->query("
      SELECT username, full_name, balance,
        (SELECT COALESCE(SUM(total_deposit),0) FROM orders WHERE username=u.username) AS total_deposit,
        (SELECT COALESCE(SUM(w.amount),0)
          FROM withdrawals w
          JOIN orders o ON o.id=w.order_id
          WHERE o.username=u.username) AS total_withdraw
      FROM users u
      WHERE role='seller'
      ORDER BY username
    ");
    while($r = $res->fetch_assoc()):
      $remain = (int)$r['balance'];
      $color = $remain >= 0 ? 'green' : 'red';
    ?>
      <tr>
        <td><?=htmlspecialchars($r['username'])?></td>
        <td><?=htmlspecialchars($r['full_name'])?></td>
        <td><?=nf($r['total_deposit'])?></td>
        <td><?=nf($r['total_withdraw'])?></td>
        <td style="color:<?=$color?>;font-weight:bold;"><?=nf($remain)?></td>
      </tr>
    <?php endwhile; ?>
    </tbody>
  </table>
  </div>
  <div class="pagination" id="pagination"></div>

<?php else: ?>
  <?php
  $stmt = $mysqli->prepare("
    SELECT
      COALESCE(SUM(total_deposit),0) AS total_deposit,
      (
        SELECT COALESCE(SUM(w.amount),0)
        FROM withdrawals w
        JOIN orders o2 ON o2.id=w.order_id
        WHERE o2.username=?
      ) AS total_withdraw,
      (SELECT balance FROM users WHERE username=?) AS balance
    FROM orders o
    WHERE username=?
  ");
  $stmt->bind_param('sss',$user,$user,$user);
  $stmt->execute();
  $data = $stmt->get_result()->fetch_assoc();
  $remain = (int)$data['balance'];
  $total_deposit = (int)$data['total_deposit'];
  $total_withdraw = (int)$data['total_withdraw'];
  ?>
  <div class="stats">
    <div class="stat">💵 جمع بیعانه‌ها<br><b><?=nf($total_deposit)?></b> تومان</div>
    <div class="stat">💸 جمع برداشت‌ها<br><b><?=nf($total_withdraw)?></b> تومان</div>
    <div class="stat">🏦 مانده حساب<br><b style="color:<?=($remain>=0?'green':'red')?>"><?=nf($remain)?></b> تومان</div>
  </div>
<?php endif; ?>
</section>

<script>
// ====================== مرتب‌سازی، جستجو و صفحه‌بندی ======================
const rowsPerPage = 15;
let currentPage = 1;
let sortDir = 'asc';
let sortIndex = -1;

const table = document.getElementById('sellerTable');
if (table) {
  const tbody = table.querySelector('tbody');
  let rows = Array.from(tbody.querySelectorAll('tr'));

  function renderTable() {
    const searchVal = document.getElementById('searchBox').value.trim().toLowerCase();
    let filtered = rows.filter(r =>
      r.innerText.toLowerCase().includes(searchVal)
    );

    // مرتب‌سازی
    if (sortIndex >= 0) {
      const th = table.querySelectorAll('th')[sortIndex];
      const type = th.dataset.type;
      filtered.sort((a,b)=>{
        let A=a.cells[sortIndex].innerText.replace(/,/g,'').trim();
        let B=b.cells[sortIndex].innerText.replace(/,/g,'').trim();
        if(type==='num'){A=parseFloat(A)||0;B=parseFloat(B)||0;}
        else {A=A.toLowerCase();B=B.toLowerCase();}
        return sortDir==='asc' ? (A>B?1:-1) : (A<B?1:-1);
      });
    }

    // صفحه‌بندی
    const totalPages = Math.ceil(filtered.length / rowsPerPage);
    currentPage = Math.min(currentPage, totalPages) || 1;
    const start = (currentPage - 1) * rowsPerPage;
    const pageRows = filtered.slice(start, start + rowsPerPage);

    tbody.innerHTML = '';
    pageRows.forEach(r => tbody.appendChild(r));

    renderPagination(totalPages);
  }

  function renderPagination(totalPages) {
    const p = document.getElementById('pagination');
    p.innerHTML = '';
    for(let i=1;i<=totalPages;i++){
      const b=document.createElement('button');
      b.textContent=i;
      if(i===currentPage) b.classList.add('active');
      b.onclick=()=>{currentPage=i;renderTable();};
      p.appendChild(b);
    }
  }

  // مرتب‌سازی با کلیک روی سرستون
  table.querySelectorAll('th').forEach((th,i)=>{
    th.addEventListener('click',()=>{
      if(sortIndex===i) sortDir = sortDir==='asc'?'desc':'asc';
      else { sortIndex=i; sortDir='asc'; }
      table.querySelectorAll('th').forEach(t=>t.classList.remove('sort-asc','sort-desc'));
      th.classList.add(sortDir==='asc'?'sort-asc':'sort-desc');
      renderTable();
    });
  });

  // جستجوی زنده
  document.getElementById('searchBox').addEventListener('input',()=>{currentPage=1;renderTable();});

  renderTable();
}
</script>
</div>
</body>
</html>
