<?php
require __DIR__.'/includes/jdf.php';
require __DIR__.'/includes/auth.php';
require __DIR__.'/includes/db_connect.php';
require __DIR__.'/includes/config.php';

$id = (int)($_GET['id'] ?? 0);
if ($id <= 0) exit('bad id');
$o = $mysqli->query('SELECT * FROM orders WHERE id='.$id)->fetch_assoc();
if (!$o) exit('not found');
$items = $mysqli->query('SELECT * FROM order_items WHERE order_id='.$id);

function nf($n){ return number_format((int)$n,0,'.',','); }
function toJalaliEn($date){
  if(!$date || !preg_match('/^\d{4}-\d{2}-\d{2}$/',$date)) return '-';
  list($gy,$gm,$gd)=explode('-',$date);
  $j=gregorian_to_jalali((int)$gy,(int)$gm,(int)$gd,'/');
  return strtr($j, ['۰'=>'0','۱'=>'1','۲'=>'2','۳'=>'3','۴'=>'4','۵'=>'5','۶'=>'6','۷'=>'7','۸'=>'8','۹'=>'9']);
}

if (defined('TCPDF_PATH') && file_exists(TCPDF_PATH)) {
  require_once TCPDF_PATH;
  $pdf = new TCPDF('P', 'mm', 'A4', true, 'UTF-8', false);
  $pdf->SetCreator('Salambaba');
  $pdf->SetTitle('فاکتور فروش '.$o['invoice_no'].' | سلام‌بابا');
  $pdf->SetMargins(12, 20, 12, true);
  $pdf->SetAutoPageBreak(true, 15);
  $pdf->AddPage();

  // فونت فارسی
  $font_path = __DIR__.'/assets/fonts/IRANYekanRegular.ttf';
  if(file_exists($font_path)){
    $pdf->AddFont('iranyekan','','IRANYekanRegular.ttf',true);
    $pdf->SetFont('iranyekan','',11);
  } else {
    $pdf->SetFont('dejavusans','',11);
  }

  // QR Code لینک پیگیری
  $trackUrl = BASE_URL.'track.php?code='.urlencode($o['tracking_code']);
  $style = ['border'=>0, 'padding'=>1, 'fgcolor'=>[0,0,0], 'bgcolor'=>false];
  $pdf->write2DBarcode($trackUrl, 'QRCODE,H', 160, 15, 30, 30, $style, 'N');

  // هدر با لوگو و رنگ برند
  $header = '
  <div style="text-align:right;direction:rtl;font-family:iranyekan,DejaVuSans;">
    <table width="100%" cellpadding="6" cellspacing="0" border="0">
      <tr>
        <td width="70%">
          <h2 style="color:#111;margin:0;">فاکتور فروش — <span style="color:#2563eb;">سلام‌بابا</span></h2>
          <small style="color:#666;">شماره فاکتور: '.$o['invoice_no'].'</small><br>
          <small style="color:#666;">تاریخ (شمسی): '.toJalaliEn($o['purchase_date']).'</small>
        </td>
        <td width="30%" style="text-align:left;">
          <img src="'.__DIR__.'/assets/logo-salambaba.png" height="45">
        </td>
      </tr>
    </table>
    <div style="height:6px;background:linear-gradient(90deg,#2563eb,#16a34a,#f59e0b,#dc2626);border-radius:3px;margin-top:4px;"></div>
  </div>
  ';
  $pdf->writeHTML($header, false, false, true, false, '');

  // اطلاعات خریدار و فروشنده
  $html = '
  <br><table width="100%" border="0" cellpadding="5" style="direction:rtl;font-family:iranyekan,DejaVuSans;">
    <tr>
      <td><b>مشتری:</b> '.htmlspecialchars($o['customer_name']).'</td>
      <td><b>فروشنده:</b> '.htmlspecialchars($o['seller_name']).'</td>
    </tr>
    <tr>
      <td><b>گارانتی:</b> '.htmlspecialchars($o['warranty']).'</td>
      <td><b>پیگیری:</b> '.$trackUrl.'</td>
    </tr>
    <tr><td colspan="2"><b>آدرس:</b> '.htmlspecialchars($o['address']).'</td></tr>
  </table>';

  // جدول اقلام
  $html .= '
  <br><table width="100%" border="1" cellpadding="6" cellspacing="0" style="direction:rtl;text-align:center;font-family:iranyekan,DejaVuSans;">
    <thead>
      <tr style="background:#f3f4f6;font-weight:bold;">
        <th width="6%">#</th>
        <th width="38%">مدل کالا</th>
        <th width="14%">قیمت</th>
        <th width="14%">بیعانه</th>
        <th width="14%">COD</th>
        <th width="14%">مانده</th>
      </tr>
    </thead>
    <tbody>';
  $i = 1;
  foreach($items as $it){
    $html .= '<tr>
      <td>'.$i++.'</td>
      <td>'.htmlspecialchars($it['model']).'</td>
      <td>'.nf($it['price']).'</td>
      <td>'.nf($it['deposit']).'</td>
      <td>'.nf($it['cod']).'</td>
      <td>'.nf($it['remaining']).'</td>
    </tr>';
  }
  $html .= '</tbody></table>';

  // جمع نهایی
  $html .= '
  <br><table width="100%" border="0" cellpadding="5" style="direction:rtl;font-family:iranyekan,DejaVuSans;">
    <tr><td><b>جمع کل:</b></td><td>'.nf($o['total_amount']).' تومان</td></tr>
    <tr><td><b>بیعانه:</b></td><td>'.nf($o['total_deposit']).' تومان</td></tr>
    <tr><td><b>COD:</b></td><td>'.nf($o['total_cod']).' تومان</td></tr>
    <tr><td><b>مانده:</b></td><td>'.nf($o['total_remaining']).' تومان</td></tr>
  </table>
  <div style="margin-top:12px;text-align:center;color:#666;font-size:10pt;">
    قدرت‌گرفته از <b>سلام‌بابا</b> — <a href="'.BASE_URL.'" style="color:#2563eb">'.BASE_URL.'</a>
  </div>';

  // خروجی PDF با حالت دانلود
  $pdf->writeHTML($html, true, false, true, false, '');
  $pdf->Output('invoice-'.$o['invoice_no'].'.pdf', 'D'); // ← این باعث دانلود فایل می‌شود
  exit;
}
?>
<!doctype html>
<html lang="fa" dir="rtl">
<meta charset="utf-8">
<title>دانلود فاکتور — <?=htmlspecialchars($o['invoice_no'])?></title>
<link rel="stylesheet" href="assets/style.css">
<body>
<div class="container">
<header class="brand">
  <div class="logo">سلام‌بابا</div>
  <div class="userbox">
    <a class="btn ghost" href="orders.php">بازگشت</a>
    <a class="btn primary" href="invoice.php?id=<?=$id?>">📥 دانلود PDF</a>
    <a class="btn danger" href="index.php">ثبت جدید</a>
  </div>
</header>
<section class="card">
  <h3>دانلود فاکتور</h3>
  <p>برای دریافت فایل فاکتور روی دکمه بالا کلیک کنید.</p>
</section>
</div>
</body>
</html>
