<?php
require __DIR__.'/includes/auth.php';
require __DIR__.'/includes/config.php';
require __DIR__.'/includes/db_connect.php';
require __DIR__.'/includes/jdf.php';

$user = $_SESSION['username'];
$is_admin = ($_SESSION['role'] ?? '') === 'admin';

$where = $is_admin ? '1' : "username='".$mysqli->real_escape_string($user)."'";
$q = $mysqli->query("SELECT * FROM orders WHERE $where ORDER BY id DESC");

function nf($n){return number_format((int)$n,0,'.',',');}

// تبدیل تاریخ میلادی به شمسی با اعداد انگلیسی
function toJalaliEn($date){
  if(!$date || !preg_match('/^\d{4}-\d{2}-\d{2}$/',$date)) return '-';
  list($gy,$gm,$gd)=explode('-',$date);
  $j=gregorian_to_jalali((int)$gy,(int)$gm,(int)$gd,'/');
  // تبدیل اعداد فارسی به انگلیسی
  $en = strtr($j, ['۰'=>'0','۱'=>'1','۲'=>'2','۳'=>'3','۴'=>'4','۵'=>'5','۶'=>'6','۷'=>'7','۸'=>'8','۹'=>'9']);
  return $en;
}
?>
<!doctype html>
<html lang="fa" dir="rtl">
<meta charset="utf-8">
<title>لیست فاکتورها | سلام‌بابا</title>
<link rel="stylesheet" href="assets/style.css">
<body>
<div class="container">
<?php require __DIR__.'/includes/header.php'; ?>
<section class="card">
  <h3>📦 فاکتورهای ثبت‌شده</h3>

  <table class="table">
    <thead>
      <tr>
        <th>#</th>
        <th>مشتری</th>
        <th>فروشنده</th>
        <th>تاریخ</th>
        <th>جمع فروش</th>
        <th>بیعانه</th>
        <th>مانده</th>
        <th>وضعیت</th>
        <th>عملیات</th>
      </tr>
    </thead>
    <tbody>
      <?php if($q->num_rows==0): ?>
        <tr><td colspan="9" style="text-align:center;color:#777;">هیچ فاکتوری ثبت نشده</td></tr>
      <?php else: $i=1; while($r=$q->fetch_assoc()): ?>
        <tr>
          <td><?=$i++?></td>
          <td><?=htmlspecialchars($r['customer_name'])?></td>
          <td><?=htmlspecialchars($r['seller_name'])?></td>
          <td><?=toJalaliEn($r['purchase_date'])?></td>
          <td><?=nf($r['total_amount'])?></td>
          <td><?=nf($r['total_deposit'])?></td>
          <td><?=nf($r['total_remaining'])?></td>
          <td>
            <?php
            $s = $r['status'];
            $map = [
              'pending' => '🕓 در انتظار',
              'processing' => '🔧 آماده‌سازی',
              'shipped' => '🚚 ارسال شد',
              'delivered' => '✅ تحویل داده شد',
              'cancelled' => '❌ لغو شد'
            ];
            echo $map[$s] ?? 'نامشخص';
            ?>
          </td>
          <td>
            <a class="btn small" href="view.php?id=<?=$r['id']?>">👁 مشاهده</a>
            <a class="btn small ghost" href="edit.php?id=<?=$r['id']?>">✏️ ویرایش</a>
            <a class="btn small ghost" href="invoice.php?id=<?=$r['id']?>">🧾 PDF</a>
            <a class="btn small ghost" href="invoice_print.php?id=<?=$r['id']?>">🖨 پرینت</a>
            <?php if($is_admin): ?>
              <button class="btn small danger" onclick="deleteOrder(<?=$r['id']?>)">🗑 حذف</button>
            <?php endif; ?>
          </td>
        </tr>
      <?php endwhile; endif; ?>
    </tbody>
  </table>
</section>

<script>
async function deleteOrder(id){
  if(!confirm('آیا از حذف این فاکتور مطمئن هستید؟')) return;
  const fd = new FormData();
  fd.append('id', id);
  const r = await fetch('xhr_delete_order.php',{method:'POST',body:fd});
  const j = await r.json();
  alert(j.msg);
  if(j.ok) location.reload();
}
</script>
</div>
</body>
</html>
