<?php
require __DIR__.'/includes/auth.php';
require __DIR__.'/includes/config.php';
require __DIR__.'/includes/db_connect.php';
require __DIR__.'/includes/jdf.php';

$user = $_SESSION['username'];
$is_admin = ($_SESSION['role'] ?? '') === 'admin';

$where = $is_admin ? '1' : "username='".$mysqli->real_escape_string($user)."'";

$selectedYear = (int)($_GET['year'] ?? 0);
$selectedMonth = (int)($_GET['month'] ?? 0);

// تعیین بازه تاریخ میلادی بر اساس سال و ماه شمسی انتخاب‌شده
$yearStart = $monthStart = $yearEnd = $monthEnd = null;

if($selectedYear && $selectedMonth){ // فقط یک ماه خاص شمسی
    $startJ = "$selectedYear/$selectedMonth/01";
    $endJ = $selectedMonth == 12 ? ($selectedYear+1)."/01/01" : "$selectedYear/".($selectedMonth+1)."/01";
    list($gsY,$gsM,$gsD) = jalali_to_gregorian($selectedYear,$selectedMonth,1,'-');
    list($geY,$geM,$geD) = jalali_to_gregorian(($selectedMonth==12?$selectedYear+1:$selectedYear),($selectedMonth==12?1:$selectedMonth+1),1,'-');
    $where .= " AND purchase_date >= '{$gsY}-{$gsM}-{$gsD}' AND purchase_date < '{$geY}-{$geM}-{$geD}'";
}
elseif($selectedYear){ // فقط سال شمسی
    list($gsY,$gsM,$gsD) = jalali_to_gregorian($selectedYear,1,1,'-');
    list($geY,$geM,$geD) = jalali_to_gregorian($selectedYear+1,1,1,'-');
    $where .= " AND purchase_date >= '{$gsY}-{$gsM}-{$gsD}' AND purchase_date < '{$geY}-{$geM}-{$geD}'";
}
// اگر هیچ انتخابی نیست، همه تاریخ‌ها لحاظ می‌شن

$q = $mysqli->query("SELECT * FROM orders WHERE $where ORDER BY id DESC");
function nf($n){return number_format((int)$n,0,'.',',');}

function toJalaliEn($date){
    if(!$date || !preg_match('/^\d{4}-\d{2}-\d{2}$/',$date)) return '-';
    list($gy,$gm,$gd)=explode('-',$date);
    $j=gregorian_to_jalali((int)$gy,(int)$gm,(int)$gd,'/');
    return strtr($j, ['۰'=>'0','۱'=>'1','۲'=>'2','۳'=>'3','۴'=>'4','۵'=>'5','۶'=>'6','۷'=>'7','۸'=>'8','۹'=>'9']);
}
?>
<!doctype html>
<html lang="fa" dir="rtl">
<meta charset="utf-8">
<title>گزارش فاکتورها | سلام‌بابا</title>
<link rel="stylesheet" href="assets/style.css">
<body>
<div class="container">
<?php require __DIR__.'/includes/header.php'; ?>

<section class="card">
  <h3>📊 گزارش فاکتورها (بر اساس تاریخ شمسی)</h3>

  <form method="get" class="grid-3">
    <label class="field">
      <span>سال شمسی</span>
      <select name="year">
        <option value="0" <?=$selectedYear==0?'selected':''?>>📅 همه سال‌ها</option>
        <?php for($y=1398;$y<=1404;$y++): ?>
          <option value="<?=$y?>" <?=$selectedYear==$y?'selected':''?>><?=$y?></option>
        <?php endfor; ?>
      </select>
    </label>

    <label class="field">
      <span>ماه شمسی</span>
      <select name="month">
        <option value="0" <?=$selectedMonth==0?'selected':''?>>📅 همه ماه‌ها</option>
        <?php
        $months = ['فروردین','اردیبهشت','خرداد','تیر','مرداد','شهریور','مهر','آبان','آذر','دی','بهمن','اسفند'];
        foreach($months as $i=>$name): $m=$i+1; ?>
          <option value="<?=$m?>" <?=$selectedMonth==$m?'selected':''?>><?=$name?></option>
        <?php endforeach; ?>
      </select>
    </label>

    <div class="field">
      <span>&nbsp;</span>
      <button class="btn primary">فیلتر</button>
      <a href="reports.php" class="btn ghost">حذف فیلتر</a>
    </div>
  </form>
</section>

<section class="card">
  <table class="table">
    <thead>
      <tr>
        <th>#</th>
        <th>مشتری</th>
        <th>فروشنده</th>
        <th>تاریخ خرید (شمسی)</th>
        <th>جمع فروش</th>
        <th>بیعانه</th>
        <th>مانده</th>
        <th>وضعیت</th>
      </tr>
    </thead>
    <tbody>
      <?php
      if($q->num_rows==0){
        echo '<tr><td colspan="8" style="text-align:center;color:#777;">هیچ فاکتوری یافت نشد</td></tr>';
      } else {
        $i=1;
        while($r=$q->fetch_assoc()){
          echo '<tr>';
          echo '<td>'.($i++).'</td>';
          echo '<td>'.htmlspecialchars($r['customer_name']).'</td>';
          echo '<td>'.htmlspecialchars($r['seller_name']).'</td>';
          echo '<td>'.toJalaliEn($r['purchase_date']).'</td>';
          echo '<td>'.nf($r['total_amount']).'</td>';
          echo '<td>'.nf($r['total_deposit']).'</td>';
          echo '<td>'.nf($r['total_remaining']).'</td>';
          $map=[
            'pending'=>'🕓 در انتظار','processing'=>'🔧 آماده‌سازی',
            'shipped'=>'🚚 ارسال شد','delivered'=>'✅ تحویل داده شد','cancelled'=>'❌ لغو شد'
          ];
          echo '<td>'.($map[$r['status']] ?? 'نامشخص').'</td>';
          echo '</tr>';
        }
      }
      ?>
    </tbody>
  </table>
</section>

</div>
</body>
</html>
