<?php
require __DIR__.'/includes/config.php';
require __DIR__.'/includes/db_connect.php';
require __DIR__.'/includes/auth.php';
require __DIR__.'/includes/telegram.php';
header('Content-Type: application/json; charset=utf-8');

$user = $_SESSION['username'];
$amount = intval($_POST['amount'] ?? 0);
$note = trim($_POST['note'] ?? '');

if($amount <= 0){
  echo json_encode(['ok'=>false,'msg'=>'مبلغ معتبر نیست']);
  exit;
}

$msg = "📢 <b>درخواست برداشت جدید</b>\n"
     . "👨‍💼 فروشنده: <b>{$user}</b>\n"
     . "💰 مبلغ: " . number_format($amount) . " تومان\n";
if($note) $msg .= "📝 توضیح: {$note}\n";
$msg .= "⏰ زمان: " . date('Y/m/d H:i');

global $BOT_TOKEN, $CHAT_MAP;
if(isset($CHAT_MAP['admin'])){
  tg_send_message($BOT_TOKEN, $CHAT_MAP['admin'], $msg);
}

echo json_encode(['ok'=>true,'msg'=>'✅ درخواست برداشت ارسال شد']);
